package common.uibuilder;

import common.YosException;

import java.util.ArrayList;

public class AppControl<T> {

    public enum viewtype {
        tabgroup, tab, table, tablecol, form, formcol, input, checkbox
    }

    public String id;
    public viewtype type;
    public String label;
    public ArrayList<AppControl> ztrl = new ArrayList<>();

    public AppControl(viewtype type, String label) {
        AppUI.ControlIDs.put(type, AppUI.ControlIDs.getOrDefault(type, 0) + 1);
        this.id = type.toString() + "_" + AppUI.ControlIDs.get(type);
        this.type = type;
        this.label = label;
    }

    public T setID(String id) {
        this.id = id;
        return (T) this;
    }

    public T add(AppControl appControl) throws YosException {
        boolean ishave = false;
        int i = 0;
        for (AppControl v : ztrl) {
            if (v.id.equals(appControl.id)) {
                ztrl.set(i, appControl);
                ishave = true;
            }
            i++;
        }
        if (!ishave) {
            ztrl.add(appControl);
        }
        return (T) this;
    }

}
