package restcontroller.sysmanage.develop.api;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.annotation.CACHEING_CLEAN;
import common.annotation.cm;
import common.api.YOSAPI;
import common.data.SQLFactory;
import common.data.InsertSQL;
import common.data.UpdateSQL;
import restcontroller.R;
import restcontroller.sysmanage.develop.apimanage.ApiMonitor;

public class Api extends Controller {
    public Api(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "YOSapi接口参数更新", intervaltime = 2000, apiversion = R.ID10003401.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = ApiMonitor.class, method = {"queryApiList"})})
    public String updateApiParam() throws YosException {
        long apiid = content.getLong("apiid");
        int apiversion = content.getIntValue("apiversion", 1);
        long intervaltime = content.getLongValue("intervaltime");

        if (dbConnect.runSqlQuery("select *from sys_api where apiid='" + apiid + "' and apiversion='" + apiversion + "'").isEmpty()) {
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_api");
            insertSQL.setValue("apiid", apiid);
            insertSQL.setValue("apiversion", apiversion);
            insertSQL.setValue("intervaltime", intervaltime);
            insertSQL.insert();
        } else {
            UpdateSQL rowUpdate = SQLFactory.createUpdateSQL(this, "sys_api");
            rowUpdate.setValue("intervaltime", intervaltime);
            rowUpdate.setWhere("apiid", apiid);
            rowUpdate.setWhere("apiversion", apiversion);
            rowUpdate.update();
        }
        YOSAPI.setApiIntervaltime(apiid, apiversion, intervaltime);
        return getSucReturnObject().toString();
    }
}
