package common;

import beans.attachment.Attachment;
import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.api.YOSAPI;
import common.data.*;
import common.data.db.DataPool;
import common.parameter.parameter;
import org.apache.commons.fileupload.FileItem;
import restcontroller.ClientUserInfo;
import utility.huawei.obs.BucketFile;
import utility.tools.Encryption;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.*;

import static common.parameter.parameter.tokenlist;
import static common.parameter.parameter.usersiteIdList;

/**
 * API接口父类，所有接口类都必须继承该类
 */
public class Controller extends BaseClass {
    public ClientUserInfo userInfo;
    /**
     * 接口请求正文
     */
    public JSONObject content;
    /**
     * 接口返回对象
     */
    private ReturnObject returnObject;
    /**
     * 用户请求端
     */
    public String systemclient = "";
    /**
     * 分页查询接口的页码，缺省值：1
     */
    public int pageNumber = 1;
    /**
     * 分页查询接口的每页返回数量，缺省值：20
     */
    public int pageSize = 20;

    public int rowindex = 0;
    /**
     * 用户（账号）ID，公共接口该值为0
     */
    public long userid = 0L;
    /**
     * 用户（账号）站点数据ID，公共接口该值为0
     */
    public long usersiteid = 0L;
    /**
     * 用户（账号）类型，公共接口该值为0
     */
    public int usertype = 0;
    /**
     * 用户（账号）名称，公共接口该值为空
     */
    public String username = "";
    /**
     * 站点ID
     */
    public String siteid = "";
    /**
     * 用户手机号
     */
    public String phonenumber = "";
    /**
     * 用户部门ID
     */
    public long departmentid = 0L;
    /**
     * 内部人员的人员ID，外部人员为0，如商户人员
     */
    public long hrid = 0L;
    /**
     * 企业档案ID
     */
    public long sys_enterpriseid = 0L;
    /**
     * 用户是否为部门负责人或经销商负责人
     */
    public boolean isleader = false;
    public String pageSorting;
    public JSONArray pageSortingArray;
    // public JSONObject tablefilter = new JSONObject();

    public List<FileItem> requestFileItemList;


    public YOSAPI requestAPI;
    public YOSAPI.YosRequest request;
    private String accesstoken = "";

    /**
     * 构造函数
     *
     * @param content
     */
    public Controller(JSONObject content) throws YosException {
        super();
        try {
            this.dbConnect.setCreatesqllog(Parameter.get("system_db_sqllog").equalsIgnoreCase("true"));
        } catch (Exception e) {
            e.printStackTrace();
        }
        this.content = content;
        returnObject = new ReturnObject(this);
        if (this.content.containsKey("pageNumber")) {
            pageNumber = this.content.getIntValue("pageNumber");
        }
        if (this.content.containsKey("pageSize")) {
            pageSize = this.content.getIntValue("pageSize");
        }
        if (this.content.containsKey("rowindex")) {
            rowindex = this.content.getIntValue("rowindex");
        }
        if (this.content.containsKey("accesstoken")) {
            accesstoken = this.content.getString("accesstoken");
            if (tokenlist.containsKey(accesstoken)) {
                usersiteid = tokenlist.get(accesstoken);
            }
        }
//        if (this.content.containsKey("where") && this.content.getJSONObject("where").containsKey("tablefilter")) {
//            tablefilter = this.content.getJSONObject("where").getJSONObject("tablefilter");
//        }
        if (parameter.usersiteIdList.containsKey(usersiteid)) {
            Row row = parameter.usersiteIdList.get(usersiteid);
            userid = row.getLong("userid");
            siteid = row.getString("siteid");
            username = row.getString("name");
            phonenumber = row.getString("phonenumber");
            systemclient = row.getString("systemclient");
            departmentid = row.getLong("departmentid");
            usertype = row.getInteger("usertype");
            hrid = row.getLong("hrid");

            if (row.containsKey("sys_enterpriseid")) {
                sys_enterpriseid = row.getLong("sys_enterpriseid");
            } else {
                Row enterpriseRow = getEnterpriseByUserid(userid);
                sys_enterpriseid = enterpriseRow.getLong("sys_enterpriseid");
                row.put("sys_enterpriseid", sys_enterpriseid);
                parameter.usersiteIdList.put(usersiteid, row);
            }

            if (row.containsKey("isleader")) {
                isleader = row.getBoolean("isleader");
            } else {
                isleader = getHr(userid).getBoolean("isleader") || getEnterpriseHr(userid).getBoolean("isleader");
                row.put("isleader", isleader);
                parameter.usersiteIdList.put(usersiteid, row);
            }
        }
        if (siteid == null || siteid.equals("") || content.containsKey("siteid")) {
            siteid = (String) content.getOrDefault("siteid", "");
        }
        userInfo = new ClientUserInfo(this);
        userInfo.setUserId(userid);
        userInfo.setUserName(username);
        userInfo.setPhoneNumber(phonenumber);
        userInfo.setSiteId(siteid);
        userInfo.setUserSiteId(usersiteid);
        userInfo.setUserType(usertype);
    }
//
//    /**
//     * 获取表格过滤条件
//     *
//     * @param table_alias 表名或查询表别名
//     * @param fieldname   数据表字段名称
//     * @param exact       true 精确搜索 false模糊搜索
//     */
//    public String getTableFilter(String table_alias, String fieldname, boolean exact) throws YosException {
//        if (tablefilter.containsKey(fieldname) && !tablefilter.getString(fieldname).equals("")) {
//            if (exact) {
//                return " and " + table_alias + "." + fieldname + "='" + tablefilter.getString(fieldname) + "'";
//            } else {
//                return " and " + table_alias + "." + fieldname + " like'%" + tablefilter.getString(fieldname) + "%'";
//            }
//        }
//        return "";
//    }
//
//    /**
//     * 获取表格过滤条件
//     *
//     * @param table_alias 表名或查询表别名
//     * @param fieldname   数据表字段名称
//     * @param field_alias 前端字段名称
//     * @param exact       true 精确搜索 false模糊搜索
//     */
//    public String getTableFilter(String table_alias, String fieldname, String field_alias, boolean exact) throws YosException {
//        if (tablefilter.containsKey(field_alias) && !tablefilter.getString(field_alias).equals("")) {
//            if (exact) {
//                return " and " + table_alias + "." + fieldname + "='" + tablefilter.getString(field_alias) + "'";
//            } else {
//                return " and " + table_alias + "." + fieldname + " like'%" + tablefilter.getString(field_alias) + "%'";
//            }
//        }
//        return "";
//    }

    public void setYosapi(YOSAPI requestAPI, YOSAPI.YosRequest request) {
        this.requestAPI = requestAPI;
        this.request = request;
    }

    public String getAccesstoken() {
        return this.accesstoken;
    }

    public void setSorting() throws YosException {
        Sorting sorting = new Sorting(this, requestAPI);
        pageSorting = sorting.getOrderBy();
        pageSortingArray = sorting.getSorts();
    }

    public void setrequestFileItemList(List<FileItem> requestFileItemList) {
        this.requestFileItemList = requestFileItemList;
    }

    /**
     * 获取通过servlet接口上传的excel
     *
     * @return
     * @throws IOException
     */
    public ExcelFactory getPostExcelFactory() throws IOException {
        for (FileItem item : requestFileItemList) {
            if (!item.isFormField()) {
                String filename = new String(item.getName().getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
                filename = filename.substring(0, filename.lastIndexOf("."));
                return new ExcelFactory(filename, item.getInputStream());
            }
        }
        return null;
    }


    /**
     * 获取通过华为云上传的excel
     *
     * @return
     * @throws IOException
     */
    public ExcelFactory getPostExcelFactory(String obsObjectname) throws IOException, YosException {
        BucketFile bucketFile = new BucketFile(siteid);
        return new ExcelFactory(bucketFile.getObjectInputStream(obsObjectname));
    }


    /**
     * 获取通过华为云上传的excel
     *
     * @return
     * @throws IOException
     */
    public ExcelFactory getPostExcelFactory(Long attachmentid) throws IOException, YosException {
        Rows rows = dbConnect.runSqlQuery("select serialnumber from sys_attachment where siteid='" + siteid + "' and attachmentid=" + attachmentid);
        if (rows.isNotEmpty()) {
            return getPostExcelFactory(rows.get(0).getString("serialnumber"));
        }
        return null;
    }

    public InputStream getPostFileInputStream(String obsObjectname) throws YosException {
        BucketFile bucketFile = new BucketFile(siteid);
        return bucketFile.getObjectInputStream(obsObjectname);
    }

    public InputStream getPostFileInputStream(Long attachmentid) throws YosException {
        Rows rows = dbConnect.runSqlQuery("select serialnumber from sys_attachment where siteid='" + siteid + "' and attachmentid=" + attachmentid);
        if (rows.isNotEmpty()) {
            return getPostFileInputStream(rows.get(0).getString("serialnumber"));
        }
        return null;
    }


    /**
     * 将Rows生成excel并上传至华为云，同时返回附件信息
     *
     * @param excelfilename excel文件名称
     * @param sheetname     sheet名称
     * @param rows          数据
     * @return
     * @throws YosException
     * @throws IOException
     */
    public Rows uploadExcelToObs(String excelfilename, String sheetname, Rows rows) throws YosException, IOException {
        ExcelFactory excelFactory = new ExcelFactory(excelfilename);
        excelFactory.addSheet(sheetname, rows);
        return uploadExcelToObs(excelFactory);
    }

    /**
     * 将Rows生成excel并上传至华为云，同时返回附件信息
     *
     * @param excelfilename excel文件名称
     * @param sheetname     sheet名称
     * @param rows          数据
     * @param columnwidths  列宽
     * @return
     * @throws YosException
     * @throws IOException
     */
    public Rows uploadExcelToObs(String excelfilename, String sheetname, Rows rows, Integer[] columnwidths) throws YosException, IOException {
        ExcelFactory excelFactory = new ExcelFactory(excelfilename);
        excelFactory.addSheet(sheetname, rows, columnwidths);
        return uploadExcelToObs(excelFactory);
    }


    /**
     * 将Rows生成excel并上传至华为云，同时返回附件信息
     *
     * @param excelfilename excel文件名称
     * @param sheetname     sheet名称
     * @param rows          数据
     * @param titlemap      列标题
     * @return
     * @throws YosException
     * @throws IOException
     */
    public Rows uploadExcelToObs(String excelfilename, String sheetname, Rows rows, HashMap<String, String> titlemap) throws YosException, IOException {
        ExcelFactory excelFactory = new ExcelFactory(excelfilename);
        excelFactory.addSheet(sheetname, rows, titlemap);
        return uploadExcelToObs(excelFactory);
    }

    public Rows uploadExcelToObs(String excelfilename, String sheetname, JSONArray exportFieldsArray, JSONArray dataarrays) throws YosException, IOException {
        ExcelFactory excelFactory = new ExcelFactory(excelfilename);
        excelFactory.addSheet(sheetname, exportFieldsArray, dataarrays);
        return uploadExcelToObs(excelFactory);
    }

    public Rows uploadEasyExcelToObs(String excelfilename, String sheetname, JSONArray exportFieldsArray, JSONArray dataarrays) throws YosException, IOException {
        EasyExcelFactory easyExcelFactory = new EasyExcelFactory(excelfilename);
        easyExcelFactory.write(sheetname, exportFieldsArray, dataarrays);
        return uploadExcelToObs(easyExcelFactory);
    }

    /**
     * 将Rows生成excel并上传至华为云，同时返回附件信息
     *
     * @param excelfilename excel文件名称
     * @param sheetname     sheet名称
     * @param rows          数据
     * @param titlemap      列标题
     * @param columnwidths  列宽
     * @return
     * @throws YosException
     * @throws IOException
     */
    public Rows uploadExcelToObs(String excelfilename, String sheetname, Rows rows, HashMap<String, String> titlemap, Integer[] columnwidths) throws YosException, IOException {
        ExcelFactory excelFactory = new ExcelFactory(excelfilename);
        excelFactory.addSheet(sheetname, rows, titlemap, columnwidths);
        return uploadExcelToObs(excelFactory);
    }


    /**
     * 将excel上传至华为云，并返回附件信息
     *
     * @return
     */
    public Rows uploadExcelToObs(ExcelFactory excelFactory) throws YosException {
        if (!excelFactory.isWrite) {
            try {
                excelFactory.write();
            } catch (Exception e) {
                throw new YosException("excel写入错误");
            }
        }
        return uploadFileToObs(excelFactory.getFile());
    }

    public Rows uploadExcelToObs(EasyExcelFactory easyExcelFactory) throws YosException {
        return uploadFileToObs(easyExcelFactory.getFile());
    }


    /**
     * 将文件上传至华为云并返回附件信息
     *
     * @return
     */
    public Rows uploadFileToObs(File file) throws YosException {
        String document = file.getName();
        String postfix = "";
        try {
            postfix = document.substring(document.lastIndexOf(".") + 1);
        } catch (Exception e) {
            e.printStackTrace();
        }

        String serialnumber = createMD5FileName() + "." + postfix;
        BucketFile bucketFile = new BucketFile(siteid);
        bucketFile.upload(serialnumber, file);
        if (bucketFile.doesObjectExist(serialnumber)) {
            String appfolderid = Parameter.get(siteid, "appfolderid");
            long attachmentid = createTableID("sys_attachment");
            SQLFactory sqlFactory = new SQLFactory("附件信息插入");
            sqlFactory.addParameter("parentid", appfolderid);
            sqlFactory.addParameter("attachmentid", attachmentid);
            sqlFactory.addParameter("siteid", siteid);
            sqlFactory.addParameter("createby", username);
            sqlFactory.addParameter("type", "sourcefile");
            sqlFactory.addParameter("postfix", postfix);
            sqlFactory.addParameter("serialnumber", serialnumber);
            sqlFactory.addParameter("document", document);
            sqlFactory.addParameter("url", bucketFile.getFileUrl(serialnumber));
            sqlFactory.addParameter("mpctaskid", "null");
            sqlFactory.addParameter("contentlength", bucketFile.getObjectMetadata(serialnumber).getContentLength());
            dbConnect.runSqlUpdate(sqlFactory);
            return getAttachmentUrl(attachmentid);
        }

        return new Rows();
    }

    /**
     * 创建媒体数据关联
     *
     * @param ownertable
     * @param ownerid
     * @param usetype
     * @param attachmentid
     * @throws YosException
     */
    public void createFileLink(String ownertable, Long ownerid, String usetype, Long attachmentid) throws YosException {
        SQLFactory sql = new SQLFactory("创建数据媒体关联");
        sql.addParameter("linksid", createTableID("sys_attachment_links"));
        sql.addParameter("siteid", siteid);
        sql.addParameter("attachmentid", attachmentid);
        sql.addParameter("ownertable", ownertable);
        sql.addParameter("ownerid", ownerid);
        sql.addParameter("usetype", usetype);
        sql.addParameter("createby", username);
        dbConnect.runSqlUpdate(sql.getSQL());
    }

    /**
     * 根据userid获取组织人员信息
     *
     * @param userid
     * @return
     */
    public Row getHr(long userid) throws YosException {
        return getHr(userid, siteid);
    }

    /**
     * 根据userid获取所属部门信息
     *
     * @param userid
     * @return
     */
    public Row getDepartment(long userid) throws YosException {
        return getDepartment(userid, siteid);
    }


    /**
     * 根据userid获取企业档案信息
     *
     * @param userid
     * @return
     */
    public Row getEnterpriseByUserid(long userid) throws YosException {
        return getEnterpriseByUserid(userid, siteid);
    }

    /**
     * 根据userid获取企业人员信息
     *
     * @param userid
     * @return
     */
    public Row getEnterpriseHr(long userid) throws YosException {
        return getEnterpriseHr(userid, siteid);
    }

    /**
     * 根据sys_enterpriseid获取企业人员信息列表
     *
     * @param sys_enterpriseid
     * @return
     */
    public Rows getEnterpriseHrs(long sys_enterpriseid) throws YosException {
        return getEnterpriseHrs(sys_enterpriseid, siteid);
    }


    /**
     * 错误结果返回体
     *
     * @return
     */
    public ReturnObject_Err getErrReturnObject() {
        return returnObject.getErrObject();
    }

    /**
     * 提醒（警告）结果返回体
     *
     * @return
     */
    public ReturnObject_Warn getWarnReturnObject() {
        return returnObject.getWarnObject();
    }

    /**
     * 成功结果返回体
     *
     * @return
     */
    public ReturnObject_Suc getSucReturnObject() {
        return returnObject.getSucObject();
    }

    /**
     * 获取附件信息
     *
     * @param ownertable 表名
     * @param ownerid    数据ID
     * @return
     */
    @Deprecated
    public Rows getAttachmentUrl(String ownertable, Long ownerid) throws YosException {
        ArrayList<Long> ownerids = new ArrayList<>();
        ownerids.add(ownerid);
        return getAttachmentUrl(ownertable, ownerids).get(String.valueOf(ownerid));
    }

    /**
     * 获取附件信息
     *
     * @param ownertable 表名
     * @param ownerids   数据ID
     * @return
     */
    @Deprecated
    public RowsMap getAttachmentUrl(String ownertable, ArrayList<Long> ownerids) throws YosException {
        SQLFactory docfactory = new SQLFactory("附件查询");
        docfactory.addParameter("siteid", siteid);
        docfactory.addParameter("ownertable", ownertable);
        docfactory.addParameter_in("ownerid", ownerids);
        Rows rows = dbConnect.runSqlQuery(docfactory.getSQL());
        RowsMap subrowsmap = getSubAttachmentUrl(rows.toArrayList("attachmentid"));
        for (Row row : rows) {
            row.put("subfiles", subrowsmap.get(row.getString("attachmentid")));
        }
        return rows.toRowsMap("ownerid");
    }

    @Deprecated
    public RowsMap getAttachmentUrl(String siteid, String ownertable, ArrayList<Long> ownerids) throws YosException {
        SQLFactory docfactory = new SQLFactory("附件查询");
        docfactory.addParameter("siteid", siteid);
        docfactory.addParameter("ownertable", ownertable);
        docfactory.addParameter_in("ownerid", ownerids);
        Rows rows = dbConnect.runSqlQuery(docfactory.getSQL());
        RowsMap subrowsmap = getSubAttachmentUrl(rows.toArrayList("attachmentid"));
        for (Row row : rows) {
            row.put("subfiles", subrowsmap.get(row.getString("attachmentid")));
        }
        return rows.toRowsMap("ownerid");
    }

    /**
     * 使指定角色的账户登出
     *
     * @param roleid
     */
    public void logroleout(long roleid) throws YosException {
        ArrayList<String> useridlist = dbConnect.runSqlQuery("select userid from sys_userrole where roleid=" + roleid).toArrayList("userid");
        for (String id : useridlist) {
            if (!id.equals(String.valueOf(userid))) {
                loguserout(Long.parseLong(id));
            }
        }
    }

    /**
     * 媒体信息查询
     *
     * @param attachmentid 媒体ID
     * @return
     */
    @Deprecated
    public Rows getAttachmentUrl(Long attachmentid) throws YosException {
        return getAttachmentUrl(new Long[]{attachmentid});
    }

    /**
     * 媒体信息查询
     *
     * @param attachmentid 媒体ID
     * @return
     */
    @Deprecated
    public Rows getAttachmentUrl(Long[] attachmentid) throws YosException {
        ArrayList<Long> list = new ArrayList<>(Arrays.asList(attachmentid));
        return getAttachmentUrl(list);
    }

    /**
     * 媒体信息查询
     *
     * @param attachmentid 媒体ID
     * @return
     */
    @Deprecated
    public Rows getAttachmentUrl(ArrayList<Long> attachmentid) throws YosException {
        SQLFactory docfactory = new SQLFactory("附件查询_ID");
        docfactory.addParameter("siteid", siteid);
        docfactory.addParameter_in("attachmentid", attachmentid);
        Rows rows = dbConnect.runSqlQuery(docfactory.getSQL());
        RowsMap subrowsmap = getSubAttachmentUrl(rows.toArrayList("attachmentid"));
        for (Row row : rows) {
            row.put("subfiles", subrowsmap.get(row.getString("attachmentid")));
        }
        return rows;
    }

    /**
     * 根据附件用途获取附件信息
     *
     * @param ownertable 表名
     * @param ownerid    数据ID
     * @param usetype    附件用途
     * @return
     */
    @Deprecated
    public Rows getAttachmentUrl(String ownertable, Long ownerid, String usetype) throws YosException {
        SQLFactory attquerysql = new SQLFactory("附件查询_类型");
        attquerysql.addParameter("siteid", siteid);
        attquerysql.addParameter("ownertable", ownertable);
        attquerysql.addParameter_in("ownerid", ownerid);
        attquerysql.addParameter("usetype", usetype);
        Rows rows = dbConnect.runSqlQuery(attquerysql.getSQL());
        RowsMap subrowsmap = getSubAttachmentUrl(rows.toArrayList("attachmentid"));
        for (Row row : rows) {
            row.put("subfiles", subrowsmap.get(row.getString("attachmentid")));
        }
        return rows;
    }

    /**
     * 根据附件用途获取附件信息
     *
     * @param ownertable 表名
     * @param ownerids   数据ID
     * @param usetype    附件用途
     * @return
     */
    @Deprecated
    public RowsMap getAttachmentUrl(String ownertable, ArrayList<Long> ownerids, String usetype) throws YosException {
        SQLFactory docfactory = new SQLFactory("附件查询_类型");
        docfactory.addParameter("siteid", siteid);
        docfactory.addParameter("ownertable", ownertable);
        docfactory.addParameter_in("ownerid", ownerids);
        docfactory.addParameter("usetype", usetype);
        Rows rows = dbConnect.runSqlQuery(docfactory.getSQL());
        RowsMap subrowsmap = getSubAttachmentUrl(rows.toArrayList("attachmentid"));
        for (Row row : rows) {
            row.put("subfiles", subrowsmap.get(row.getString("attachmentid")));
        }
        return rows.toRowsMap("ownerid");
    }

    /**
     * 根据附件id查询子附件信息（转换附件或文件夹内附件）
     *
     * @param attachmentid 附件iD
     * @return
     */
    @Deprecated
    public Rows getSubAttachmentUrl(String attachmentid) throws YosException {
        ArrayList<String> attachmentids = new ArrayList<>();
        attachmentids.add(attachmentid);
        return getSubAttachmentUrl(attachmentids).get(attachmentid);
    }

    /**
     * 根据附件id查询子附件信息（转换附件或文件夹内附件）
     *
     * @param attachmentids 附件iD
     * @return
     */
    @Deprecated
    public RowsMap getSubAttachmentUrl(ArrayList<String> attachmentids) throws YosException {
        SQLFactory docfactory = new SQLFactory("子附件查询");
        docfactory.addParameter("siteid", siteid);
        docfactory.addParameter_in("parentid", attachmentids);
        Rows rows = dbConnect.runSqlQuery(docfactory.getSQL());
        if (rows.isNotEmpty()) {
            RowsMap subrowsmap = getSubAttachmentUrl(rows.toArrayList("attachmentid"));
            for (Row row : rows) {
                row.put("subfiles", subrowsmap.get(row.getString("attachmentid")));
            }
        }
        return rows.toRowsMap("parentid");
    }


    private static HashMap<Long, String> headPicMap = new HashMap<Long, String>();

    /**
     * 获取用户头像
     *
     * @return
     */
    public String getHeadPic(long userid) throws YosException {
        if (!headPicMap.containsKey(userid)) {
            Rows rows = Attachment.get(this, "sys_users", userid, "headportrait");
            headPicMap.put(userid, rows.isEmpty() ? "" : rows.get(0).getString("url"));
        }
        return headPicMap.getOrDefault(userid, "");
    }

    /**
     * 获取数据修改日志
     *
     * @param tablename
     * @param dataid
     * @return
     */
    public Rows getDataLog(String tablename, long dataid) throws YosException {
        Rows rows = dbConnect.runSqlQuery("select * from sys_datalog where table_name='" + tablename + "' and dataid=" + dataid + " order by changedate desc");
        for (Row row : rows) {
            row.put("olddata", JSONObject.parseObject(row.getString("olddata")));
            row.put("newdata", JSONObject.parseObject(row.getString("newdata")));
        }
        return rows;
    }

    private static HashMap<Long, ArrayList<Long>> imdialog_usermap = new HashMap<Long, ArrayList<Long>>();

    /**
     * 根据消息对话框ID获取用户id
     *
     * @param timdialogid
     * @return
     */
    public ArrayList<Long> getImDialogUserIds(long timdialogid) throws YosException {
        return getImDialogUserIds(timdialogid, siteid);
    }

    /**
     * 获取当前账号登陆时间
     *
     * @return
     */
    public Date getLoginDate() {
        return getLoginDate(usersiteid);
    }


    /**
     * 将除了当前账号外的其他账号全部登出
     *
     * @throws YosException
     */
    public void loguserout() throws YosException {
        ArrayList<String> usersiteids = dbConnect.runSqlQuery("select usersiteid from sys_usersite where userid!=" + userid).toArrayList("usersiteid");
        for (String id : usersiteids) {
            long usersiteid = Long.parseLong(id);
            if (usersiteIdList.containsKey(usersiteid)) {
                String token = usersiteIdList.get(usersiteid).getString("token");
                parameter.tokenlist.remove(token);
            }
        }
        dbConnect.runSqlUpdate("update sys_usersite set accesstoken=null,systemclient=null where userid='" + userid + "'");
    }

    public String createBillCode(String coderuletype) throws YosException {
        return createBillCode(siteid, coderuletype);
    }

    public static HashMap<String, Rows> systemModuleIconUrlMap = new HashMap<>();

    /**
     * 获取系统模块的图标url
     *
     * @param systemmoduleid
     * @return
     */
    public String getSystemModuleIconUrl(Long systemmoduleid, String usetype) throws YosException {
        if (systemmoduleid != 0) {
            if (systemModuleIconUrlMap.isEmpty()) {
                SQLFactory iconquerysql = new SQLFactory("系统模块图标查询");
                systemModuleIconUrlMap = dbConnect.runSqlQuery(iconquerysql.getSQL()).toRowsMap("ownerid");
            } else if (!systemModuleIconUrlMap.containsKey(String.valueOf(systemmoduleid))) {
                SQLFactory iconquerysql = new SQLFactory("系统模块图标查询_ID");
                iconquerysql.addParameter("ownerid", systemmoduleid);
                Rows iconqueryRows = dbConnect.runSqlQuery(iconquerysql.getSQL());
                systemModuleIconUrlMap.put(String.valueOf(systemmoduleid), iconqueryRows);
            }
            if (systemModuleIconUrlMap.containsKey(String.valueOf(systemmoduleid))) {
                for (Row iconrow : systemModuleIconUrlMap.get(String.valueOf(systemmoduleid))) {
                    if (iconrow.getString("usetype").equals(usetype)) {
                        return iconrow.getString("url");
                    }
                }
            }
        }
        return "";
    }

    public static HashMap<String, Rows> systemIconUrlMap = new HashMap<>();

    /**
     * 获取系统的图标url
     *
     * @param systemid
     * @return
     */
    public String getSystemIconUrl(Long systemid, String usetype) throws YosException {
        if (systemid != 0) {
            if (systemIconUrlMap.isEmpty()) {
                SQLFactory iconquerysql = new SQLFactory("系统图标查询");
                systemIconUrlMap = dbConnect.runSqlQuery(iconquerysql.getSQL()).toRowsMap("ownerid");
            } else if (!systemIconUrlMap.containsKey(String.valueOf(systemid))) {
                SQLFactory iconquerysql = new SQLFactory("系统图标查询_ID");
                iconquerysql.addParameter("ownerid", systemid);
                Rows iconqueryRows = dbConnect.runSqlQuery(iconquerysql.getSQL());
                systemIconUrlMap.put(String.valueOf(systemid), iconqueryRows);
            }
            if (systemIconUrlMap.containsKey(String.valueOf(systemid))) {
                for (Row iconrow : systemIconUrlMap.get(String.valueOf(systemid))) {
                    if (iconrow.getString("usetype").equals(usetype)) {
                        return iconrow.getString("url");
                    }
                }
            }
        }
        return "";
    }

    /**
     * 创建一个报表请求日志，并且返回一个token
     *
     * @return
     */
    public String getReportToken(long sys_reportid) throws YosException {
        long sys_report_sessionid = createTableID("sys_report_session");
        String token = Encryption.Encode_MD5(siteid + sys_reportid + sys_report_sessionid + username + userid);
        SQLFactory sqlFactory = new SQLFactory("报表访问授权");
        sqlFactory.addParameter("sys_report_sessionid", sys_report_sessionid);
        sqlFactory.addParameter("siteid", siteid);
        sqlFactory.addParameter("sys_reportid", sys_reportid);
        sqlFactory.addParameter("userid", userid);
        sqlFactory.addParameter("token", token);
        sqlFactory.addParameter("dataid", 0);
        sqlFactory.addParameter("systemclient", systemclient);
        dbConnect.runSqlUpdate(sqlFactory.getSQL());
        return token;
    }

    /**
     * 创建一个打印请求日志，并且返回一个token
     *
     * @return
     */
    public String getReportToken(long sys_reportid, long dataid) throws YosException {
        long sys_report_sessionid = createTableID("sys_report_session");
        String token = Encryption.Encode_MD5(siteid + sys_reportid + sys_report_sessionid + username + userid);
        SQLFactory sqlFactory = new SQLFactory("报表访问授权");
        sqlFactory.addParameter("sys_report_sessionid", sys_report_sessionid);
        sqlFactory.addParameter("siteid", siteid);
        sqlFactory.addParameter("sys_reportid", sys_reportid);
        sqlFactory.addParameter("userid", userid);
        sqlFactory.addParameter("token", token);
        sqlFactory.addParameter("dataid", dataid);
        sqlFactory.addParameter("systemclient", systemclient);
        dbConnect.runSqlUpdate(sqlFactory.getSQL());
        return token;
    }

    /**
     * 清除当前账号的所有缓存
     */
    public void cleanAllDataPool() {
        DataPool.removeByAccesstoken(accesstoken);
    }

    /**
     * 清除指定账号的所有缓存
     *
     * @param userid
     */
    public void cleanAllDataPool(long userid) {
        DataPool.removeByUserid(userid);
    }


    /**
     * 清除指定账号的缓存，清理规则按照CACHEING_CLEAN注解
     *
     * @param userid
     */
    public void CACHEING_CLEAN(Long userid) {
        try {
            request.addCacheing_cleanUser(userid);
        } catch (Exception ignored) {
        }
    }
}
