/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.YosException;
import common.YosLogger;
import common.data.InsertSQL;
import common.data.QuerySQL;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import common.parameter.License;
import java.lang.reflect.Constructor;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class InitService
implements Runnable,
YosLogger {
    private static boolean isfirstrun = true;
    static ScheduledExecutorService service;
    public static HashMap<String, ScheduledFuture<?>> scheduledFutureMap;

    @Override
    public void run() {
        if (isfirstrun) {
            service = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
            logger.info((Object)"\u542f\u52a8\u81ea\u52a8\u4efb\u52a1");
            isfirstrun = false;
            DBConnect dbConnect = new DBConnect();
            try {
                InsertSQL insertSQL;
                if (((QuerySQL)SQLFactory.createQuerySQL(dbConnect, "sys_services", new String[0]).setWhere("classname", "SystemHeartBeat")).query().isEmpty()) {
                    insertSQL = SQLFactory.createInsertSQL(dbConnect, "sys_services");
                    insertSQL.setValue("classname", "SystemHeartBeat");
                    insertSQL.setValue("remarks", "\u7cfb\u7edf\u5fc3\u8df3\u4e0a\u4f20");
                    insertSQL.setValue("isused", 1);
                    insertSQL.setValue("type", "minute");
                    insertSQL.setValue("count", 5);
                    insertSQL.insert();
                }
                if (((QuerySQL)SQLFactory.createQuerySQL(dbConnect, "sys_services", new String[0]).setWhere("classname", "DataValidate")).query().isEmpty()) {
                    insertSQL = SQLFactory.createInsertSQL(dbConnect, "sys_services");
                    insertSQL.setValue("classname", "DataValidate");
                    insertSQL.setValue("remarks", "\u6570\u636e\u5f02\u5e38\u76d1\u63a7");
                    insertSQL.setValue("isused", 1);
                    insertSQL.setValue("type", "minute");
                    insertSQL.setValue("count", 30);
                    insertSQL.insert();
                }
                if (((QuerySQL)SQLFactory.createQuerySQL(dbConnect, "sys_services", new String[0]).setWhere("classname", "AttachmentClean")).query().isEmpty()) {
                    insertSQL = SQLFactory.createInsertSQL(dbConnect, "sys_services");
                    insertSQL.setValue("classname", "AttachmentClean");
                    insertSQL.setValue("remarks", "\u9644\u4ef6\u4fe1\u606f\u6e05\u7406");
                    insertSQL.setValue("isused", 1);
                    insertSQL.setValue("type", "hour");
                    insertSQL.setValue("count", 12);
                    insertSQL.insert();
                }
                if (((QuerySQL)SQLFactory.createQuerySQL(dbConnect, "sys_services", new String[0]).setWhere("classname", "CacheMonitoring")).query().isEmpty()) {
                    insertSQL = SQLFactory.createInsertSQL(dbConnect, "sys_services");
                    insertSQL.setValue("classname", "CacheMonitoring");
                    insertSQL.setValue("remarks", "\u8fd0\u884c\u5185\u5b58\u76d1\u63a7");
                    insertSQL.setValue("isused", 1);
                    insertSQL.setValue("type", "minute");
                    insertSQL.setValue("count", 1);
                    insertSQL.insert();
                }
                if (((QuerySQL)SQLFactory.createQuerySQL(dbConnect, "sys_services", new String[0]).setWhere("classname", "DataArchiving")).query().isEmpty()) {
                    insertSQL = SQLFactory.createInsertSQL(dbConnect, "sys_services");
                    insertSQL.setValue("classname", "DataArchiving");
                    insertSQL.setValue("remarks", "\u6570\u636e\u5f52\u6863");
                    insertSQL.setValue("isused", 1);
                    insertSQL.setValue("type", "minute");
                    insertSQL.setValue("count", 1);
                    insertSQL.insert();
                }
                if (License.get().getLicenseType().equals("Development Certificate")) {
                    dbConnect.runSqlUpdate("update sys_services set isused=0 where classname!='MySqlDataBackUp'");
                }
                Rows rows = dbConnect.runSqlQuery("select classname,isused,remarks,lastruntime,type,count,time from sys_services");
                for (Row row : rows) {
                    InitService.addService(row);
                }
            }
            catch (YosException e) {
                e.printStackTrace();
            }
        }
    }

    public static void addService(Row row) {
        try {
            String classname = row.getString("classname");
            String remarks = row.getString("remarks");
            String type = row.getString("type");
            int count = row.getInteger("count") <= 0 ? 1 : row.getInteger("count");
            String isused = row.getString("isused");
            if (scheduledFutureMap.containsKey(classname)) {
                ScheduledFuture<?> oldscheduledFuture = scheduledFutureMap.get(classname);
                oldscheduledFuture.cancel(false);
                logger.info((Object)("\u670d\u52a1\u5378\u8f7d\uff1a" + classname + ";" + remarks));
                scheduledFutureMap.remove(classname);
            }
            Object obj = null;
            Constructor<?> cla = null;
            try {
                Class<?> clz = Class.forName("service." + classname);
                cla = clz.getDeclaredConstructor(new Class[0]);
            }
            catch (Exception e) {
                logger.error((Object)("\u627e\u4e0d\u5230\u670d\u52a1\u7c7b\uff1a" + classname + "," + type + "," + isused + ";" + remarks));
                return;
            }
            obj = cla.newInstance(new Object[0]);
            logger.info((Object)("\u670d\u52a1\u52a0\u8f7d\uff1a" + classname + "," + type + "," + isused + ";" + remarks));
            ScheduledFuture<?> scheduledFuture = null;
            if (type.equalsIgnoreCase("second")) {
                scheduledFuture = service.scheduleWithFixedDelay(obj, 10L, count, TimeUnit.SECONDS);
            } else if (type.equalsIgnoreCase("minute")) {
                int delay = 60 - Calendar.getInstance().get(13);
                scheduledFuture = service.scheduleAtFixedRate(obj, delay, (long)count * 60L, TimeUnit.SECONDS);
            } else if (type.equalsIgnoreCase("hour")) {
                Calendar calendar;
                int syssecond;
                String[] times;
                int schedulesecond;
                int delay;
                String time = row.getString("time");
                if (time.equals("")) {
                    time = "00:00";
                }
                delay = (delay = (schedulesecond = Integer.parseInt((times = time.split(":"))[0]) * 60 + Integer.parseInt(times[1])) - (syssecond = (calendar = Calendar.getInstance()).get(12) * 60 + calendar.get(13))) < 0 ? delay + 3600 : delay;
                scheduledFuture = service.scheduleAtFixedRate(obj, delay, (long)count * 60L * 60L, TimeUnit.SECONDS);
            } else if (type.equalsIgnoreCase("day")) {
                Calendar calendar;
                int syssecond;
                String[] times;
                int schedulesecond;
                int delay;
                String time = row.getString("time");
                if (time.equals("")) {
                    time = "00:00:00";
                }
                delay = (delay = (schedulesecond = Integer.parseInt((times = time.split(":"))[0]) * 60 * 60 + Integer.parseInt(times[1]) * 60 + Integer.parseInt(times[2])) - (syssecond = (calendar = Calendar.getInstance()).get(11) * 60 * 60 + calendar.get(12) * 60 + calendar.get(13))) < 0 ? delay + 86400 : delay;
                scheduledFuture = service.scheduleAtFixedRate(obj, delay, (long)count * 60L * 60L * 24L, TimeUnit.SECONDS);
            } else if (type.equalsIgnoreCase("once")) {
                scheduledFuture = service.scheduleWithFixedDelay(obj, 10L, 300L, TimeUnit.SECONDS);
            }
            if (scheduledFuture != null) {
                scheduledFutureMap.put(classname, scheduledFuture);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        scheduledFutureMap = new HashMap();
    }
}

