package common.data;

import common.Controller;
import common.YosException;
import common.data.db.DBConnect;

import java.util.ArrayList;
import java.util.HashMap;

public class RecursiveQuerySQL extends BaseSQL<RecursiveQuerySQL> {
    private String cache_tableName;
    private String keyfieldname;
    private String linkkeyfieldname;

    protected RecursiveQuerySQL(Controller controller, String tablename) throws YosException {
        super(controller, tablename);
        this.cache_tableName = tablename + "_cache";
    }

    protected RecursiveQuerySQL(DBConnect dbConnect, String tablename) throws YosException {
        super(dbConnect, tablename);
        this.cache_tableName = tablename + "_cache";
    }

    public RecursiveQuerySQL setKeyField(String keyfieldname, String linkkeyfieldname) {
        this.keyfieldname = keyfieldname;
        this.linkkeyfieldname = keyfieldname;
        return this;
    }

    public String getSQL() {
        StringBuilder recursiveSQl = new StringBuilder();
        recursiveSQl.append(" with recursive " + this.cache_tableName + " as ( ");
        recursiveSQl.append(" select " + this.keyfieldname + " from " + this.tablename);


        recursiveSQl.append(" union all ");
        recursiveSQl.append(" select " + this.keyfieldname + " from " + this.cache_tableName + " inner join " + this.tablename + " on 1=1 ");

        recursiveSQl.append(" )");
        recursiveSQl.append("select * from " + this.cache_tableName);
        return recursiveSQl.toString();
    }

    /**
     * 执行查询
     *
     * @return
     * @throws YosException
     */
    public Rows query() throws YosException {
        Rows rows = dbConnect.runSqlQuery(getSQL());
        return rows;
    }
}
