with recursive attachment as (
    select attachmentid, ifnull(folderpath, '0/') as folderpath
    from sys_attachment
    where attachmentid = $attachmentid$
    union all
    select t2.attachmentid, CONCAT(t1.folderpath, t2.attachmentid, '/')
    from attachment t1
             inner join sys_attachment t2 on t1.attachmentid = t2.parentid
)
update sys_attachment t1 inner join attachment t2
on t1.attachmentid=t2.attachmentid
    set t1.folderpath=t2.folderpath
