package service;

import common.ServiceController;
import utility.hardware.Memory;
import utility.tools.Math;
import utility.tools.MessageMonitoringStation;

import java.util.Calendar;

public class CacheMonitoring extends ServiceController {

    private static int day = 0;

    @Override
    public void serviceRun() {
        Memory memory = Memory.get();
        StringBuilder msg = new StringBuilder();
        if (memory.getHeapUsedMemoryUsagePercent() >= 75) {
            msg.append("JAVA堆内存USED：").append(Math.div(memory.getHeapUsedMemory(), 1024, 2)).append("G,").append(memory.getHeapUsedMemoryUsagePercent()).append("%\n");
            msg.append("JAVA堆内存COMMITTED：").append(Math.div(memory.getHeapCommittedMemory(), 1024, 2)).append("G,").append(memory.getHeapCommittedMemoryUsagePercent()).append("%\n");

            msg.append("JAVA内存分配总量：").append(Math.div(memory.getHeapMaxMemory(), 1024, 2)).append("G\n");
            msg.append("内存总量：").append(Math.div(memory.getTotalMemory(), 1024, 2)).append("G\n");
            MessageMonitoringStation.send("\n内存占用预警：\n" + msg);
            MessageMonitoringStation.send("正在尝试内存清理！" + msg);
            System.gc();
        } else if (memory.getHeapCommittedMemoryUsagePercent() >= 75) {
//            msg.append("JAVA堆内存USED：").append(Math.div(memory.getHeapUsedMemory(), 1024, 2)).append("G,").append(memory.getHeapUsedMemoryUsagePercent()).append("%\n");
//            msg.append("JAVA堆内存COMMITTED：").append(Math.div(memory.getHeapCommittedMemory(), 1024, 2)).append("G,").append(memory.getHeapCommittedMemoryUsagePercent()).append("%\n");
//
//            msg.append("JAVA内存分配总量：").append(Math.div(memory.getHeapMaxMemory(), 1024, 2)).append("G\n");
//            msg.append("内存总量：").append(Math.div(memory.getTotalMemory(), 1024, 2)).append("G\n");
//            MessageMonitoringStation.send("\n内存占用预警：\n" + msg);
        }
        if (day != Calendar.getInstance().get(Calendar.DATE) && Calendar.getInstance().get(Calendar.HOUR_OF_DAY) == 1) {
            day = Calendar.getInstance().get(Calendar.DATE);
            //每天1点中尝试执行内存清理
            System.gc();
        }
    }
}

