package restcontroller.system.attachment.localhost;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.SQLFactory;
import org.apache.commons.fileupload.FileItem;
import restcontroller.R;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

@API(title = "本地文件上传")
public class localhost extends Controller {

    public localhost(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "本地文件上传", apiversion = R.ID10020301.v1.class)
    public String upload() throws YosException {
        String parentid = content.getString("parentid");

        HashMap<String, FileItem> fileItemMap = new HashMap<>();
        for (FileItem item : requestFileItemList) {
            if (!item.isFormField()) {
                fileItemMap.put(item.getFieldName(), item);
            }
        }
        if (fileItemMap.isEmpty()) {
            return getErrReturnObject().setErrMsg("必须指定一个文件进行上传").toString();
        }
        ArrayList<String> SQlist = new ArrayList<>();
        JSONArray filearray = content.getJSONArray("files");
        ArrayList<Long> ids = new ArrayList<>();
        for (Object o : filearray) {
            JSONObject fileObject = (JSONObject) o;
            String filekey = fileObject.getString("filekey");
            String filename = fileObject.getString("filename");
            String filetype = fileObject.getString("filetype");
            String serialfilename = createMD5FileName() + "." + filetype;

            if (fileItemMap.containsKey(filekey)) {
                FileItem item = fileItemMap.get(filekey);

                String fileName = new File(item.getName()).getName();
                String filePath = Parameter.get("attachment_localhost_path") + File.separator + siteid + File.separator + serialfilename;

                File file = new File(filePath);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                } else if (file.exists()) {
                    file.delete();
                }
                try {
                    item.write(file);
                } catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                long attachmentid = createTableID("sys_attachment");

                SQLFactory sqlFactory = new SQLFactory(this, "附件信息插入");
                sqlFactory.addParameter("parentid", (parentid.equals("") || parentid.equals("0")) ? "null" : parentid);
                sqlFactory.addParameter("attachmentid", attachmentid);
                sqlFactory.addParameter("siteid", siteid);
                sqlFactory.addParameter("createby", username);
                sqlFactory.addParameter("type", "sourcefile");
                sqlFactory.addParameter("postfix", filetype);
                sqlFactory.addParameter("serialnumber", serialfilename);
                sqlFactory.addParameter("document", filename);
                sqlFactory.addParameter("url", File.separator + siteid + File.separator + serialfilename);
                sqlFactory.addParameter("mpctaskid", "");
                sqlFactory.addParameter("contentlength", file.length());
                SQlist.add(sqlFactory.getSQL());
                ids.add(attachmentid);
            }
        }
        dbConnect.runSqlUpdate(SQlist);
        for (long attachmentid : ids) {
            beans.attachment.Attachment.RefreshFolderPath(this, attachmentid);
        }

        JSONObject resultObject = new JSONObject();
        if (filearray.size() == SQlist.size()) {
            resultObject.put("code", 1);
            resultObject.put("msg", "成功上传" + filearray.size() + "个文件");
        } else if (filearray.size() > SQlist.size() && SQlist.size() > 0) {
            resultObject.put("code", 1);
            resultObject.put("msg", "成功上传" + SQlist.size() + "个文件,失败" + (filearray.size() - SQlist.size() + "个"));
        } else if (SQlist.size() == 0) {
            resultObject.put("code", 0);
            resultObject.put("msg", "上传失败");
        }
        return resultObject.toString();
    }
}
