select t1.systemid,
       t2.systemname,
       null     as systemclientid,
       null     as systemclientname,
       null     as systemmoduleid,
       null     as systemmodulename,
       null     as systemappid,
       null     as systemappname,
       t1.sys_version_areaid,
       'system' as type
from sys_version_area t1
         inner join sys_system t2 on t1.systemid = t2.systemid
where t1.versionid = $versionid$
  and t1.systemid > 0
union all
select t3.systemid,
       t3.systemname,
       t2.systemclientid,
       t2.systemclientname,
       null     as systemmoduleid,
       null     as systemmodulename,
       null     as systemappid,
       null     as systemappname,
       t1.sys_version_areaid,
       'client' as type
from sys_version_area t1
         inner join sys_systemclient t2 on t1.systemclientid = t2.systemclientid
         inner join sys_system t3 on t2.systemid = t3.systemid
where t1.versionid = $versionid$
  and t1.systemclientid > 0
union all
select t4.systemid,
       t4.systemname,
       t3.systemclientid,
       t3.systemclientname,
       t2.systemmoduleid,
       t2.systemmodulename,
       null     as systemappid,
       null     as systemappname,
       t1.sys_version_areaid,
       'module' as type
from sys_version_area t1
         inner join sys_systemmodule t2 on t1.systemmoduleid = t2.systemmoduleid
         inner join sys_systemclient t3 on t2.systemclientid = t3.systemclientid
         inner join sys_system t4 on t3.systemid = t4.systemid
where t1.versionid = $versionid$
  and t1.systemmoduleid > 0
union all
select t5.systemid,
       t5.systemname,
       t4.systemclientid,
       t4.systemclientname,
       t3.systemmoduleid,
       t3.systemmodulename,
       t2.systemappid,
       t2.systemappname,
       t1.sys_version_areaid,
       'app' as type
from sys_version_area t1
         inner join sys_systemapp t2 on t1.systemappid = t2.systemappid
         inner join sys_systemmodule t3 on t2.systemmoduleid = t3.systemmoduleid
         inner join sys_systemclient t4 on t3.systemclientid = t4.systemclientid
         inner join sys_system t5 on t4.systemid = t5.systemid
where t1.versionid = $versionid$
  and t1.systemappid > 0
