package restcontroller.sysmanage.develop.report;

import beans.datacontrllog.DataContrlLog;
import beans.user.User;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.*;
import restcontroller.R;

public class appreport extends Controller {
    public appreport(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "应用报表、打印列表查询", apiversion = R.ID20221213094401.v1.class)
    public String queryReportList() throws YosException {
        long systemappid = content.getLong("systemappid");
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("if(t1.reporttype = '积木报表', t2.name, t1.name) like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
            //报表分类查询
            if (whereObject.containsKey("type") && !"".equals(whereObject.getString("type"))) {
                where.append(" and(");
                where.append("t3.type='").append(whereObject.getString("type")).append("'");
                where.append(")");
            }
        }

        SQLFactory sqlFactory = new SQLFactory(this, "应用报表查询");
        if (userInfo.isSiteAdministrator() || userInfo.isSysAdministrator()) {
            sqlFactory = new SQLFactory(this, "应用报表查询2");
        }
        sqlFactory.addParameter("systemappid", systemappid);
        sqlFactory.addParameter("siteid", siteid);
        sqlFactory.addParameter_in("roleids", User.getUserRoleIDs(this, userid));
        sqlFactory.addParameter_SQL("where", where);
        Rows rows = dbConnect.runSqlQuery(sqlFactory.getSQL());
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "应用报表、打印请求预览页面", apiversion = R.ID20221213094501.v1.class)
    public String viewReport() throws YosException {
        long sys_reportid = content.getLongValue("sys_reportid");
        long dataid = content.getLongValue("dataid");
        Rows rows = dbConnect.runSqlQuery("select * from sys_report where sys_reportid=" + sys_reportid);
        if (rows.isEmpty()) {
            return getErrReturnObject().setErrMsg("找不到报表信息").toString();
        }
        if (rows.get(0).getString("reporttype").equals("积木报表")) {
            String jimu_report_id = rows.get(0).getString("jimu_report_id");
            return getSucReturnObject().setData("/yosreport/jmreport/view/" + jimu_report_id + "?token=" + getReportToken(sys_reportid, dataid)).toString();
        } else if (rows.get(0).getString("reporttype").equalsIgnoreCase("Birt报表")) {
            String filename = rows.get(0).getString("filename");
            return getSucReturnObject().setData("/birt/frameset?__report=" + filename + ".rptdesign&token=" + getReportToken(sys_reportid, dataid)).toString();
        } else if (rows.get(0).getString("reporttype").equalsIgnoreCase("润乾报表")) {
            return getSucReturnObject().setData("/raqsoft/yosreport.jsp?token=" + getReportToken(sys_reportid, dataid)).toString();
        } else {
            //  getReportToken(sys_reportid, dataid);
            String path = rows.get(0).getString("path");
            if (path.contains("${siteid}")) {
                path = path.replace("${siteid}", siteid);
            }
            if (path.contains("${userid}")) {
                path = path.replace("${userid}", String.valueOf(userid));
            }
            if (path.contains("${dataid}")) {
                path = path.replace("${dataid}", String.valueOf(dataid));
            }
            return getSucReturnObject().setData(path).toString();
        }

    }

    @API(title = "新增修改报表", apiversion = R.ID20230828110904.v1.class)
    public String insertReport() throws YosException {
        String path = content.getString("path");
        String name = content.getString("name");
        Long isused = content.getLong("isused");
        Long sys_reportid = content.getLong("sys_reportid");
        long systemappid = content.getLongValue("systemappid");

        if (sys_reportid <= 0 || dbConnect.runSqlQuery("select 1 from sys_report where siteid='" + siteid + "' and sys_reportid=" + sys_reportid).isEmpty()) {
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_report");
            sys_reportid = createTableID("sys_report");
            insertSQL.setValue("sys_reportid", sys_reportid);
            insertSQL.setValue("siteid", siteid);
            insertSQL.setValue("systemappid", systemappid);
            insertSQL.setValue("isused", isused);
            insertSQL.setValue("reporttype", "帆软报表");
            insertSQL.setValue("path", path);
            insertSQL.setValue("name", name);
            dbConnect.runSqlUpdate(insertSQL.getSQL());
            dbConnect.runSqlUpdate(DataContrlLog.createLog(this, "sys_report", sys_reportid, "新增", "新增报表" + name + path).getSQL());
        } else {
            UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_report");
            updateSQL.setValue("systemappid", systemappid);
            updateSQL.setValue("isused", isused);
            updateSQL.setValue("name", name);
            updateSQL.setWhere("sys_reportid", sys_reportid);
            updateSQL.setWhere("siteid", siteid);
            dbConnect.runSqlUpdate(updateSQL.getSQL());
            dbConnect.runSqlUpdate(DataContrlLog.createLog(this, "sys_report", sys_reportid, "修改", "修改报表" + name + path).getSQL());
        }
        return getSucReturnObject().setData(path).toString();


    }

    @API(title = "删除报表", apiversion = R.ID20230828111404.v1.class)
    public String deleteReport() throws YosException {
        Long sys_reportid = content.getLong("sys_reportid");
        DeleteSQL deleteSQL = SQLFactory.createDeleteSQL(this, "sys_report");
        deleteSQL.setWhere("siteid", siteid);
        deleteSQL.setWhere("sys_reportid", sys_reportid);
        dbConnect.runSqlUpdate(deleteSQL.getSQL());
        dbConnect.runSqlUpdate(DataContrlLog.createLog(this, "sys_report", sys_reportid, "删除", "删除").getSQL());
        return getSucReturnObject().toString();
    }

    @API(title = "帆软报表列表查询", apiversion = R.ID20230828112204.v1.class)
    public String FRReportList() throws YosException {
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_report");
        querySQL.setTableAlias("t1");
        querySQL.setSiteid(siteid);
        querySQL.addJoinTable(JOINTYPE.left, "sys_systemapp", "t2", "t1.systemappid=t2.systemappid", "systemappname");
        querySQL.setWhere("t1.reporttype='帆软报表'");
        Rows rows = dbConnect.runSqlQuery(querySQL.getSQL());
        return getSucReturnObject().setData(rows).toString();
    }


}
