package objectregister;

import common.YosException;
import common.data.InsertSQL;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import org.omg.PortableInterceptor.INACTIVE;
import org.sqlite.core.DB;

import java.util.ArrayList;

public class sys_datafunction implements YosObject {
    @Override
    public String table_comment() {
        return "系统函数注册表";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("sys_datafunctionid", "数据ID");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> arrayList = new ArrayList<>();
        arrayList.add(new VarcharCol("datakey", "datakey", 100));
        arrayList.add(new VarcharCol("classname", "classname", 200));
        arrayList.add(new VarcharCol("functionclass", "函数分类", 200));
        arrayList.add(new VarcharCol("status", "status", 50, "启用"));
        return arrayList;
    }

    @Override
    public void DataInit() throws YosException {
        DBConnect dbConnect = new DBConnect();
        if (dbConnect.runSqlQuery("select * from sys_optiontype where typename='datafunctionclass'").isEmpty()) {
            ArrayList<String> sqlist = new ArrayList<>();
            InsertSQL optiontypeInsert = SQLFactory.createInsertSQL(dbConnect, "sys_optiontype");
            optiontypeInsert.setValue("typename", "datafunctionclass");
            optiontypeInsert.setValue("issql", false);
            optiontypeInsert.setValue("issubvaluemag", false);
            optiontypeInsert.setValue("remarks", "执行函数分类");
            optiontypeInsert.setValue("issystem", true);
            sqlist.add(optiontypeInsert.getSQL());

            InsertSQL optiontypemxInsert = SQLFactory.createInsertSQL(dbConnect, "sys_optiontypemx");
            optiontypemxInsert.setValue("optiontypeid", optiontypeInsert.getUniqueid());
            optiontypemxInsert.setValue("value", "ordercost");
            optiontypemxInsert.setValue("remarks", "订单费用计算");
            optiontypemxInsert.setValue("isused", true);
            optiontypemxInsert.setValue("issystem", true);
            sqlist.add(optiontypemxInsert.getSQL());
            dbConnect.runSqlUpdate(sqlist);
        }
    }
}
