package common.mq;

import org.apache.activemq.broker.jmx.BrokerViewMBean;

import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import java.util.HashMap;
import java.util.Map;

public class MQJMX {
    BrokerViewMBean brokerViewMBean;
    MBeanServerConnection connection;

    public MQJMX() throws Exception {
        //jmx服务地址，注意端口
        //String jmxserviceURL = "service:jmx:rmi:///jndi/rmi://192.168.3.35:61618/jmxrmi";
        String jmxserviceURL = "service:jmx:rmi:///jndi/rmi://192.168.0.201:1099/jmxrmi";
        //brokername是对应的ip
        String objectName = "org.apache.activemq:brokerName=localhost,type=Broker";
        JMXServiceURL url = new JMXServiceURL(jmxserviceURL);
        //用户名和密码
        String[] credentials = new String[]{"admin", "public"};
        Map<String, String[]> props = new HashMap<String, String[]>();
        props.put("jmx.remote.credentials", credentials);

        JMXConnector connector = JMXConnectorFactory.connect(url, props);
        connector.connect();
        connection = connector.getMBeanServerConnection();
        ObjectName name = new ObjectName(objectName);
        brokerViewMBean = (BrokerViewMBean) MBeanServerInvocationHandler.newProxyInstance(connection,
                name, BrokerViewMBean.class, true);
    }

    public BrokerViewMBean getBrokerViewMBean() {
        return brokerViewMBean;
    }

    /**
     * 获取当前设备连接数
     *
     * @return
     * @throws Exception
     */
    public long getCurrentConnectionsCount() throws Exception {
        return brokerViewMBean.getCurrentConnectionsCount();
    }

    /**
     * 获取总订阅数
     *
     * @return
     * @throws Exception
     */
    public long getTotalConsumerCount() throws Exception {
        return brokerViewMBean.getTotalConsumerCount();
    }

    /**
     * 获取内存上限
     *
     * @return
     */
    public long getMemoryLimit() {
        return brokerViewMBean.getMemoryLimit();
    }

    /**
     * @return
     */
    public long getMemoryPercentUsage() {
        return brokerViewMBean.getMemoryPercentUsage();
    }

    /**
     * 获取主题清单
     */
    public ObjectName[] getTopics() throws Exception {
        return brokerViewMBean.getTopics();
    }

    /**
     * 活跃的非持久主题订阅者
     */
    public ObjectName[] getTopicSubscribers() throws Exception {
        return brokerViewMBean.getTopicSubscribers();
    }

    /**
     * 活跃持久话题订阅者
     */
    public ObjectName[] getDurableTopicSubscribers() throws Exception {
        return brokerViewMBean.getDurableTopicSubscribers();
    }

    /**
     * 离线的持久话题订阅者
     */
    public ObjectName[] getInactiveDurableTopicSubscribers() throws Exception {
        return brokerViewMBean.getInactiveDurableTopicSubscribers();
    }

    /**
     * 删除一个客户端订阅
     *
     * @param clientid
     * @param subscriberName
     * @throws Exception
     */
    public void destroyDurableSubscriber(String clientid, String subscriberName) throws Exception {
        brokerViewMBean.destroyDurableSubscriber(clientid, subscriberName);
    }

    /**
     * 删除一个话题
     *
     * @param topic
     * @throws Exception
     */
    public void removeTopic(String topic) throws Exception {
        brokerViewMBean.removeTopic(topic);
    }
//
//    public static void main(String[] args) throws Exception {
//        JMX jmx = new JMX();
//        System.err.println("连接数" + jmx.getCurrentConnectionsCount());
//        System.err.println("订阅数" + jmx.getTotalConsumerCount());
//
//        System.err.println(jmx.getMemoryLimit() / 1024 / 1024);
//        System.err.println("在线持久化订阅");
//        for (ObjectName o : jmx.getDurableTopicSubscribers()) {
//            System.err.println(o);
//        }
//        System.err.println("离线持久化订阅");
//        for (ObjectName o : jmx.getInactiveDurableTopicSubscribers()) {
//            System.err.println(o);
//        }
//
//        jmx.getBrokerViewMBean().gc();
//    }
}
