package common.annotation;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * 接口注解，缓存清理注解，当方法上设置此注解时，接口调用此方法后会清理指定方法的缓存数据，如调用增删改接口后自动清除查询接口的缓存
 *
 * @CACHEING_CLEAN(cms = {@cm(clazz = users.class, method = {"query_userList", "query_userMain"})})
 */
@Retention(RetentionPolicy.RUNTIME)
public @interface CACHEING_CLEAN {
    /**
     * 按名称清除缓存
     *
     * @return
     */
    cm[] cms() default {};

    /**
     * 按接口id清除缓存
     *
     * @return
     */
    Class[] apiversions() default {};

    /**
     * 按接口类清除缓存
     *
     * @return
     */
    Class[] apiClass() default {};

    /**
     * 按表名清除缓存
     *
     * @return
     */
    String[] tablename() default {};

    /**
     * 按应用名称清除缓存
     *
     * @return
     */
    String[] systemapp() default {};
}
