/*
 * Decompiled with CFR 0.152.
 */
package service;

import common.ServiceController;
import common.YosException;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import common.mq.ClientMQTT;
import common.mq.MQMessage;
import java.util.ArrayList;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.broker.jmx.BrokerViewMBean;

public class MqttClientCheck
extends ServiceController {
    @Override
    public void serviceRun() throws YosException {
        try {
            ArrayList<String> onlineDevices = this.dbConnect.runSqlQuery("select serialnumber from w_device where status ='\u5728\u7ebf'").toArrayList("serialnumber");
            HashMap<String, String> online = new HashMap<String, String>();
            Rows sys_mqRows = this.dbConnect.runSqlQuery("select jmxrmiaddress,password,username,sys_mqid from sys_mq where isused=1");
            for (Row sys_mqRow : sys_mqRows) {
                long sys_mqid = sys_mqRow.getLong("sys_mqid");
                String jmxserviceURL = sys_mqRow.getString("jmxrmiaddress");
                JMXServiceURL url = new JMXServiceURL(jmxserviceURL);
                JMXConnector connector = JMXConnectorFactory.connect(url, null);
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                ObjectName name = new ObjectName("org.apache.activemq:brokerName=localhost,type=Broker");
                BrokerViewMBean brokerViewMBean = MBeanServerInvocationHandler.newProxyInstance(connection, name, BrokerViewMBean.class, true);
                ObjectName[] objectNames = brokerViewMBean.getDynamicDestinationProducers();
                logger.info((Object)("mqtt\u68c0\u6d4b\u5f53\u524d\u5728\u7ebf\u6570\uff1a" + objectNames.length));
                for (ObjectName objectName : objectNames) {
                    String clientId = objectName.getKeyProperty("clientId");
                    String producerId = objectName.getKeyProperty("producerId").replace("_-1_1", "");
                    online.put(clientId, producerId);
                    ClientMQTT.connectClientIDMap.put(producerId, clientId);
                    ClientMQTT.connectClientIDMQIDMap.put(clientId, sys_mqid);
                    this.dbConnect.runSqlUpdate("update w_device set status='\u5728\u7ebf',lastconnecttime=now() where serialnumber='" + clientId + "' and ifnull(status,'\u79bb\u7ebf')='\u79bb\u7ebf'");
                    try {
                        Rows rows = new DBConnect().runSqlQuery("select w_function_queueid from w_function_queue t1 inner join w_device t2 on t1.siteid=t2.siteid and t1.w_deviceid=t2.w_deviceid where t1.invalid=0 and t1.deleted=0 and t1.isreceive=0 and t2.serialnumber='" + clientId + "' order by w_function_queueid");
                        for (Row row : rows) {
                            logger.info((Object)("mqtt\u6307\u4ee4\u53d1\u9001\uff1a" + row.getLong("w_function_queueid")));
                            ClientMQTT.publish(row.getLong("w_function_queueid"));
                            Thread.sleep(100L);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    MQMessage.deviceMsgStatusInit(clientId);
                }
                connector.close();
                for (String serialnumber : onlineDevices) {
                    if (online.containsKey(serialnumber)) continue;
                    this.dbConnect.runSqlUpdate("update w_device set status='\u79bb\u7ebf' where serialnumber='" + serialnumber + "'");
                    SQLFactory.createInsertSQL(new DBConnect(), "sys_mqttlogintrack").setValue("connectionid", online.get(serialnumber)).setValue("action", "off").setValue("clientid", serialnumber).setDateValue("createdate").insert();
                    ClientMQTT.onlineClientid.remove(serialnumber);
                    ClientMQTT.connectClientIDMap.remove(online.get(serialnumber));
                    ClientMQTT.connectClientIDMQIDMap.remove(serialnumber);
                    MQMessage.deviceMsgStatusInit(serialnumber);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

