/*
 * Decompiled with CFR 0.152.
 */
package common.data;

import beans.parameter.Parameter;
import common.YosException;
import common.data.Row;
import common.data.Rows;
import common.data.db.DBConnect;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelFactory2003 {
    private String filename;
    private HSSFWorkbook hssfWorkbook;
    private XSSFWorkbook xssfWorkbook;
    public Boolean isWrite = false;

    public ExcelFactory2003(String filename) {
        this.filename = filename + Calendar.getInstance().getTimeInMillis();
        this.hssfWorkbook = new HSSFWorkbook();
    }

    public ExcelFactory2003(InputStream inputStream) throws IOException {
        this.hssfWorkbook = new HSSFWorkbook(inputStream);
    }

    public HSSFSheet addSheet(String sheetname) {
        return this.hssfWorkbook.createSheet(sheetname);
    }

    public HSSFSheet addSheet(String sheetname, Rows datarows) {
        HSSFSheet sheet = this.hssfWorkbook.createSheet(sheetname);
        HSSFRow headrow = sheet.createRow(0);
        HSSFCellStyle hssfCellStyle = this.getHeadRowStyle();
        ArrayList<String> keylist = datarows.getFieldList();
        for (int i = 0; i < keylist.size(); ++i) {
            HSSFCell hssFcell = headrow.createCell(i);
            hssFcell.setCellStyle(hssfCellStyle);
            hssFcell.setCellValue(keylist.get(i));
        }
        for (int n = 0; n < datarows.size(); ++n) {
            Row row = datarows.get(n);
            HSSFRow datarow = sheet.createRow(n + 1);
            for (int i = 0; i < keylist.size(); ++i) {
                Class fieldclazztype = datarows.getFieldMeta(keylist.get(i)).getFieldtype();
                if (fieldclazztype == Integer.class) {
                    datarow.createCell(i).setCellValue((double)row.getInteger(keylist.get(i)).intValue());
                    continue;
                }
                if (fieldclazztype == Long.class) {
                    datarow.createCell(i).setCellValue((double)row.getLong(keylist.get(i)));
                    continue;
                }
                if (fieldclazztype == Float.class) {
                    datarow.createCell(i).setCellValue((double)row.getBigDecimal(keylist.get(i)).floatValue());
                    continue;
                }
                if (fieldclazztype == Double.class) {
                    datarow.createCell(i).setCellValue(row.getBigDecimal(keylist.get(i)).doubleValue());
                    continue;
                }
                datarow.createCell(i).setCellValue(row.getString(keylist.get(i)));
            }
        }
        return sheet;
    }

    public HSSFSheet addSheet(String sheetname, Rows datarows, HashMap<String, String> titlemap) {
        HSSFSheet sheet = this.hssfWorkbook.createSheet(sheetname);
        HSSFRow headrow = sheet.createRow(0);
        HSSFCellStyle hssfCellStyle = this.getHeadRowStyle();
        ArrayList<String> keylist = datarows.getFieldList();
        for (int i = 0; i < keylist.size(); ++i) {
            HSSFCell hssFcell = headrow.createCell(i);
            hssFcell.setCellStyle(hssfCellStyle);
            String keyname = keylist.get(i);
            if (titlemap.containsKey(keyname)) {
                keyname = titlemap.get(keyname);
            }
            hssFcell.setCellValue(keyname);
        }
        for (int n = 0; n < datarows.size(); ++n) {
            Row row = datarows.get(n);
            HSSFRow datarow = sheet.createRow(n + 1);
            for (int i = 0; i < keylist.size(); ++i) {
                Class fieldclazztype = datarows.getFieldMeta(keylist.get(i)).getFieldtype();
                if (fieldclazztype == Integer.class) {
                    datarow.createCell(i).setCellValue((double)row.getInteger(keylist.get(i)).intValue());
                    continue;
                }
                if (fieldclazztype == Long.class) {
                    datarow.createCell(i).setCellValue((double)row.getLong(keylist.get(i)));
                    continue;
                }
                if (fieldclazztype == Float.class) {
                    datarow.createCell(i).setCellValue((double)row.getBigDecimal(keylist.get(i)).floatValue());
                    continue;
                }
                if (fieldclazztype == Double.class) {
                    datarow.createCell(i).setCellValue(row.getBigDecimal(keylist.get(i)).doubleValue());
                    continue;
                }
                datarow.createCell(i).setCellValue(row.getString(keylist.get(i)));
            }
        }
        return sheet;
    }

    public void write() throws IOException, YosException {
        String p = Parameter.get("system_excelexport_path");
        p = p.endsWith("/") ? p : p + "/";
        File file = new File(p + this.filename + ".xls");
        File parentfile = file.getParentFile();
        if (!parentfile.exists()) {
            parentfile.mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.hssfWorkbook.write((OutputStream)fileOutputStream);
        fileOutputStream.close();
        this.isWrite = true;
    }

    public String getFilename() {
        return this.filename + ".xls";
    }

    public String getFilepath() throws YosException {
        return Parameter.get("system_excelexport_path") + this.filename + ".xls";
    }

    public File getFile() throws YosException {
        return new File(Parameter.get("system_excelexport_path") + this.filename + ".xls");
    }

    public void deletefile() throws YosException {
        File file = new File(Parameter.get("system_excelexport_path") + this.filename + ".xls");
        file.delete();
    }

    public HSSFCellStyle getHeadRowStyle() {
        HSSFCellStyle hssfCellStyle = this.hssfWorkbook.createCellStyle();
        hssfCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        hssfCellStyle.setFillForegroundColor(IndexedColors.LIGHT_CORNFLOWER_BLUE.getIndex());
        hssfCellStyle.setAlignment(HorizontalAlignment.CENTER);
        hssfCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont font = this.hssfWorkbook.createFont();
        font.setFontHeightInPoints((short)12);
        font.setBold(true);
        hssfCellStyle.setFont(font);
        return hssfCellStyle;
    }

    public HSSFWorkbook getHssfWorkbook() {
        return this.hssfWorkbook;
    }

    public HSSFSheet getSheet(String sheetname) {
        return this.hssfWorkbook.getSheet(sheetname);
    }

    public HSSFSheet getSheet(int sheetindex) {
        return this.hssfWorkbook.getSheetAt(sheetindex);
    }

    public Rows getSheetRows(String sheetname, Rows rows, int index) {
        return this.getSheetRows(sheetname, rows.getFieldList(), index);
    }

    public Rows getSheetRows(int sheetindex, Rows rows, int index) {
        return this.getSheetRows(sheetindex, rows.getFieldList(), index);
    }

    public Rows getSheetRows(String sheetname, ArrayList<String> fieldlist, int rowindex) {
        int sheetindex = this.hssfWorkbook.getSheetIndex(sheetname);
        return this.getSheetRows(sheetindex, fieldlist, rowindex);
    }

    public Rows getSheetRows(int sheetindex, ArrayList<String> fieldlist, int rowindex) {
        HSSFSheet sheet = this.hssfWorkbook.getSheetAt(sheetindex);
        int rowcount = sheet.getPhysicalNumberOfRows();
        Rows rows = new Rows();
        rows.setFieldList(fieldlist);
        while (rowindex < rowcount) {
            Row row = new Row();
            HSSFRow hssfRow = sheet.getRow(rowindex);
            int columncount = hssfRow.getPhysicalNumberOfCells();
            for (int n = 0; n < columncount; ++n) {
                HSSFCell cell = hssfRow.getCell(n);
                cell.setCellType(CellType.STRING);
                if (fieldlist.size() <= n) continue;
                String fieldname = fieldlist.get(n);
                try {
                    row.put(fieldname, cell.getStringCellValue());
                    continue;
                }
                catch (Exception e) {
                    row.put(fieldname, "");
                }
            }
            rows.add(row);
            ++rowindex;
        }
        return rows;
    }

    public void close() {
        if (this.hssfWorkbook != null) {
            try {
                this.hssfWorkbook.close();
                this.hssfWorkbook = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws YosException, IOException {
        DBConnect dbConnect = new DBConnect();
        Rows rows = dbConnect.runSqlQuery("select *from sys_users");
        ExcelFactory2003 excelFactory = new ExcelFactory2003("asdas");
        excelFactory.addSheet("nihao", rows);
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        list.add("c");
        list.add("d");
        list.add("e");
        list.add("f");
        list.add("g");
        list.add("h");
        Rows rows3 = excelFactory.getSheetRows(0, list, 1);
        excelFactory.write();
        excelFactory.close();
    }
}

