package restcontroller.sysmanage.develop.report;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.UpdateSQL;
import objectregister.sys_report_config;
import org.apache.commons.io.IOUtils;
import restcontroller.R;
import utility.tools.WebRequest;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Calendar;

public class report extends Controller {
    public report(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "报表系统配置参数查询", apiversion = R.ID10025201.v1.class)
    public String queryReportConfig() throws YosException {
        new sys_report_config().DataInit();
        String reporttype = content.getString("reporttype");
        Rows rows = dbConnect.runSqlQuery("select sys_report_configid,config from sys_report_config where reporttype='" + reporttype + "'");
        return getSucReturnObject().setData(rows.get(0)).toString();
    }

    @API(title = "报表系统配置参数更新", apiversion = R.ID10025301.v1.class)
    public String reportConfigUpdate() throws YosException {
        String reporttype = content.getString("reporttype");
        JSONObject config = content.getJSONObject("config");
        UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_report_config");
        updateSQL.setValue("config", config);
        updateSQL.setWhere("reporttype", reporttype);
        updateSQL.update();
        return getSucReturnObject().toString();
    }

    @API(title = "报表列表查询", apiversion = R.ID10015901.v1.class)
    public String queryReportList() throws YosException {
        SQLFactory sqlFactory = new SQLFactory(this, "报表查询");
        Rows rows = dbConnect.runSqlQuery(sqlFactory.getSQL());
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "新增报表", apiversion = R.ID10016001.v1.class)
    public String insertReport() throws YosException {
        String jimu_report_id = String.valueOf(Calendar.getInstance().getTimeInMillis());
        SQLFactory sqlFactory = new SQLFactory(this, "报表新增");
        long sys_reportid = createTableID("sys_report");
        sqlFactory.addParameter("sys_reportid", sys_reportid);
        sqlFactory.addParameter("siteid", content.getStringValue("siteid"));
        sqlFactory.addParameter("jimu_report_id", jimu_report_id);
        sqlFactory.addParameter("systemappid", content.getLongValue("systemappid"));

        sqlFactory.addParameter("reporttype", content.getStringValue("reporttype"));
        if (content.getStringValue("reporttype").equals("积木报表")) {
            sqlFactory.addParameter("name", "");
            sqlFactory.addParameter("filename", "");
            sqlFactory.addParameter("type", "");
        } else {
            String name = content.getStringValue("name");
            String filename = content.getStringValue("filename");
            if (dbConnect.runSqlQuery("select * from sys_report where name='" + name + "'").isNotEmpty()) {
                return getErrReturnObject().setErrMsg("报表名称【" + name + "】已存在").toString();
            }
            if (dbConnect.runSqlQuery("select * from sys_report where filename='" + filename + "'").isNotEmpty()) {
                return getErrReturnObject().setErrMsg("报表文件名称【" + filename + "】已被使用").toString();
            }
            sqlFactory.addParameter("name", name);
            sqlFactory.addParameter("filename", content.getStringValue("filename"));
            sqlFactory.addParameter("type", content.getStringValue("type"));
        }
        dbConnect.runSqlUpdate(sqlFactory.getSQL());
        if (content.getStringValue("reporttype").equals("积木报表")) {
            return getSucReturnObject().setData("/yosreport/jmreport/index/" + jimu_report_id + "?token=" + getReportToken(sys_reportid)).toString();
        } else {
            return getSucReturnObject().toString();
        }
    }


    @API(title = "Birt报表上传", apiversion = R.ID10025001.v1.class)
    public String BirtReportUpLoad() throws YosException {
        long sys_reportid = content.getLongValue("sys_reportid");
        Long attachmentid = content.getLong("attachmentid");

        Rows configrows = dbConnect.runSqlQuery("select config from sys_report_config where reporttype='Birt报表'");
        String filepath = "";
        if (!configrows.isEmpty()) {
            try {
                JSONObject configObject = configrows.get(0).getJSONObject("config");
                if (configObject.containsKey("BIRT_VIEWER_WORKING_FOLDER")) {
                    filepath = configObject.getString("BIRT_VIEWER_WORKING_FOLDER");
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (filepath.equals("")) {
            filepath = System.getProperty("catalina.home") + "/webapps/birt_report";
        }

        File file = new File(filepath);
        if (!file.exists() && !file.mkdir()) {
            return getErrReturnObject().setErrMsg("Birt报表文件存放路径创建失败：" + filepath).toString();
        }
        Rows rows = dbConnect.runSqlQuery("select *from sys_report where sys_reportid='" + sys_reportid + "'");
        if (rows.isEmpty()) {
            return getErrReturnObject().setErrMsg("找不到报表id" + sys_reportid).toString();
        }
        String fileurl = filepath + "/" + rows.get(0).getString("filename") + ".rptdesign";
        InputStream inputStream = getPostFileInputStream(attachmentid);
        if (inputStream != null) {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(fileurl);
                int ch = 0;
                while ((ch = inputStream.read()) != -1) {
                    fileOutputStream.write(ch);
                }
                fileOutputStream.flush();
            } catch (Exception e) {
                e.printStackTrace();
                return getErrReturnObject().toString();
            } finally {
                IOUtils.closeQuietly(fileOutputStream);
                IOUtils.closeQuietly(inputStream);
            }
        } else {
            return getErrReturnObject().toString();
        }
        createFileLink("sys_report", sys_reportid, "default", attachmentid);
        return getSucReturnObject().toString();
    }

    @API(title = "修改报表", apiversion = R.ID10016101.v1.class)
    public String updateReport() throws YosException {
        long sys_reportid = content.getLongValue("sys_reportid");
        String siteid = content.getStringValue("siteid");
        long systemappid = content.getLongValue("systemappid");
        boolean isused = content.getBooleanValue("isused");

        String name = content.getStringValue("name");
        String filename = content.getStringValue("filename");

        if (dbConnect.runSqlQuery("select * from sys_report where reporttype='Birt报表' and  name='" + name + "' and sys_reportid!=" + sys_reportid).isNotEmpty()) {
            return getErrReturnObject().setErrMsg("报表名称【" + name + "】已存在").toString();
        }
        if (dbConnect.runSqlQuery("select * from sys_report where reporttype='Birt报表' and filename='" + filename + "' and sys_reportid!=" + sys_reportid).isNotEmpty()) {
            return getErrReturnObject().setErrMsg("报表文件名称【" + filename + "】已被使用").toString();
        }
        dbConnect.runSqlUpdate("update sys_report set filename='" + filename + "',name='" + name + "', siteid='" + siteid + "',systemappid='" + systemappid + "',isused='" + (isused ? 1 : 0) + "' where sys_reportid=" + sys_reportid);
        return getSucReturnObject().toString();
    }

    @API(title = "删除报表", apiversion = R.ID10016201.v1.class)
    public String deleteReport() throws YosException {
        dbConnect.runSqlUpdate("delete from sys_report where sys_reportid=" + content.getLongValue("sys_reportid"));
        return getSucReturnObject().toString();
    }

    @API(title = "请求报表预览页面", apiversion = R.ID10016301.v1.class)
    public String viewReport() throws YosException {
        long sys_reportid = content.getLongValue("sys_reportid");
        Rows rows = dbConnect.runSqlQuery("select *from sys_report where sys_reportid=" + sys_reportid);
        if (rows.isEmpty()) {
            return getErrReturnObject().setErrMsg("找不到报表信息").toString();
        }
        String filename = rows.get(0).getString("filename");
        return getSucReturnObject().setData("/birt/frameset?__report=" + filename + ".rptdesign&token=" + getReportToken(sys_reportid)).toString();
    }


    @API(title = "请求报表编辑页面", apiversion = R.ID10016301.v1.class)
    public String editReport() throws YosException {
        long sys_reportid = content.getLongValue("sys_reportid");
        Rows rows = dbConnect.runSqlQuery("select *from sys_report where sys_reportid=" + sys_reportid);
        if (rows.isEmpty()) {
            return getErrReturnObject().setErrMsg("找不到报表信息").toString();
        }
        String jimu_report_id = rows.get(0).getString("jimu_report_id");
        return getSucReturnObject().setData("/yosreport/jmreport/index/" + jimu_report_id + "?token=" + getReportToken(sys_reportid)).toString();
    }

    @API(title = "报表复制", apiversion = R.ID10016401.v1.class)
    public String copyReport() throws YosException {
        long sys_reportid = content.getLongValue("sys_reportid");
        Rows rows = dbConnect.runSqlQuery("select *from sys_report where sys_reportid=" + sys_reportid);
        if (rows.isEmpty()) {
            return getErrReturnObject().setErrMsg("找不到报表信息").toString();
        }
        String jimu_report_id = rows.get(0).getString("jimu_report_id");
        String siteid_copy = rows.get(0).getString("siteid");
        String systemappid_copy = rows.get(0).getString("systemappid");
        String reporttype_copy = rows.get(0).getString("reporttype");
        String url = request.getHttpServletRequest().getRequestURL().toString();
        url = url.replace("/yos/rest/index", "/yosreport/jmreport/reportCopy?id=" + jimu_report_id + "&token=" + getReportToken(sys_reportid));
        String copyresult = new WebRequest().doGet(url);
        try {
            JSONObject copyResultObject = JSONObject.parseObject(copyresult);
            if (copyResultObject.getBooleanValue("success")) {
                Rows copyReportRows = dbConnect.runSqlQuery("select t1.id from jimureport.jimu_report t1 left join sys_report t2 on t1.id=t2.jimu_report_id where t2.jimu_report_id is null order by t1.create_time desc");
                if (copyReportRows.isNotEmpty()) {
                    SQLFactory sqlFactory = new SQLFactory(this, "报表新增");
                    long sys_reportid_new = createTableID("sys_report");
                    sqlFactory.addParameter("sys_reportid", sys_reportid_new);
                    sqlFactory.addParameter("siteid", siteid_copy);
                    sqlFactory.addParameter("jimu_report_id", copyReportRows.get(0).getString("id"));
                    sqlFactory.addParameter("systemappid", systemappid_copy);
                    sqlFactory.addParameter("reporttype", reporttype_copy);
                    sqlFactory.addParameter("name", "");
                    sqlFactory.addParameter("filename", "");
                    sqlFactory.addParameter("type", "");
                    dbConnect.runSqlUpdate(sqlFactory.getSQL());
                    return getSucReturnObject().setData("/yosreport/jmreport/index/" + copyReportRows.get(0).getString("id") + "?token=" + getReportToken(sys_reportid_new)).toString();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return getErrReturnObject().toString();
    }
}
