package restcontroller.sysmanage.develop.database;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.SQLFactory;
import common.data.db.SQLiteMemory;
import restcontroller.R;
import utility.tools.WebRequest;

import java.util.ArrayList;

@API(title = "管理端-开发-数据库管理")
public class database extends Controller {
    public database(JSONObject content) throws YosException {
        super(content);
    }

    /**
     * 数据库结构对比
     *
     * @return
     */
    @API(title = "数据库结构对比", apiversion = R.ID10008901.v1.class)
    public String dbContrast() throws YosException {
        {
            String url = content.getString("url");
            String token = content.getString("token");
            JSONObject object = new JSONObject();
            object.put("accesstoken", token);
            object.put("classname", "sysmanage.develop.database.database");
            object.put("method", "getDBTables");
            object.put("content", new JSONObject());
            WebRequest webRequest = new WebRequest();
            String res = webRequest.doPost(object.toJSONString(), url);
            JSONArray resDataArray = JSONObject.parseObject(res).getJSONArray("data");
            //创建远程数据临时表
            SQLiteMemory.runSqlUpdate("CREATE TABLE THATTABLES (TABLE_NAME VARCHAR,TABLE_COMMENT VARCHAR);");
            SQLiteMemory.runSqlUpdate("CREATE TABLE THATTABLECOLUMNS (TABLE_NAME VARCHAR,COLUMN_NAME VARCHAR,COLUMN_DEFAULT VARCHAR,IS_NULLABLE VARCHAR,NUMERIC_PRECISION VARCHAR,NUMERIC_SCALE VARCHAR,COLUMN_TYPE VARCHAR,COLUMN_COMMENT VARCHAR);");

            ArrayList<String> SQLlist = new ArrayList<>();

            for (Object resData : resDataArray) {
                JSONObject tableObject = (JSONObject) resData;
                String TABLE_NAME = tableObject.getString("TABLE_NAME");
                String TABLE_COMMENT = tableObject.getString("TABLE_COMMENT");
                SQLlist.add("insert into THATTABLES(TABLE_NAME,TABLE_COMMENT) values ('" + TABLE_NAME + "','" + TABLE_COMMENT + "');");

                StringBuffer insertcolumns = new StringBuffer("insert into THATTABLECOLUMNS(TABLE_NAME,COLUMN_NAME,COLUMN_DEFAULT,IS_NULLABLE,NUMERIC_PRECISION,NUMERIC_SCALE,COLUMN_TYPE,COLUMN_COMMENT) values");
                JSONArray columnsArray = tableObject.getJSONArray("COLUMNS");
                for (Object colum : columnsArray) {
                    JSONObject columObject = (JSONObject) colum;
                    String COLUMN_NAME = columObject.getString("COLUMN_NAME");
                    String COLUMN_DEFAULT = columObject.getString("COLUMN_DEFAULT");
                    String IS_NULLABLE = columObject.getString("IS_NULLABLE");
                    String NUMERIC_PRECISION = columObject.getString("NUMERIC_PRECISION");
                    String NUMERIC_SCALE = columObject.getString("NUMERIC_SCALE");
                    String COLUMN_TYPE = columObject.getString("COLUMN_TYPE");
                    String COLUMN_COMMENT = columObject.getString("COLUMN_COMMENT");
                    insertcolumns.append("('" + TABLE_NAME + "','" + COLUMN_NAME + "','" + COLUMN_DEFAULT + "','" + IS_NULLABLE + "','" + NUMERIC_PRECISION + "','" + NUMERIC_SCALE + "','" + COLUMN_TYPE + "','" + COLUMN_COMMENT + "'),");
                }
                insertcolumns.replace(insertcolumns.length() - 1, insertcolumns.length(), "");
                SQLlist.add(insertcolumns.toString());
            }
            SQLiteMemory.runSqlUpdate(SQLlist);
        }

        {
            SQLiteMemory.runSqlUpdate("CREATE TABLE THISTABLES (TABLE_NAME VARCHAR,TABLE_COMMENT VARCHAR);");
            SQLiteMemory.runSqlUpdate("CREATE TABLE THISTABLECOLUMNS (TABLE_NAME VARCHAR,COLUMN_NAME VARCHAR,COLUMN_DEFAULT VARCHAR,IS_NULLABLE VARCHAR,NUMERIC_PRECISION VARCHAR,NUMERIC_SCALE VARCHAR,COLUMN_TYPE VARCHAR,COLUMN_COMMENT VARCHAR);");

            JSONArray dataArray = JSONObject.parseObject(getDBTables()).getJSONArray("data");
            ArrayList<String> SQLlist = new ArrayList<>();
            for (Object resData : dataArray) {
                JSONObject tableObject = (JSONObject) resData;
                String TABLE_NAME = tableObject.getString("TABLE_NAME");
                String TABLE_COMMENT = tableObject.getString("TABLE_COMMENT");
                SQLlist.add("insert into THISTABLES(TABLE_NAME,TABLE_COMMENT) values ('" + TABLE_NAME + "','" + TABLE_COMMENT + "');");

                StringBuffer insertcolumns = new StringBuffer("insert into THISTABLECOLUMNS(TABLE_NAME,COLUMN_NAME,COLUMN_DEFAULT,IS_NULLABLE,NUMERIC_PRECISION,NUMERIC_SCALE,COLUMN_TYPE,COLUMN_COMMENT) values");
                JSONArray columnsArray = tableObject.getJSONArray("COLUMNS");
                for (Object colum : columnsArray) {
                    JSONObject columObject = (JSONObject) colum;
                    String COLUMN_NAME = columObject.getString("COLUMN_NAME");
                    String COLUMN_DEFAULT = columObject.getString("COLUMN_DEFAULT");
                    String IS_NULLABLE = columObject.getString("IS_NULLABLE");
                    String NUMERIC_PRECISION = columObject.getString("NUMERIC_PRECISION");
                    String NUMERIC_SCALE = columObject.getString("NUMERIC_SCALE");
                    String COLUMN_TYPE = columObject.getString("COLUMN_TYPE");
                    String COLUMN_COMMENT = columObject.getString("COLUMN_COMMENT");
                    insertcolumns.append("('" + TABLE_NAME + "','" + COLUMN_NAME + "','" + COLUMN_DEFAULT + "','" + IS_NULLABLE + "','" + NUMERIC_PRECISION + "','" + NUMERIC_SCALE + "','" + COLUMN_TYPE + "','" + COLUMN_COMMENT + "'),");
                }
                insertcolumns.replace(insertcolumns.length() - 1, insertcolumns.length(), "");
                SQLlist.add(insertcolumns.toString());
            }
            SQLiteMemory.runSqlUpdate(SQLlist);
        }

        SQLFactory sqlFactory = new SQLFactory(this, "缓存数据库表字段查询");
        Rows rows = SQLiteMemory.runSqlQuery(sqlFactory.getSQL());
        RowsMap rowsMap = rows.toRowsMap("TABLE_NAME");
        JSONObject object = new JSONObject();
        for (String tablename : rowsMap.keySet()) {
            Rows rows1 = rowsMap.get(tablename);
            rows1.removeColumn(new String[]{"TABLE_NAME"});
            object.put(tablename, rows1);
        }
        return object.toString();
    }

    /**
     * 获取数据库表字段信息
     *
     * @return
     */
    @API(title = "获取数据库表字段信息", apiversion = R.ID10009001.v1.class)
    public String getDBTables() throws YosException {
        SQLFactory selectTable = new SQLFactory(this, "数据表信息查询");
        selectTable.addParameter("TABLE_SCHEMA", dbConnect.getDBName());
        Rows tableRows = dbConnect.runSqlQuery(selectTable.getSQL());

        SQLFactory selectcolumn = new SQLFactory(this, "数据表字段信息查询");
        selectcolumn.addParameter("TABLE_SCHEMA", dbConnect.getDBName());
        RowsMap columnRowsMap = dbConnect.runSqlQuery(selectcolumn).toRowsMap("TABLE_NAME");

        //JSONObject tableObject = new JSONObject();
        for (Row tableRow : tableRows) {
            //String TABLE_NAME = tableRow.getString("TABLE_NAME").toUpperCase();
            //JSONObject columnsObject = new JSONObject();
            Rows columnRows = columnRowsMap.get(tableRow.getString("TABLE_NAME"));
//            for (Row columnRow : columnRows) {
//                String COLUMN_NAME = columnRow.getString("COLUMN_NAME").toUpperCase();
//                columnsObject.put(COLUMN_NAME, columnRow.toJsonObject());
//            }
            tableRow.put("COLUMNS", columnRows);
            //tableObject.put(TABLE_NAME, tableRow);
        }
        return getSucReturnObject().setData(tableRows).toString();
    }
}
