package common.data;

import common.Controller;
import common.YosException;
import common.data.db.DBConnect;

import java.util.ArrayList;
import java.util.HashMap;

public class DeleteSQL extends BaseSQL<DeleteSQL> {
    protected DeleteSQL(Controller controller, String tablename) throws YosException {
        super(controller, tablename);
    }

    protected DeleteSQL(DBConnect dbConnect, String tablename) throws YosException {
        super(dbConnect, tablename);
    }

    /**
     * 设置主表别名
     *
     * @param table_alias
     * @return
     */
    public BaseSQL setTableAlias(String table_alias) {
        this.table_alias = table_alias;
        return this;
    }

    public String getSQL() throws YosException {
        if (!wherelist.isEmpty()) {
            StringBuilder deleteSql = new StringBuilder("delete " + table_alias + " from ").append(tablename).append(" as ").append(table_alias);
            deleteSql.append(" where ");
            boolean isfirstwhere = true;
            for (String where : wherelist) {
                deleteSql.append(isfirstwhere ? "(" : " and (").append(parameterDo(where)).append(")");
                isfirstwhere = false;
            }
            return deleteSql.toString();
        } else {
            throw new YosException(false, "删除必须设置条件语句！");
        }
    }

    public int delete() throws YosException {
        return dbConnect.runSqlUpdate(getSQL());
    }
}
