package utility.tools;

import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;

/**
 * 加解密工具
 */
public class Encryption {
    /**
     * MD5加密
     *
     * @param str
     * @return
     */
    public static String Encode_MD5(String str) {
        StringBuffer buf = new StringBuffer();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes());
            byte b[] = md.digest();
            int i;
            for (int offset = 0; offset < b.length; offset++) {
                i = b[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return buf.toString();
    }


    /**
     * Base64加密
     *
     * @param str
     * @return
     */
    public static String Encode_Base64(String str) {
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(str.getBytes());
    }


    /**
     * Base64解密
     *
     * @param str
     * @return
     */
    public static String Decode_Base64(String str) throws Exception {
        BASE64Decoder decoder = new BASE64Decoder();
        return new String(decoder.decodeBuffer(str));
    }

    public static String Decode_Base64(String str, String charSetName) throws Exception {
        BASE64Decoder decoder = new BASE64Decoder();
        return new String(decoder.decodeBuffer(str), charSetName);
    }

    /**
     * 接口传递内容加密
     *
     * @param content     加密内容
     * @param accesstoken token前16位
     * @return
     * @throws Exception
     */
    public static String Encrypt_AES(String content, String accesstoken) throws Exception {
        //先将token进行base64位加密，然后取前16位作为密钥
        accesstoken = Encode_Base64(accesstoken).substring(0, 16);
        byte[] raw = accesstoken.getBytes(StandardCharsets.UTF_8);
        SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");//"算法/模式/补码方式"
        cipher.init(Cipher.ENCRYPT_MODE, skeySpec);
        byte[] encrypted = cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));
        return new BASE64Encoder().encode(encrypted);//此处使用BASE64做转码功能，同时能起到2次加密的作用。
    }

    /**
     * 接口传递内容解密
     *
     * @param content     解密内容
     * @param accesstoken token前16位
     * @return
     */
    public static String Decrypt_AES(String content, String accesstoken) {
        //先将token进行base64位加密，然后取前16位作为密钥
        accesstoken = Encode_Base64(accesstoken).substring(0, 16);
        try {
            byte[] raw = accesstoken.getBytes(StandardCharsets.UTF_8);
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(Cipher.DECRYPT_MODE, skeySpec);
            byte[] encrypted1 = new BASE64Decoder().decodeBuffer(content);//先用base64解密
            try {
                byte[] original = cipher.doFinal(encrypted1);
                String originalString = new String(original, StandardCharsets.UTF_8);
                return originalString;
            } catch (Exception e) {
                System.out.println(e.toString());
                return null;
            }
        } catch (Exception ex) {
            System.out.println(ex.toString());
            return null;
        }
    }

}
