package utility.wechat.work.send;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.YosException;
import utility.wechat.work.GetAccessToken;
import utility.wechat.work.Parameter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class QYWechatMsgSender {

    private String address = "https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=";
    private URLConnection connection;
    private OutputStreamWriter out;
    private URL url;
    private String agentid = "0";

    public QYWechatMsgSender(String systemclient) throws IOException, YosException {
        address = address + GetAccessToken.get(systemclient);
        url = new URL(address);
        connection = url.openConnection();
        connection.setDoOutput(true);
        out = new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8);
        agentid = Parameter.getWorkParameter(systemclient).getString("work_agentid");
    }

    /**
     * 云链企业微信消息发送
     *
     * @throws IOException
     * @throws YosException
     */
    public QYWechatMsgSender() throws IOException, YosException {
        address = address + GetAccessToken.get("ww55ac0c7b67d58157", "RZs4nUEupv9eImkmV0x_n8u23ResOKXmhhXIN8sP8ok");
        url = new URL(address);
        connection = url.openConnection();
        connection.setDoOutput(true);
        out = new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8);
        agentid = "1000007";
    }

    public static void main(String[] args) throws YosException, IOException {
        QYWechatMsgSender wechatMsgSender = new QYWechatMsgSender();
        ArrayList<String> list = new ArrayList<>();
        list.add("HuiTaiLang");
        System.err.println(wechatMsgSender.sendTextMsg(list, "hello!"));
    }

    /**
     * 向用户发送文字消
     *
     * @param tousers 成员ID列表（消息接收，多个接收用|’分隔，支持1000个）。特殊情况：指定为@all，则向关注该企业应用的全部成员发
     * @param content 消息内容
     * @return 返回发信息的结果是否成
     * @throws IOException
     */
    public String sendTextMsg(ArrayList<String> tousers, String content) throws IOException {
        JSONObject object = new JSONObject();
        object.put("touser", join(tousers));
        object.put("toparty", null);
        object.put("totag", null);
        object.put("msgtype", "text");
        object.put("agentid", agentid);
        JSONObject textobject = new JSONObject();
        textobject.put("content", content);
        object.put("text", textobject);
        object.put("safe", "0");
        return Send(object);
    }

    /**
     * @param tousers  成员ID列表（消息接收，多个接收用|’分隔，支持1000个）。特殊情况：指定为@all，则向关注该企业应用的全部成员发
     * @param MEDIA_ID 图片媒体文件id，可以调用上传临时素材或者永久素材接口获永久素材media_id必须由发消息的应用创
     * @return 返回发信息的结果是否成
     * @throws IOException
     */
    public String sendImageMsg(ArrayList<String> tousers, String MEDIA_ID) throws IOException {
        JSONObject object = new JSONObject();
        object.put("touser", join(tousers));
        object.put("toparty", null);
        object.put("totag", null);
        object.put("msgtype", "image");
        object.put("agentid", agentid);
        JSONObject textobject = new JSONObject();
        textobject.put("media_id", MEDIA_ID);
        object.put("image", textobject);
        object.put("safe", "0");
        return Send(object);
    }

    /**
     * @param tousers  成员ID列表（消息接收，多个接收用|’分隔，支持1000个）。特殊情况：指定为@all，则向关注该企业应用的全部成员发
     * @param MEDIA_ID 图片媒体文件id，可以调用上传临时素材或者永久素材接口获永久素材media_id必须由发消息的应用创
     * @return 返回发信息的结果是否成
     * @throws IOException
     */
    public String sendVoiceMsg(ArrayList<String> tousers, String MEDIA_ID) throws IOException {
        JSONObject object = new JSONObject();
        object.put("touser", join(tousers));
        object.put("toparty", null);
        object.put("totag", null);
        object.put("msgtype", "voice");
        object.put("agentid", agentid);
        JSONObject textobject = new JSONObject();
        textobject.put("media_id", MEDIA_ID);
        object.put("voice", textobject);
        object.put("safe", "0");
        return Send(object);
    }

    /**
     * @param tousers     成员ID列表（消息接收，多个接收用|’分隔，支持1000个）。特殊情况：指定为@all，则向关注该企业应用的全部成员发
     * @param MEDIA_ID    图片媒体文件id，可以调用上传临时素材或者永久素材接口获永久素材media_id必须由发消息的应用创
     * @param Title       视频消息的标
     * @param Description 视频消息的描
     * @return 返回发信息的结果是否成
     * @throws IOException
     */
    public String sendVideoMsg(ArrayList<String> tousers, String MEDIA_ID, String Title, String Description) throws IOException {
        JSONObject object = new JSONObject();
        object.put("touser", join(tousers));
        object.put("toparty", null);
        object.put("totag", null);
        object.put("msgtype", "video");
        object.put("agentid", agentid);
        JSONObject textobject = new JSONObject();
        textobject.put("media_id", MEDIA_ID);
        textobject.put("title", Title);
        textobject.put("description", Description);
        object.put("video", textobject);
        object.put("safe", "0");
        return Send(object);
    }

    /**
     * @param tousers  成员ID列表（消息接收，多个接收用|’分隔，支持1000个）。特殊情况：指定为@all，则向关注该企业应用的全部成员发
     * @param MEDIA_ID 图片媒体文件id，可以调用上传临时素材或者永久素材接口获永久素材media_id必须由发消息的应用创
     * @return 返回发信息的结果是否成
     * @throws IOException
     */
    public String sendfileMsg(ArrayList<String> tousers, String MEDIA_ID) throws IOException {
        JSONObject object = new JSONObject();
        object.put("touser", join(tousers));
        object.put("toparty", null);
        object.put("totag", null);
        object.put("msgtype", "file");
        object.put("agentid", agentid);
        JSONObject textobject = new JSONObject();
        textobject.put("media_id", MEDIA_ID);
        object.put("file", textobject);
        object.put("safe", "0");
        return Send(object);
    }

    /**
     * @param tousers 成员ID列表（消息接收，多个接收用|’分隔，支持1000个）。特殊情况：指定为@all，则向关注该企业应用的全部成员发
     * @param news    新闻列表 类型为List<Map<String, String>>，其中map中的KEYtitle，description，url，picurl
     *                title：标
     *                description：描
     *                url：点击后跳转的链接
     *                picurl：图文消息的图片链接，支持JPG、PNG格式，较好的效果为大40*320，小0*80。如不填，在客户端不显示图片
     * @return
     * @throws IOException
     */
    public String sendNewsMsg(ArrayList<String> tousers, List<Map<String, String>> news) throws IOException {
        JSONObject object = new JSONObject();
        object.put("touser", join(tousers));
        object.put("toparty", null);
        object.put("totag", null);
        object.put("msgtype", "news");
        object.put("agentid", agentid);
        JSONObject newsobject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        for (Map<String, String> map : news) {
            JSONObject newobject = new JSONObject();
            newobject.put("title", map.get("title"));
            newobject.put("description", map.get("description"));
            newobject.put("url", map.get("url"));
            newobject.put("picurl", map.get("picurl"));
            jsonArray.add(newobject);
        }
        newsobject.put("articles", jsonArray);
        object.put("news", newsobject);
        return Send(object);
    }

    private String Send(JSONObject object) throws IOException {
        System.err.println(object.toString());
        out.write(object.toString()); // 这里组织提交信息
        out.flush();
        out.close();
        // 获取返回数据
        BufferedReader in = new BufferedReader(new InputStreamReader(
                connection.getInputStream()));
        String line = null;
        StringBuffer content = new StringBuffer();
        while ((line = in.readLine()) != null) {
            // line为返回，这就可以判断是否成功
            content.append(line);
        }
        in.close();
        return content.toString();
    }

    /**
     * 将数值转化成字符
     *
     * @param a
     * @return
     */
    public String join(ArrayList<String> a) {
        String b = null;
        if (a == null) {
            return b;
        }
        for (String c : a) {
            if (b == null || b.equals("")) {
                b = c;
            } else {
                b = b + "|" + c;
            }
        }
        return b;
    }
}
