package restcontroller.sysmanage.develop.workreportpreset;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import restcontroller.R;

@API(title = "工作汇报内容预设")
public class workreportpreset extends Controller {
    public workreportpreset(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "工作汇报内容预设列表查询", apiversion = R.ID10018601.v1.class)
    public String query_workreportpresetList() throws YosException {
        String siteid = content.getString("siteid");
        Rows rows = dbConnect.runSqlQuery("select * from sys_workreportpreset where siteid='" + siteid + "' order by sequence");
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "工作汇报内容预设新增修改", apiversion = R.ID10018701.v1.class)
    public String insertormodifyworkreportpreset() throws YosException {
        long sys_workreportpresetid = content.getLongValue("sys_workreportpresetid");
        String siteid = content.getString("siteid");
        int sequence = content.getIntValue("sequence");
        boolean issql = content.getBooleanValue("issql");
        String content_str = content.getString("content", true);
        String title = content.getString("title");
        boolean editable = content.getBooleanValue("editable");

        if (dbConnect.runSqlQuery("select *from sys_workreportpreset where siteid='" + siteid + "' and title='" + title + "' and sys_workreportpresetid!=" + sys_workreportpresetid).isNotEmpty()) {
            return getErrReturnObject().setErrMsg("标题重复！").toString();
        }

        if (sys_workreportpresetid <= 0 && dbConnect.runSqlQuery("select *from sys_workreportpreset where sys_workreportpresetid=" + sys_workreportpresetid).isEmpty()) {
            SQLFactory sqlFactory = new SQLFactory(this, "工作汇报内容预设新增");
            sqlFactory.addParameter("sys_workreportpresetid", createTableID("sys_workreportpreset"));
            sqlFactory.addParameter("siteid", siteid);
            sqlFactory.addParameter("sequence", sequence);
            sqlFactory.addParameter("issql", issql);
            sqlFactory.addParameter("content", content_str);
            sqlFactory.addParameter("title", title);
            sqlFactory.addParameter("editable", editable);
            dbConnect.runSqlUpdate(sqlFactory.getSQL());
        } else {
            SQLFactory sqlFactory = new SQLFactory(this, "工作汇报内容预设修改");
            sqlFactory.addParameter("sys_workreportpresetid", sys_workreportpresetid);
            sqlFactory.addParameter("siteid", siteid);
            sqlFactory.addParameter("sequence", sequence);
            sqlFactory.addParameter("issql", issql);
            sqlFactory.addParameter("content", content_str);
            sqlFactory.addParameter("title", title);
            sqlFactory.addParameter("editable", editable);
            dbConnect.runSqlUpdate(sqlFactory.getSQL());
        }
        return getSucReturnObject().toString();
    }

    @API(title = "工作汇报内容预设删除", apiversion = R.ID10018801.v1.class)
    public String deleteworkreportpreset() throws YosException {
        long sys_workreportpresetid = content.getLong("sys_workreportpresetid");

        Rows rows = dbConnect.runSqlQuery("select t1.sys_workreportpresetids from sys_workreportmodel t1 inner join sys_workreportpreset t2 on t1.siteid=t2.siteid where t2.sys_workreportpresetid=" + sys_workreportpresetid);
        for (Row row : rows) {
            for (Object o : row.getJSONArray("sys_workreportpresetids")) {
                JSONObject object = (JSONObject) o;
                if (sys_workreportpresetid == object.getLongValue("id")) {
                    return getErrReturnObject().setErrMsg("工作汇报内容预设已被使用，不可删除").toString();
                }
            }
        }
        dbConnect.runSqlUpdate("delete from sys_workreportpreset where sys_workreportpresetid=" + sys_workreportpresetid);
        return getSucReturnObject().toString();
    }

    @API(title = "获取工作人员汇报内容", apiversion = R.ID10018901.v1.class)
    public String getWorkReportContent() throws YosException {
        long sys_workreportpresetid = content.getLong("sys_workreportpresetid");
        Rows rows = dbConnect.runSqlQuery("select title,content,issql,editable from sys_workreportpreset where sys_workreportpresetid='" + sys_workreportpresetid + "'");
        if (rows.isNotEmpty()) {
            Row row = rows.get(0);
            if (row.getBoolean("issql")) {
                String sqlstr = row.getString("content");
                sqlstr = SQLSystemParamHandle(sqlstr);
//                if (sqlstr.contains(":hrid")) {
//                    sqlstr = sqlstr.replace(":hrid", String.valueOf(hrid));
//                }
//                if (sqlstr.contains(":userid")) {
//                    sqlstr = sqlstr.replace(":userid", String.valueOf(userid));
//                }
//                if (sqlstr.contains(":sys_enterpriseid")) {
//                    sqlstr = sqlstr.replace(":sys_enterpriseid", String.valueOf(sys_enterpriseid));
//                }
//                if (sqlstr.contains(":departmentid")) {
//                    sqlstr = sqlstr.replace(":departmentid", String.valueOf(departmentid));
//                }
//                if (sqlstr.contains(":subuserids")) {
//                    ArrayList<Long> sublist = User.getSubUserIds(this);
//                    sublist.add(userid);
//                    sqlstr = sqlstr.replace(":subuserids", sublist.toString().replace("[", "(").replace("]", ")"));
//                }
//                if (sqlstr.contains(":subhrids")) {
//                    ArrayList<Long> sublist = User.getSubHrIds(this);
//                    sublist.add(hrid);
//                    sqlstr = sqlstr.replace(":subhrids", sublist.toString().replace("[", "(").replace("]", ")"));
//                }
//                if (sqlstr.contains(":subsys_enterpriseids")) {
//                    ArrayList<Long> sublist = User.getSubEnterpriseids(this);
//                    if (sublist.isEmpty()) {
//                        sqlstr = sqlstr.replace(":subsys_enterpriseids", "(null)");
//                    } else {
//                        sqlstr = sqlstr.replace(":subsys_enterpriseids", sublist.toString().replace("[", "(").replace("]", ")"));
//                    }
//                }
//                if (sqlstr.contains(":subdepartmentids")) {
//                    ArrayList<Long> sublist = Department.getSubDepartmentIds(this);
//                    sublist.add(departmentid);
//                    sqlstr = sqlstr.replace(":subdepartmentids", sublist.toString().replace("[", "(").replace("]", ")"));
//                }
                if (!sqlstr.equals("")) {
                    Rows contentrows = dbConnect.runSqlQuery(sqlstr);
                    row.put("content", contentrows);
                } else {
                    row.put("content", new JSONArray());
                }
            } else {
                JSONArray contentArray = new JSONArray();

                JSONObject contentObject = new JSONObject();
                contentObject.put("rowindex", 1);
                contentObject.put("content", row.getString("content"));

                contentArray.add(contentObject);

                row.put("content", contentArray);
            }
            row.remove("issql");
            return getSucReturnObject().setData(row).toString();
        }
        return getSucReturnObject().setData(new JSONObject()).toString();
    }
}
