/*
 * Decompiled with CFR 0.152.
 */
package utility.wechat.wechatpay.POJO;

import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.dom.DOMElement;
import utility.tools.WebRequest;
import utility.wechat.wechatpay.POJO.Base;
import utility.wechat.wechatpay.POJO.CreateOrderResponse;

public class CreateOrderRequest
extends Base {
    private String appid;
    private String body;
    private String mch_id;
    private String notify_url;
    private String out_trade_no;
    private String spbill_create_ip;
    private Integer total_fee;
    private String trade_type;
    private String openid;

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setMch_id(String mch_id) {
        this.mch_id = mch_id;
    }

    public void setNotify_url(String notify_url) {
        this.notify_url = notify_url;
    }

    public void setOut_trade_no(String out_trade_no) {
        this.out_trade_no = out_trade_no;
    }

    public void setSpbill_create_ip(String spbill_create_ip) {
        this.spbill_create_ip = spbill_create_ip;
    }

    public void setTotal_fee(int total_fee) {
        this.total_fee = total_fee;
    }

    public void setTrade_type(String trade_type) {
        this.trade_type = trade_type;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public CreateOrderResponse getOrderResponse(String mch_key) {
        String requestxml = this.asXml(mch_key);
        String res = new WebRequest().doPost(requestxml, "https://api.mch.weixin.qq.com/pay/unifiedorder");
        return this.getCreateOrderResponse(res);
    }

    private String asXml(String mch_key) {
        DOMElement request = new DOMElement("xml");
        request.addElement("appid").addText(this.appid);
        request.addElement("body").addText(this.body);
        request.addElement("mch_id").addText(this.mch_id);
        request.addElement("nonce_str").addText(this.createNonce_str(this.out_trade_no + this.spbill_create_ip));
        request.addElement("notify_url").addText(this.notify_url);
        if (this.openid != null) {
            request.addElement("openid").addText(this.openid);
        }
        request.addElement("out_trade_no").addText(this.out_trade_no);
        request.addElement("spbill_create_ip").addText(this.spbill_create_ip);
        request.addElement("total_fee").addText(String.valueOf(this.total_fee));
        request.addElement("trade_type").addText(this.trade_type);
        this.createSign(request, mch_key);
        return request.asXML();
    }

    private CreateOrderResponse getCreateOrderResponse(String response) {
        CreateOrderResponse orderResponse = new CreateOrderResponse();
        try {
            Document respones = DocumentHelper.parseText((String)response);
            Iterator it = respones.getRootElement().elementIterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                String key = element.getName();
                String text = element.getText();
                switch (key) {
                    case "return_code": {
                        orderResponse.setReturn_code(text);
                        break;
                    }
                    case "return_msg": {
                        orderResponse.setReturn_msg(text);
                        break;
                    }
                    case "appid": {
                        orderResponse.setAppid(text);
                        break;
                    }
                    case "mch_id": {
                        orderResponse.setMch_id(text);
                        break;
                    }
                    case "device_info": {
                        orderResponse.setDevice_info(text);
                        break;
                    }
                    case "nonce_str": {
                        orderResponse.setNonce_str(text);
                        break;
                    }
                    case "sign": {
                        orderResponse.setSign(text);
                        break;
                    }
                    case "result_code": {
                        orderResponse.setResult_code(text);
                        break;
                    }
                    case "err_code": {
                        orderResponse.setErr_code(text);
                        break;
                    }
                    case "err_code_des": {
                        orderResponse.setErr_code_des(text);
                        break;
                    }
                    case "trade_type": {
                        orderResponse.setTrade_type(text);
                        break;
                    }
                    case "prepay_id": {
                        orderResponse.setPrepay_id(text);
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return orderResponse;
    }
}

