/*
 * Decompiled with CFR 0.152.
 */
package common.data;

import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.Controller;
import common.YosException;
import common.data.BaseSQL;
import common.data.FieldMeta;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.db.DBConnect;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import restcontroller.sysmanage.develop.appregistry.appregistry_table;
import utility.tools.Encryption;

public class QuerySQL
extends BaseSQL<QuerySQL>
implements Cloneable {
    private boolean withdeletedata = false;
    private int pageSize = 0;
    private int pageNumber = 0;
    public int pageSize_s = 0;
    private HashMap<String, ArrayList<String>> queryfieldnames = new HashMap();
    private ArrayList<String> orderbylist = new ArrayList();
    private HashMap<String, String> formulafieldMap = new HashMap();
    boolean dataAuthFlag = true;
    private ArrayList<String> joinlist = new ArrayList();
    private HashMap<String, BaseClass.JOINTYPE> linkjointypeMap = new HashMap();
    private HashMap<String, String> linktablenameMap = new HashMap();
    private HashMap<String, String> linkconditionMap = new HashMap();
    private ArrayList<String> groupbyList = new ArrayList();
    private boolean isgroupby = false;
    private String rowcountsql = "";
    private static HashMap<String, HashMap<String, FieldMeta>> FieldsMetaMap = new HashMap();
    private static HashMap<String, Row> queryCountMap = new HashMap();
    private static int queryCountHour = 0;
    private boolean withroledatalimit = true;
    private static int day = 0;
    public static HashMap<String, QuerySQL> QuerySQLMap = new HashMap();
    private static HashMap<String, RowsMap> tokendatalimitRowsMap = new HashMap();
    private boolean withoutorderby = false;
    private ArrayList<String> temporaryTable = new ArrayList();

    protected QuerySQL(Controller controller, String tablename) throws YosException {
        super(controller, tablename);
        this.queryfieldnames.put(this.table_alias, new ArrayList());
    }

    protected QuerySQL(Controller controller, String tablename, String ... fieldnames) throws YosException {
        super(controller, tablename);
        this.queryfieldnames.put(this.table_alias, new ArrayList());
        this.addQueryFields(fieldnames);
    }

    protected QuerySQL(DBConnect dbConnect, String tablename) throws YosException {
        super(dbConnect, tablename);
        this.queryfieldnames.put(this.table_alias, new ArrayList());
    }

    protected QuerySQL(DBConnect dbConnect, String tablename, String ... fieldnames) throws YosException {
        super(dbConnect, tablename);
        this.queryfieldnames.put(this.table_alias, new ArrayList());
        this.addQueryFields(fieldnames);
    }

    public QuerySQL withDeleteData(boolean withdeletedata) {
        this.withdeletedata = withdeletedata;
        return this;
    }

    public QuerySQL setTableAlias(String table_alias) {
        ArrayList<String> list = this.queryfieldnames.get(this.table_alias);
        this.queryfieldnames.remove(this.table_alias);
        this.queryfieldnames.put(table_alias, list);
        this.table_alias = table_alias;
        return this;
    }

    public QuerySQL setRoleDataLimit(boolean withroledatalimit) {
        this.withroledatalimit = withroledatalimit;
        return this;
    }

    public QuerySQL setDataAuth(boolean withdataauth) throws YosException {
        if (withdataauth && this.controller != null && this.dataAuthFlag) {
            if (((ArrayList)this.tableColumnNames.get(this.tablename)).contains("siteid")) {
                this.addJoinTable(BaseClass.JOINTYPE.inner, "sys_dataauth_view", "sys_dataauth_view", "sys_dataauth_view.siteid= " + this.table_alias + ".siteid and sys_dataauth_view.ownertable='" + this.tablename + "' and sys_dataauth_view.ownerid=" + this.table_alias + "." + this.uniquecolumnname + " and sys_dataauth_view.userid=" + this.controller.userid);
            } else {
                this.addJoinTable(BaseClass.JOINTYPE.inner, "sys_dataauth_view", "sys_dataauth_view", "sys_dataauth_view.ownertable='" + this.tablename + "' and sys_dataauth_view.ownerid=" + this.table_alias + "." + this.uniquecolumnname + " and sys_dataauth_view.userid=" + this.controller.userid);
            }
            this.dataAuthFlag = false;
        }
        return this;
    }

    public QuerySQL addQueryFields(String ... fieldnames) {
        for (String fieldname : fieldnames) {
            if ((fieldname = fieldname.trim()).equals("")) continue;
            if (fieldname.contains(",")) {
                this.addQueryFields(fieldname.split(","));
                continue;
            }
            if (fieldname.contains(".")) {
                String[] c = fieldname.split("\\.");
                String t = c[0];
                String f = c[1];
                if (!this.queryfieldnames.containsKey(t)) {
                    this.queryfieldnames.put(t, new ArrayList());
                }
                if (this.queryfieldnames.get(t).contains(f)) continue;
                this.queryfieldnames.get(t).add(f);
                continue;
            }
            if (this.queryfieldnames.get(this.table_alias).contains(fieldname)) continue;
            this.queryfieldnames.get(this.table_alias).add(fieldname);
        }
        return this;
    }

    public QuerySQL addQueryFields(ArrayList<String> fieldnames) {
        return this.addQueryFields(fieldnames.toArray(new String[0]));
    }

    public QuerySQL addQueryFields(String column_name, String formula) {
        this.formulafieldMap.put(column_name, formula);
        return this;
    }

    public QuerySQL addJoinTable(BaseClass.JOINTYPE jointype, String tablename, String linkname, String condition) throws YosException {
        this.joinlist.add(linkname);
        this.linkjointypeMap.put(linkname, jointype);
        this.linktablenameMap.put(linkname, tablename);
        this.linkconditionMap.put(linkname, this.conditionHander(condition));
        if (!this.tableColumnNames.containsKey(tablename)) {
            this.tableColumnNames.put(tablename, this.getTableColumnNames(tablename));
        }
        return this;
    }

    public QuerySQL addJoinTable(BaseClass.JOINTYPE jointype, String tablename, String linkname, String condition, String ... fieldnames) throws YosException {
        this.joinlist.add(linkname);
        this.linkjointypeMap.put(linkname, jointype);
        this.linktablenameMap.put(linkname, tablename);
        this.linkconditionMap.put(linkname, this.conditionHander(condition));
        ArrayList<String> linkfieldnames = new ArrayList<String>();
        for (String fieldname : fieldnames) {
            if (!fieldname.contains(".")) {
                fieldname = linkname + "." + fieldname;
            }
            if (linkfieldnames.contains(fieldname)) continue;
            linkfieldnames.add(fieldname);
        }
        this.addQueryFields(linkfieldnames);
        if (!this.tableColumnNames.containsKey(tablename)) {
            this.tableColumnNames.put(tablename, this.getTableColumnNames(tablename));
        }
        return this;
    }

    public QuerySQL addJoinTable(BaseClass.JOINTYPE jointype, QuerySQL querySQL, String linkname, String condition) throws YosException {
        String tablename = "(" + querySQL.setWithOutOrderBy().getSQL() + ")";
        this.joinlist.add(linkname);
        this.linkjointypeMap.put(linkname, jointype);
        this.linktablenameMap.put(linkname, tablename);
        this.linkconditionMap.put(linkname, this.conditionHander(condition));
        try {
            if (!this.tableColumnNames.containsKey(tablename)) {
                this.tableColumnNames.put(tablename, ((QuerySQL)querySQL.clone().setWhere(" 1=2 ")).query().getFieldList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public QuerySQL addJoinTable(BaseClass.JOINTYPE jointype, QuerySQL querySQL, String linkname, String condition, String ... fieldnames) throws YosException {
        String tablename = "(" + querySQL.setWithOutOrderBy().getSQL() + ")";
        this.joinlist.add(linkname);
        this.linkjointypeMap.put(linkname, jointype);
        this.linktablenameMap.put(linkname, tablename);
        this.linkconditionMap.put(linkname, this.conditionHander(condition));
        ArrayList<String> linkfieldnames = new ArrayList<String>();
        for (String fieldname : fieldnames) {
            if (!fieldname.contains(".")) {
                fieldname = linkname + "." + fieldname;
            }
            if (linkfieldnames.contains(fieldname)) continue;
            linkfieldnames.add(fieldname);
        }
        this.addQueryFields(linkfieldnames);
        try {
            if (!this.tableColumnNames.containsKey(tablename)) {
                this.tableColumnNames.put(tablename, ((QuerySQL)querySQL.clone().setWhere(" 1=2 ")).query().getFieldList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public QuerySQL addGroupBy(String ... groupformulas) {
        this.isgroupby = true;
        this.groupbyList.addAll(Arrays.asList(groupformulas));
        return this;
    }

    public QuerySQL setOrderBy(String ... orderbys) {
        if (this.controller == null || this.controller.pageSorting == null || this.controller.pageSorting.equals("") || this.controller.pageSorting.equals("''")) {
            this.orderbylist.addAll(Arrays.asList(orderbys));
        }
        return this;
    }

    public QuerySQL setPage(int pageSize, int pageNumber) {
        if (this.controller != null && this.controller.pageSorting != null && !this.controller.pageSorting.equals("") && !this.controller.pageSorting.equals("''")) {
            this.orderbylist.clear();
            this.orderbylist.add(this.controller.pageSorting);
        }
        this.pageSize = pageSize;
        this.pageSize_s = pageSize;
        this.pageNumber = pageNumber;
        return this;
    }

    public String getSQL() throws YosException {
        this.rowcountsql = "";
        String fields_str = "";
        StringBuilder jointable_str = new StringBuilder();
        StringBuilder where_str = new StringBuilder(" where (1=1) ");
        if (!this.isgroupby && this.queryfieldnames.containsKey(this.table_alias) && this.queryfieldnames.get(this.table_alias).isEmpty()) {
            this.addQueryFields((ArrayList)this.tableColumnNames.get(this.tablename));
        }
        if (!this.isgroupby && ((ArrayList)this.tableColumnNames.get(this.tablename)).contains(this.getdataversioncolumnname(this.tablename))) {
            this.addQueryFields(this.getdataversioncolumnname(this.tablename));
        }
        for (String tablekey : this.queryfieldnames.keySet()) {
            for (String fieldname : this.queryfieldnames.get(tablekey)) {
                fields_str = fields_str.equals("") ? tablekey + "." + fieldname : fields_str + "," + tablekey + "." + fieldname;
            }
        }
        for (String linkname : this.joinlist) {
            String linktablename = this.linktablenameMap.get(linkname);
            String linkcondition = this.parameterDo(this.linkconditionMap.getOrDefault(linkname, ""));
            BaseClass.JOINTYPE jointype = this.linkjointypeMap.get(linkname);
            for (String tablefield : (ArrayList)this.tableColumnNames.get(this.tablename)) {
                linkcondition = linkcondition.replaceAll(":" + tablefield, this.table_alias + "." + tablefield);
            }
            for (String linktablefield : (ArrayList)this.tableColumnNames.get(linktablename)) {
                if (!linkcondition.contains(" " + linktablefield + " ")) continue;
                linkcondition = linkcondition.replaceAll(" " + linktablefield + " ", " " + linkname + "." + linktablefield + " ");
            }
            jointable_str.append(" ").append(jointype.toString()).append(" join ").append(linktablename).append(" as ").append(linkname).append(" on ").append(linkcondition);
        }
        for (String column_name : this.formulafieldMap.keySet()) {
            fields_str = fields_str.equals("") ? "(" + this.formulafieldMap.get(column_name) + ") as " + column_name : fields_str + ",(" + this.formulafieldMap.get(column_name) + ") as " + column_name;
        }
        fields_str = fields_str.equals("") ? "*" : fields_str;
        for (Iterator<String> where : this.wherelist) {
            where_str.append(" and ").append(this.parameterDo((String)((Object)where)));
        }
        if (((ArrayList)this.tableColumnNames.get(this.tablename)).contains("deleted") && !this.withdeletedata) {
            where_str.append(" and " + this.table_alias + ".deleted=0 ");
        }
        StringBuilder groupby_str = new StringBuilder();
        if (this.isgroupby) {
            if (this.groupbyList.isEmpty()) {
                for (String tkey : this.queryfieldnames.keySet()) {
                    for (String f : this.queryfieldnames.get(tkey)) {
                        this.groupbyList.add(tkey + "." + f);
                    }
                }
            }
            for (String groupby : this.groupbyList) {
                (groupby_str.toString().equals("") ? groupby_str.append(" group by ") : groupby_str.append(", ")).append(groupby);
            }
        }
        this.clientFieldFilterAndSort(fields_str, jointable_str.toString(), groupby_str.toString());
        String sql_str = "";
        if (this.withroledatalimit && this.controller != null && !this.controller.getAccesstoken().equals("")) {
            sql_str = "select " + fields_str + " from " + this.addRoleDataLimit() + jointable_str + where_str + groupby_str;
            if (groupby_str.toString().equals("")) {
                this.rowcountsql = "select count(0) as rowscount, CEILING(count(0)/(" + this.pageSize + "*1.0)) pagecount from " + this.addRoleDataLimit() + jointable_str + where_str;
            }
        } else {
            sql_str = "select " + fields_str + " from " + this.tablename + " as " + this.table_alias + jointable_str + where_str + groupby_str;
            if (groupby_str.toString().equals("")) {
                this.rowcountsql = "select count(0) as rowscount, CEILING(count(0)/(" + this.pageSize + "*1.0)) pagecount from " + this.tablename + " as " + this.table_alias + jointable_str + where_str + groupby_str;
            }
        }
        return this.addPageSQLStr(sql_str);
    }

    private void clientFieldFilterAndSort(String fields_str, String jointable_str, String groupby_str) throws YosException {
        long tableid;
        if (this.pageNumber > 0 && this.pageSize > 0 && this.controller != null && (tableid = this.controller.content.getLongValue("tableid")) > 0L) {
            String FieldsMetaMapKey = this.controller.requestAPI.getId() + "-" + this.controller.requestAPI.getVersion();
            if (!FieldsMetaMap.containsKey(FieldsMetaMapKey)) {
                FieldsMetaMap.put(FieldsMetaMapKey, this.controller.dbConnect.runSqlQuery("select " + fields_str + " from " + this.tablename + " as " + this.table_alias + jointable_str + " where 1=2 " + groupby_str).getFieldMetaMap());
            }
            if (this.controller.content.containsKey("where") && this.controller.content.getJSONObject("where").containsKey("tablefilter")) {
                JSONObject tablefilter = this.controller.content.getJSONObject("where").getJSONObject("tablefilter");
                for (String columnname : tablefilter.keySet()) {
                    int filter;
                    String filtervalue = tablefilter.getStringValue(columnname);
                    if (filtervalue.equals("") || !FieldsMetaMap.get(FieldsMetaMapKey).containsKey(columnname) || (filter = appregistry_table.getTableColFilter(this.controller, tableid, columnname)) <= 0) continue;
                    String table_alias = FieldsMetaMap.get(FieldsMetaMapKey).get(columnname).getTable_alias();
                    Class fieldclazztype = FieldsMetaMap.get(FieldsMetaMapKey).get(columnname).getFieldtype();
                    if (fieldclazztype == Integer.class || fieldclazztype == Long.class || fieldclazztype == Float.class || fieldclazztype == Double.class) {
                        if (filter == 1) {
                            this.setWhere(table_alias + "." + columnname + "=" + appregistry_table.getTableColMapping(this.controller, tableid, columnname, filtervalue.replaceFirst("=", "")));
                            continue;
                        }
                        if (filter != 2) continue;
                        if (filtervalue.startsWith(">=")) {
                            this.setWhere(table_alias + "." + columnname + ">=" + filtervalue.replaceFirst(">=", ""));
                            continue;
                        }
                        if (filtervalue.startsWith("<=")) {
                            this.setWhere(table_alias + "." + columnname + "<=" + filtervalue.replaceFirst("<=", ""));
                            continue;
                        }
                        if (filtervalue.startsWith(">")) {
                            this.setWhere(table_alias + "." + columnname + ">" + filtervalue.replaceFirst(">", ""));
                            continue;
                        }
                        if (filtervalue.startsWith("<")) {
                            this.setWhere(table_alias + "." + columnname + "<" + filtervalue.replaceFirst("<", ""));
                            continue;
                        }
                        this.setWhere(table_alias + "." + columnname + "=" + filtervalue.replaceFirst("=", ""));
                        continue;
                    }
                    if (fieldclazztype == Date.class) {
                        if (filter == 1) {
                            this.setWhere(table_alias + "." + columnname + "='" + filtervalue.replaceFirst("=", "") + "'");
                            continue;
                        }
                        if (filter != 2) continue;
                        if (filtervalue.startsWith(">=")) {
                            this.setWhere(table_alias + "." + columnname + ">='" + filtervalue.replaceFirst(">=", "") + "'");
                            continue;
                        }
                        if (filtervalue.startsWith("<=")) {
                            this.setWhere(table_alias + "." + columnname + "<='" + filtervalue.replaceFirst("<=", "") + "'");
                            continue;
                        }
                        if (filtervalue.startsWith(">")) {
                            this.setWhere(table_alias + "." + columnname + ">'" + filtervalue.replaceFirst(">", "") + "'");
                            continue;
                        }
                        if (filtervalue.startsWith("<")) {
                            this.setWhere(table_alias + "." + columnname + "<'" + filtervalue.replaceFirst("<", "") + "'");
                            continue;
                        }
                        if (filtervalue.equalsIgnoreCase("td")) {
                            this.setWhere("convert(" + table_alias + "." + columnname + ",date)=convert(now(),date)");
                            continue;
                        }
                        if (filtervalue.equalsIgnoreCase("tw")) {
                            this.setWhere(table_alias + "." + columnname + ">='" + QuerySQL.getWeekFirstDay() + "' and " + table_alias + "." + columnname + "<='" + QuerySQL.getWeekLastDay());
                            continue;
                        }
                        if (filtervalue.equalsIgnoreCase("tm")) {
                            this.setWhere(table_alias + "." + columnname + ">='" + QuerySQL.getMonthFirstDay() + "' and " + table_alias + "." + columnname + "<='" + QuerySQL.getMonthLastDay());
                            continue;
                        }
                        if (filtervalue.equalsIgnoreCase("ty")) {
                            this.setWhere("convert(" + table_alias + "." + columnname + ",year)=convert(now(),year)");
                            continue;
                        }
                        this.setWhere(table_alias + "." + columnname + "='" + filtervalue.replaceFirst("=", "") + "'");
                        continue;
                    }
                    if (filter == 1) {
                        this.setWhere(table_alias + "." + columnname + "='" + appregistry_table.getTableColMapping(this.controller, tableid, columnname, filtervalue.replaceFirst("=", "")) + "'");
                        continue;
                    }
                    if (filter != 2) continue;
                    this.setWhere(table_alias + "." + columnname + " like '%" + filtervalue + "%'");
                }
            }
            if (this.controller.content.containsKey("simplesort")) {
                JSONObject simplesortObject = this.controller.content.getJSONObject("simplesort");
                for (String fieldname : simplesortObject.keySet()) {
                    if (!FieldsMetaMap.get(FieldsMetaMapKey).containsKey(fieldname) || !appregistry_table.getTableColSortable(this.controller, tableid, fieldname)) continue;
                    this.orderbylist.clear();
                    String table_alias = FieldsMetaMap.get(FieldsMetaMapKey).get(fieldname).getTable_alias();
                    this.orderbylist.add(table_alias + "." + fieldname + (simplesortObject.getBooleanValue(fieldname) ? " asc" : " desc"));
                }
            }
        }
    }

    private String addRoleDataLimit() throws YosException {
        String where_str = "1=2";
        if (!tokendatalimitRowsMap.containsKey(this.controller.getAccesstoken())) {
            RowsMap rowsMap = this.controller.dbConnect.runSqlQuery("select distinct t2.sqlstr,t2.table_name from sys_userrole t1 inner join sys_role_datalimit t2 on t1.roleid=t2.roleid where t1.siteid='" + this.controller.siteid + "' and t1.userid='" + this.controller.userid + "'").toRowsMap("table_name");
            tokendatalimitRowsMap.put(this.controller.getAccesstoken(), rowsMap);
        }
        Rows limitSqlRows = tokendatalimitRowsMap.get(this.controller.getAccesstoken()).get(this.tablename);
        for (Row limitSqlRow : limitSqlRows) {
            String sqlstr = limitSqlRow.getString("sqlstr").trim();
            if (sqlstr.equals("")) continue;
            sqlstr = this.controller.SQLSystemParamHandle(sqlstr);
            where_str = where_str + " or (" + sqlstr + ")";
        }
        if (where_str.equals("1=2")) {
            if (this.tablename.equals(this.table_alias)) {
                return this.tablename;
            }
            return this.tablename + " as " + this.table_alias;
        }
        return "(select * from " + this.tablename + " where " + where_str + ") as " + this.table_alias;
    }

    private String addPageSQLStr(String sql_str) throws YosException {
        if (!this.withoutorderby) {
            String orderby_str = "";
            for (String orderby : this.orderbylist) {
                orderby_str = orderby_str.equals("") ? orderby : orderby_str + "," + orderby;
            }
            String string = orderby_str = orderby_str.equals("") ? this.table_alias + "." + this.uniquecolumnname : orderby_str;
            if (this.pageNumber > 0 && this.pageSize > 0) {
                if (this.dbConnect.getDBProduct().equals("MySQL")) {
                    if (!this.rowcountsql.equals("")) {
                        if (queryCountHour != Calendar.getInstance().get(11)) {
                            queryCountHour = Calendar.getInstance().get(11);
                            queryCountMap.clear();
                        }
                        Row countrow = null;
                        String queryCountKey = this.controller.getAccesstoken() + this.rowcountsql;
                        countrow = this.controller != null && queryCountMap.containsKey(queryCountKey) ? queryCountMap.get(queryCountKey) : this.dbConnect.runSqlQuery(0, this.rowcountsql);
                        long rowscount = countrow.getLong("rowscount");
                        long pagecount = countrow.getBigDecimal("pagecount").longValue();
                        if (rowscount > 10000L && this.controller != null && !queryCountMap.containsKey(queryCountKey)) {
                            queryCountMap.put(queryCountKey, countrow);
                        }
                        sql_str = sql_str.replaceFirst("(?i)select", "select " + rowscount + " as total," + pagecount + " as pageTotal," + this.pageNumber + " as pageNumber," + this.pageSize + " as pageSize,");
                        sql_str = sql_str + " order by " + orderby_str + " limit " + (this.pageNumber - 1) * this.pageSize + "," + this.pageSize;
                    } else {
                        sql_str = sql_str.replaceFirst("(?i)select", "select SQL_CALC_FOUND_ROWS " + this.pageNumber + " as pageNumber," + this.pageSize + " as pageSize,");
                        sql_str = sql_str + " order by " + orderby_str + " limit " + (this.pageNumber - 1) * this.pageSize + "," + this.pageSize;
                    }
                } else {
                    sql_str = sql_str.replaceFirst("(?i)select", "with p2dbconnectstring as (select ROW_NUMBER()over(order by " + orderby_str + " )rowindex,");
                    sql_str = sql_str + " )select * from p2dbconnectstring t1 inner join (select count(0)total,CEILING(count(0)/(" + this.pageSize + "*1.0)) pageTotal from p2dbconnectstring) t2 on 1=1 where rowindex>(" + this.pageNumber + "-1)*" + this.pageSize + " and rowindex<=" + this.pageNumber + "*" + this.pageSize;
                }
            } else if (!this.isgroupby) {
                sql_str = sql_str + " order by " + orderby_str;
            }
        }
        return sql_str;
    }

    public Rows query() throws YosException {
        Rows rows = this.dbConnect.runSqlQuery(this.getSQL());
        if (this.controller != null && this.pageSize > 0 && this.pageNumber > 0) {
            if (day != (day = Calendar.getInstance().get(5))) {
                QuerySQLMap.clear();
            }
            String uuid = UUID.randomUUID().toString();
            String listqueryid = Encryption.Encode_MD5(uuid + "-" + Calendar.getInstance().getTimeInMillis());
            QuerySQLMap.put(listqueryid, this);
            rows.listqueryid = listqueryid;
        }
        this.temporaryTableClean();
        return rows;
    }

    public Rows query(int rowindex) throws YosException {
        Rows rows = new Rows();
        if (this.controller != null) {
            this.pageSize = 1;
            this.pageNumber = rowindex;
            rows = this.query();
            if (rows.isNotEmpty()) {
                rows.get(0).put("rowindex", rowindex);
            }
        }
        this.temporaryTableClean();
        return rows;
    }

    public static void cleanDataLimitRowsMapPool(String accesstoken) throws YosException {
        tokendatalimitRowsMap.remove(accesstoken);
    }

    private String conditionHander(String condition) {
        condition = condition.replaceAll("(?<![.:])\\s*([-+=><()])\\s*(?![.])", " $1 ");
        return " " + condition + " ";
    }

    private QuerySQL setWithOutOrderBy() {
        this.withoutorderby = true;
        return this;
    }

    public QuerySQL clone() throws CloneNotSupportedException {
        return (QuerySQL)super.clone();
    }

    private void temporaryTableClean() {
        try {
            for (String t : this.temporaryTable) {
                this.dbConnect.runSqlUpdate("DROP TABLE " + t + ";");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public QuerySQL setWhere(String key, Object[] value) {
        if (value.length <= 4000) {
            return (QuerySQL)super.setWhere(key, value);
        }
        String temporaryTableName = key.replace(".", "") + Calendar.getInstance().getTimeInMillis();
        this.temporaryTable.add(temporaryTableName);
        try {
            ArrayList<String> sqlist = new ArrayList<String>();
            if (value[0] instanceof Short || value[0] instanceof Integer || value[0] instanceof Long) {
                sqlist.add("create table " + temporaryTableName + "(value BIGINT) ENGINE=MEMORY;");
            } else {
                sqlist.add("create table " + temporaryTableName + "(value varchar(200)) ENGINE=MEMORY;");
            }
            StringBuilder sqlBuilder = new StringBuilder();
            int fix = 1000;
            for (int i = 0; i < value.length; ++i) {
                if (i % fix == 0) {
                    sqlBuilder.append("insert into ").append(temporaryTableName).append("(value) values ");
                }
                sqlBuilder.append("('").append(value[i].toString()).append("'),");
                if ((i + 1) % fix != 0 && i + 1 != value.length) continue;
                sqlist.add(sqlBuilder.substring(0, sqlBuilder.lastIndexOf(",")));
                sqlBuilder = new StringBuilder();
            }
            this.dbConnect.runSqlUpdate(sqlist);
            this.addJoinTable(BaseClass.JOINTYPE.inner, temporaryTableName, temporaryTableName, key + "=" + temporaryTableName + ".value");
        }
        catch (Exception e) {
            return (QuerySQL)super.setWhere(key, value);
        }
        return this;
    }

    public static void main(String[] args) throws YosException {
    }
}

