/*
 * Decompiled with CFR 0.152.
 */
package common.data;

import com.alibaba.fastjson.JSONArray;
import common.BaseClass;
import common.Controller;
import common.YosException;
import common.data.db.DBConnect;
import java.util.ArrayList;
import java.util.HashMap;

public class BaseSQL<T>
extends BaseClass {
    protected String tablename;
    protected String table_alias;
    protected ArrayList<String> wherelist = new ArrayList();
    public String uniquecolumnname;
    protected Controller controller = null;
    protected HashMap<String, ArrayList<String>> tableColumnNames = new HashMap();
    private HashMap<String, Object> parametermap = new HashMap();
    private HashMap<String, String[]> parametermap_array = new HashMap();

    protected BaseSQL(Controller controller, String tablename) throws YosException {
        this.tablename = tablename;
        this.table_alias = tablename;
        this.uniquecolumnname = this.getuniquecolumnname(tablename);
        this.dbConnect = controller.dbConnect;
        this.controller = controller;
        this.tableColumnNames.put(this.tablename, this.getTableColumnNames(this.tablename));
    }

    protected BaseSQL(DBConnect dbConnect, String tablename) throws YosException {
        this.tablename = tablename;
        this.table_alias = tablename;
        this.uniquecolumnname = this.getuniquecolumnname(tablename);
        this.dbConnect = dbConnect;
        this.tableColumnNames.put(this.tablename, this.getTableColumnNames(this.tablename));
    }

    public T setSiteid(String siteid) throws YosException {
        this.wherelist.add(this.table_alias + ".siteid ='" + siteid + "'");
        return (T)this;
    }

    public T setUniqueid(long uniqueid) throws YosException {
        this.wherelist.add(this.table_alias + "." + this.uniquecolumnname + "=" + uniqueid);
        return (T)this;
    }

    public T setWhere(String key, Object value) {
        if (value instanceof ArrayList) {
            ArrayList list = (ArrayList)value;
            Object[] values = new String[list.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = list.get(i).toString();
            }
            this.setWhere(key, values);
        } else if (value instanceof JSONArray) {
            JSONArray Objectarray = (JSONArray)value;
            Object[] values = new Object[Objectarray.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = Objectarray.get(i);
            }
            this.setWhere(key, values);
        } else if (value.getClass().isArray()) {
            Object[] Objectarray = (Object[])value;
            Object[] values = new String[Objectarray.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = Objectarray[i].toString();
            }
            this.setWhere(key, values);
        } else if (value instanceof Boolean) {
            this.setWhere(key, (Boolean)value != false ? 1 : 0);
        } else if (key.contains(".")) {
            this.wherelist.add(key + "='" + value + "'");
        } else {
            this.wherelist.add(this.table_alias + "." + key + "='" + value + "'");
        }
        return (T)this;
    }

    public T setWhere(String key, Object[] value) {
        String in_str = "";
        if (value.length > 0) {
            for (Object o : value) {
                in_str = in_str.equals("") ? "'" + o + "'" : in_str + ",'" + o + "'";
            }
        } else {
            in_str = "''";
        }
        if (key.contains(".")) {
            this.wherelist.add(key + " in (" + in_str + ")");
        } else {
            this.wherelist.add(this.table_alias + "." + key + " in (" + in_str + ")");
        }
        return (T)this;
    }

    public T setWhere(String where) {
        this.wherelist.add(where);
        return (T)this;
    }

    public T setWhere(Object where) {
        this.wherelist.add(where.toString());
        return (T)this;
    }

    public void addParameter(String key, Object value) {
        if (value instanceof ArrayList) {
            ArrayList list = (ArrayList)value;
            String[] values = new String[list.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = list.get(i).toString();
            }
            this.parametermap_array.put(key, values);
        } else if (value.getClass().isArray()) {
            Object[] Objectarray = (Object[])value;
            String[] values = new String[Objectarray.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = Objectarray[i].toString();
            }
            this.parametermap_array.put(key, values);
        } else {
            this.parametermap.put(key, value);
        }
    }

    protected String parameterDo(String sql_str) {
        String sqlkey;
        for (String key : this.parametermap.keySet()) {
            sqlkey = "$" + key + "$";
            Object value = this.parametermap.get(key);
            if (value == null || "null".equalsIgnoreCase(value.toString())) {
                sql_str = sql_str.replace(sqlkey, "NULL");
                continue;
            }
            sql_str = sql_str.replace(sqlkey, "'" + value + "'");
        }
        for (String key : this.parametermap_array.keySet()) {
            sqlkey = "$" + key + "$";
            String[] values = this.parametermap_array.get(key);
            if (values == null || values.length == 0) {
                sql_str = sql_str.replace(sqlkey, "('')");
                continue;
            }
            StringBuilder instr = new StringBuilder();
            for (String value : values) {
                if (instr.toString().equals("")) {
                    if (String.valueOf(value).equalsIgnoreCase("null")) {
                        instr = new StringBuilder("NULL");
                        continue;
                    }
                    instr = new StringBuilder("'" + value + "'");
                    continue;
                }
                if (String.valueOf(value).equalsIgnoreCase("null")) {
                    instr.append(",NULL");
                    continue;
                }
                instr.append(",'").append(value).append("'");
            }
            sql_str = sql_str.replace(sqlkey, "(" + instr + ")");
        }
        return sql_str;
    }
}

