package swing.yos.login;

import common.data.QuerySQL;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import swing.controls.*;
import swing.yos.login.listener.getSelectRowButton;
import swing.yos.login.listener.usertableListener;

public class login extends YFrame {

    public static void main(String[] args) {
        login login = new login();
        login.setVisible(true);
    }

    public YPanel loginpanel;
    public YComboBox user_ComboBox;
    public YButton login_button;
    public YPasswordField passwordField;

    public YTable user_table;

    @Override
    public void init() {

    }

    @Override
    public void view() {
        setBoundsType(BoundsType.small);
        loginpanel = new YPanel();

        YButton button = new YButton("获取选择行");
        button.setListener(this, getSelectRowButton.class);
        loginpanel.add(button);

        user_table = new YTable(this, "账号列表");

        loginpanel.add(user_table);
        this.add(loginpanel);
    }

    @Override
    public void control() {
        user_table.setListener(usertableListener.class);
    }

    @Override
    public void data() {
        try {
            DBConnect dbConnect = new DBConnect();
            QuerySQL querySQL = SQLFactory.createQuerySQL(dbConnect, "sys_users", "userid", "name");
            YTableData tableData = new YTableData(querySQL);
            tableData.setColumn("rowindex", "行号", 10);
            tableData.setColumn("userid", "id", 10);
            tableData.setColumn("name", "姓名", 20);

            user_table.setData(tableData);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
