package swing.controls;

import swing.YUIParameter;

import javax.swing.*;
import javax.swing.event.DocumentListener;
import java.awt.*;
import java.lang.reflect.Constructor;

public class YTextField extends JComponent {
    private JLabel titleLable;
    private JTextField valueTextField;

    public YTextField(String title) {
        super();
        titleLable = new JLabel(title.equals("") ? "" : (title + ":"), JLabel.RIGHT);
        titleLable.setPreferredSize(new Dimension(50, 25));
        titleLable.setOpaque(false);

        valueTextField = new JTextField();
        valueTextField.setPreferredSize(new Dimension(150, 25));

        this.setLayout(new FlowLayout());
        this.add(titleLable);
        this.add(valueTextField);
        if(YUIParameter.isdebug){
            setBorder(BorderFactory.createLineBorder(YUIParameter.bordercolor));
        }
    }

    public YTextField setTitle(String title) {
        titleLable.setText(title.equals("") ? "" : (title + ":"));
        return this;
    }

    public String getTitle() {
        return titleLable.getText();
    }

    public YTextField setTitleFontColor(Color color) {
        titleLable.setForeground(color);
        return this;
    }

    public YTextField setTitleFont(Font font) {
        titleLable.setFont(font);
        return this;
    }


    public YTextField setValue(String value) {
        valueTextField.setText(value);
        return this;
    }

    public String getValue() {
        return valueTextField.getText();
    }


    /**
     * 设置监听
     *
     * @param listener
     */
    public void setListener(Container container, Class listener) {
        try {
            Constructor cla = listener.getDeclaredConstructor(Container.class);
            Object obj = cla.newInstance(container);

            valueTextField.getDocument().addDocumentListener((DocumentListener) obj);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
