package swing.controls;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.YosException;
import swing.YUIParameter;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;

public class YTable extends JComponent {
    public JLabel titleLable;
    public JScrollPane scrollpane;
    public JTable jTable;
    public YTableModel sTableModel;
    public Container container;

    public YPanel deep_tool_panel;
    public JComboBox deep_tool_pageCount;
    public JLabel deep_tool_panel_msg;
    public YButton last_page_button;
    public YButton next_page_button;
    public YTableData yTableData;

    public YTable(Container container, String title) {
        super();
        titleLable = new JLabel(title, JLabel.LEFT);
        titleLable.setPreferredSize(new Dimension(50, 25));
        jTable = new JTable();
        jTable.setRowHeight(25);
        scrollpane = new JScrollPane(jTable);

        this.setLayout(new BorderLayout());
        this.add(titleLable, BorderLayout.NORTH);
        this.add(scrollpane, BorderLayout.CENTER);

        deep_tool_panel = new YPanel();
        deep_tool_pageCount = new JComboBox();
        deep_tool_pageCount.addItem("10条/页");
        deep_tool_pageCount.addItem("20条/页");
        deep_tool_pageCount.addItem("50条/页");
        deep_tool_pageCount.addItem("100条/页");
        deep_tool_pageCount.setActionCommand("pageSizeChange");
        deep_tool_panel.add(deep_tool_pageCount);
        deep_tool_panel_msg = new JLabel();
        deep_tool_panel.add(deep_tool_panel_msg);
        last_page_button = new YButton("上一页");
        last_page_button.setActionCommand("lastPage");
        deep_tool_panel.add(last_page_button);
        next_page_button = new YButton("下一页");
        next_page_button.setActionCommand("nextPage");
        deep_tool_panel.add(next_page_button);
        this.add(deep_tool_panel, BorderLayout.SOUTH);
        this.container = container;
        if (YUIParameter.isdebug) {
            setBorder(BorderFactory.createLineBorder(YUIParameter.bordercolor));
        }
    }

    public void setListener(Class listener) {
        try {
            Constructor cla = listener.getDeclaredConstructor(Container.class, YTable.class);
            Object obj = cla.newInstance(container, this);
            last_page_button.addActionListener((ActionListener) obj);
            next_page_button.addActionListener((ActionListener) obj);
            deep_tool_pageCount.addActionListener((ActionListener) obj);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JSONArray getDataArray(boolean isselected) {
        JSONArray array = new JSONArray();
        for (Object o : yTableData.getDataArray()) {
            System.err.println(o.toString());
            if (!isselected || (isselected && ((JSONObject) o).getBooleanValue("selectflag"))) {
                array.add(o);
            }
        }
        return array;
    }

    public JSONObject getDataObject(int index) {
        return (JSONObject) yTableData.getDataArray().get(index);
    }


    public void setData(YTableData yTableData) throws YosException {
        yTableData.loadData();
        deep_tool_panel_msg.setText("共" + yTableData.getTotalRows() + "条 " + yTableData.getPageNumber() + "/" + yTableData.getTotalPage() + "页");
        this.yTableData = yTableData;
        try {
            Constructor cla = YTableModel.class.getDeclaredConstructor(Container.class, YTable.class, YTableData.class);
            sTableModel = (YTableModel) cla.newInstance(container, this, yTableData);
        } catch (Exception e) {
            e.printStackTrace();
        }
        jTable.setModel(sTableModel);

        int i = 0;
        for (int width : yTableData.getFieldwidth()) {
            jTable.getColumnModel().getColumn(i++).setPreferredWidth(width);
        }
    }

}
