package swing.controls;

import common.data.Row;
import common.data.Rows;
import swing.YUIParameter;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

/**
 * 下拉选项框
 */
public class YComboBox extends JComponent {
    private JLabel titleLable;
    private JComboBox<Object> valueComboBox;

    /**
     * 构造函数
     *
     * @param title 选项框标题
     */
    public YComboBox(String title) {
        super();

        titleLable = new JLabel(title.equals("") ? "" : (title + ":"), JLabel.RIGHT);
        titleLable.setPreferredSize(new Dimension(50, 25));
        titleLable.setOpaque(false);

        valueComboBox = new JComboBox();
        valueComboBox.setPreferredSize(new Dimension(150, 25));
        this.setMaximumSize(new Dimension(220, 38));
        this.setLayout(new FlowLayout());
        this.add(titleLable);
        this.add(valueComboBox);
        if (YUIParameter.isdebug) {
            setBorder(BorderFactory.createLineBorder(YUIParameter.bordercolor));
        }
    }

    /**
     * 选项框标题设置
     *
     * @param title 选项框标题
     * @return
     */
    public YComboBox setTitle(String title) {
        titleLable.setText(title.equals("") ? "" : (title + ":"));
        return this;
    }

    /**
     * 获取选项框标题
     *
     * @return
     */
    public String getTitle() {
        return titleLable.getText();
    }

    /**
     * 设置选项框标题的字体颜色
     *
     * @param color
     * @return
     */
    public YComboBox setTitleFontColor(Color color) {
        titleLable.setForeground(color);
        return this;
    }

    /**
     * 设置选项框标题的字体
     *
     * @param font
     * @return
     */
    public YComboBox setTitleFont(Font font) {
        titleLable.setFont(font);
        return this;
    }


    /**
     * 设置标题提示
     *
     * @param tip
     * @return
     */
    public YComboBox setTitleTip(String tip) {
        titleLable.setToolTipText(tip);
        return this;
    }

    /**
     * 获取标题提示
     *
     * @return
     */
    public String getTitleTip() {
        return titleLable.getToolTipText();
    }

    /**
     * 设置选项框的选择值
     *
     * @param item
     * @return
     */
    public YComboBox setSelectedItem(Object item) {
        valueComboBox.setSelectedItem(item);
        return this;
    }

    /**
     * 获取选项框的选择值
     *
     * @return
     */
    public Object getSelectedItem() {
        return valueComboBox.getSelectedItem();
    }

    /**
     * 添加选项
     *
     * @param items 选项值
     * @return
     */
    public YComboBox addItems(Object... items) {
        for (Object item : items) {
            valueComboBox.addItem(item);
        }
        return this;
    }

    /**
     * 添加选项
     *
     * @param items 选项值
     * @return
     */
    public YComboBox addItems(ArrayList<Object> items) {
        for (Object item : items) {
            valueComboBox.addItem(item);
        }
        return this;
    }

    /**
     * 添加选项
     *
     * @param rows       选择值
     * @param fieldnames 显示值
     * @return
     */
    public YComboBox addItems(Rows rows, String... fieldnames) {
        for (Row row : rows) {
            valueComboBox.addItem(row.setToStringValue(fieldnames));
        }
        return this;
    }

    /**
     * 设置监听
     *
     * @param listener
     */
    public void setListener(Container container, Class listener) {
        try {
            Constructor cla = listener.getDeclaredConstructor(Container.class);
            Object obj = cla.newInstance(container);
            valueComboBox.addActionListener((ActionListener) obj);
            valueComboBox.addItemListener((ItemListener) obj);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
