package service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.ServiceController;
import common.YosException;
import common.data.*;
import common.data.db.DBConnect;

import java.util.ArrayList;

public class DataArchiving extends ServiceController {

    @Override
    public void serviceRun() throws YosException {
        dbConnect.setGroup_concat_max_len(1000000000000000L);
        databaseinit();
        archiveData();
        archiveSiteData();
    }

    private void archiveData() throws YosException {
        Rows rows = dbConnect.runSqlQuery("select table_name,sqlcondition,foreign_table from sys_dataarchiving where issite=0 and isopen=1");
        for (Row row : rows) {
            String table_name = row.getString("table_name");
            String fieldstr = dbConnect.runSqlQuery("SELECT GROUP_CONCAT(COLUMN_NAME) as fieldstr FROM INFORMATION_SCHEMA.`COLUMNS` WHERE TABLE_SCHEMA = '" + dbConnect.getDBName() + "' and TABLE_NAME='" + table_name + "'").get(0).getString("fieldstr");

            String sqlcondition = row.getString("sqlcondition").trim();
            sqlcondition = sqlcondition.equals("") ? " 1=2 " : sqlcondition;
            JSONArray foreign_tables = row.getJSONArray("foreign_table");

            ArrayList<String> sqllist = new ArrayList<>();
            String database = dbConnect.getDBName() + "_archive";

            Row datarow = dbConnect.runSqlQuery("select count(0)as datacount, GROUP_CONCAT(" + getuniquecolumnname(table_name) + ") as dataidsstr from ( select " + getuniquecolumnname(table_name) + " from " + table_name + " where (" + sqlcondition + ") order by " + getuniquecolumnname(table_name) + " limit 1000) as " + table_name).get(0);
            long datacount = datarow.getLong("datacount");
            if (datacount > 0) {
                String dataidsstr = datarow.getString("dataidsstr");
                while (dataidsstr.endsWith(",")) {
                    dataidsstr = dataidsstr.substring(0, dataidsstr.length() - 1);
                }
                String insertSqlBuffer = "insert into " + database + "." + table_name + "(" + fieldstr + ")" +
                        "select " + fieldstr + " from " + table_name + " where " + getuniquecolumnname(table_name) + " in (" + dataidsstr + ")";

                sqllist.add(insertSqlBuffer);
                for (int i = 0; i < foreign_tables.size(); i++) {
                    JSONObject foreign_table = foreign_tables.getJSONObject(i);
                    String foreign_table_name = foreign_table.getString("table_name");
                    String foreign_sqlcondition = foreign_table.getString("sqlcondition").trim();
                    foreign_sqlcondition = foreign_sqlcondition.equals("") ? " 1=2 " : foreign_sqlcondition;
                    String foreign_fieldstr = dbConnect.runSqlQuery("SELECT GROUP_CONCAT(COLUMN_NAME) as fieldstr FROM INFORMATION_SCHEMA.`COLUMNS` WHERE TABLE_SCHEMA = '" + dbConnect.getDBName() + "' and TABLE_NAME='" + foreign_table_name + "'").get(0).getString("fieldstr");
                    Row foreign_datarow = dbConnect.runSqlQuery("select count(0) as datacount,GROUP_CONCAT(distinct " + foreign_table_name + "." + getuniquecolumnname(foreign_table_name) + ") as dataidsstr from " + foreign_table_name + " inner join " + table_name + " on " + foreign_sqlcondition + " where " + table_name + "." + getuniquecolumnname(table_name) + " in (" + dataidsstr + ")").get(0);
                    long foreign_datacount = foreign_datarow.getLong("datacount");
                    if (foreign_datacount > 0) {
                        String foreign_dataidsstr = foreign_datarow.getString("dataidsstr");
                        while (foreign_dataidsstr.endsWith(",")) {
                            foreign_dataidsstr = foreign_dataidsstr.substring(0, foreign_dataidsstr.length() - 1);
                        }
                        String foreign_InsertSqlBuffer = "insert into " + database + "." + foreign_table_name + "(" + foreign_fieldstr + ")" +
                                "select " + foreign_fieldstr + " from " + foreign_table_name + " where " + getuniquecolumnname(foreign_table_name) + " in (" + foreign_dataidsstr + ")";
                        sqllist.add(foreign_InsertSqlBuffer);
                        sqllist.add("delete from " + foreign_table_name + " where " + getuniquecolumnname(foreign_table_name) + " in (" + foreign_dataidsstr + ")");
                    }
                }
                sqllist.add("delete from " + table_name + " where " + getuniquecolumnname(table_name) + " in (" + dataidsstr + ")");
                dbConnect.runSqlUpdate(sqllist);
            }
        }
    }

    private void archiveSiteData() throws YosException {
        ArrayList<String> siteids = dbConnect.runSqlQuery("select siteid from sys_site").toArrayList("siteid");
        Rows rows = dbConnect.runSqlQuery("select table_name,sqlcondition,foreign_table from sys_dataarchiving where issite=1 and isopen=1");
        for (Row row : rows) {
            String table_name = row.getString("table_name");
            String fieldstr = dbConnect.runSqlQuery("SELECT GROUP_CONCAT(COLUMN_NAME) as fieldstr FROM INFORMATION_SCHEMA.`COLUMNS` WHERE TABLE_SCHEMA = '" + dbConnect.getDBName() + "' and TABLE_NAME='" + table_name + "'").get(0).getString("fieldstr");

            String sqlcondition = row.getString("sqlcondition").trim();
            sqlcondition = sqlcondition.equals("") ? " 1=2 " : sqlcondition;
            JSONArray foreign_tables = row.getJSONArray("foreign_table");

            for (String siteid : siteids) {
                ArrayList<String> sqllist = new ArrayList<>();
                String database = dbConnect.getDBName() + "_archive" + "_" + siteid;

                Row datarow = dbConnect.runSqlQuery("select count(0)as datacount, GROUP_CONCAT(" + getuniquecolumnname(table_name) + ") as dataidsstr from ( select " + getuniquecolumnname(table_name) + " from " + table_name + " where siteid='" + siteid + "' and (" + sqlcondition + ") order by " + getuniquecolumnname(table_name) + " limit 1000) as " + table_name).get(0);

                long datacount = datarow.getLong("datacount");
                if (datacount > 0) {
                    String dataidsstr = datarow.getString("dataidsstr");
                    while (dataidsstr.endsWith(",")) {
                        dataidsstr = dataidsstr.substring(0, dataidsstr.length() - 1);
                    }
                    String insertSqlBuffer = "insert into " + database + "." + table_name + "(" + fieldstr + ")" +
                            "select " + fieldstr + " from " + table_name + " where " + getuniquecolumnname(table_name) + " in (" + dataidsstr + ")";

                    sqllist.add(insertSqlBuffer);
                    for (int i = 0; i < foreign_tables.size(); i++) {
                        JSONObject foreign_table = foreign_tables.getJSONObject(i);
                        String foreign_table_name = foreign_table.getString("table_name");
                        String foreign_sqlcondition = foreign_table.getString("sqlcondition").trim();
                        foreign_sqlcondition = foreign_sqlcondition.equals("") ? " 1=2 " : foreign_sqlcondition;
                        String foreign_fieldstr = dbConnect.runSqlQuery("SELECT GROUP_CONCAT(COLUMN_NAME) as fieldstr FROM INFORMATION_SCHEMA.`COLUMNS` WHERE TABLE_SCHEMA = '" + dbConnect.getDBName() + "' and TABLE_NAME='" + foreign_table_name + "'").get(0).getString("fieldstr");
                        Row foreign_datarow = dbConnect.runSqlQuery("select count(0) as datacount,GROUP_CONCAT(distinct " + foreign_table_name + "." + getuniquecolumnname(foreign_table_name) + ") as dataidsstr from " + foreign_table_name + " inner join " + table_name + " on " + foreign_sqlcondition + " where " + table_name + "." + getuniquecolumnname(table_name) + " in (" + dataidsstr + ")").get(0);
                        long foreign_datacount = foreign_datarow.getLong("datacount");
                        if (foreign_datacount > 0) {
                            String foreign_dataidsstr = foreign_datarow.getString("dataidsstr");
                            while (foreign_dataidsstr.endsWith(",")) {
                                foreign_dataidsstr = foreign_dataidsstr.substring(0, foreign_dataidsstr.length() - 1);
                            }
                            String foreign_InsertSqlBuffer = "insert into " + database + "." + foreign_table_name + "(" + foreign_fieldstr + ")" +
                                    "select " + foreign_fieldstr + " from " + foreign_table_name + " where " + getuniquecolumnname(foreign_table_name) + " in (" + foreign_dataidsstr + ")";
                            sqllist.add(foreign_InsertSqlBuffer);
                            sqllist.add("delete from " + foreign_table_name + " where " + getuniquecolumnname(foreign_table_name) + " in (" + foreign_dataidsstr + ")");
                        }
                    }
                    sqllist.add("delete from " + table_name + " where " + getuniquecolumnname(table_name) + " in (" + dataidsstr + ")");
                    dbConnect.runSqlUpdate(sqllist);
                }
            }
        }
    }

    private void databaseinit() throws YosException {
        ArrayList<String> siteids = dbConnect.runSqlQuery("select siteid from sys_site").toArrayList("siteid");
        Rows rows = dbConnect.runSqlQuery("select issite,table_name,foreign_table from sys_dataarchiving where isopen=1");
        for (Row row : rows) {
            String table_name = row.getString("table_name");
            JSONArray foreign_tables = row.getJSONArray("foreign_table");

            ArrayList<String> databaseList = new ArrayList<>();

            if (row.getBoolean("issite")) {
                for (String siteid : siteids) {
                    databaseList.add(dbConnect.getDBName() + "_archive" + "_" + siteid);
                }
            } else {
                databaseList.add(dbConnect.getDBName() + "_archive");
            }

            for (String database : databaseList) {
                createDataBase(database, table_name);
                for (int i = 0; i < foreign_tables.size(); i++) {
                    JSONObject foreign_table = foreign_tables.getJSONObject(i);
                    createDataBase(database, foreign_table.getString("table_name"));
                }
            }
        }
    }

    private void createDataBase(String database, String table_name) throws YosException {
        if (dbConnect.runSqlQuery("SELECT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = '" + database + "'").isEmpty()) {
            //如果不存在归档数据库，则自动创建该数据库，并自动添加至系统数据源中
            dbConnect.runSqlUpdate("CREATE DATABASE `" + database + "` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */");
            InsertSQL insertSQL = SQLFactory.createInsertSQL(dbConnect, "sys_datasource");
            insertSQL.setValue("datakey", database);
            insertSQL.setValue("dbname", database);
            insertSQL.setValue("isdataarchive", 1);
            insertSQL.setValue("driver", "");
            insertSQL.setValue("username", "");
            insertSQL.setValue("password", "");
            insertSQL.setValue("url", "");
            insertSQL.insert();
        }
        ArrayList<String> sqllist = new ArrayList<>();
        if (dbConnect.runSqlQuery("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_schema = '" + database + "' AND table_name = '" + table_name + "'").isEmpty()) {
            //如果表不存在，则创建表
            sqllist.add(dbConnect.runSqlQuery("SHOW CREATE table " + table_name).get(0).getString("Create Table"));
        } else {
            //如果表存在，则更新表
            Rows tablecolrows = dbConnect.runSqlQuery("select * from sys_objectcols where table_name='" + table_name + "'");
            for (Row tablecolrow : tablecolrows) {
                String column_name = tablecolrow.getString("column_name");//字段名称
                String column_type = tablecolrow.getString("column_type");//字段类型
                int numeric_precision = tablecolrow.getInteger("numeric_precision");//长度
                int numeric_scale = tablecolrow.getInteger("numeric_scale");//小数位数
                String type = getColumn_type(column_type, numeric_precision, numeric_scale);

                //判断字段是否已存在
                Rows cr = dbConnect.runSqlQuery("SELECT COLUMN_TYPE FROM INFORMATION_SCHEMA.`COLUMNS` WHERE TABLE_SCHEMA = '" + database + "' and TABLE_NAME='" + table_name + "' and COLUMN_NAME='" + column_name + "'");
                if (cr.isEmpty()) {
                    sqllist.add("alter table " + table_name + " add " + column_name + " " + type + " " + "null" + ";");
                } else if (!cr.get(0).getString("COLUMN_TYPE").equalsIgnoreCase(type)) {
                    sqllist.add("alter table " + table_name + " modify " + column_name + " " + type + " " + "null" + ";");
                }
            }
        }
        if (!sqllist.isEmpty()) {
            new DBConnect(database).runSqlUpdate(sqllist);
        }
    }

    private String getColumn_type(String column_type, int numeric_precision, int numeric_scale) {
        if (column_type.equals("varchar")) {
            return "varchar(" + numeric_precision + ")";
        } else if (column_type.equals("decimal")) {
            return "decimal(" + numeric_precision + "," + numeric_scale + ")";
        } else if (column_type.equals("integer")) {
            return "int";
        } else {
            return column_type;
        }
    }
}
