package objectregister;

import common.YosException;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public class sys_systemapp_formcols_site implements YosObject {

    @Override
    public String table_comment() {
        return "系统应用表单栏位设置站点表";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("sys_systemapp_formcols_siteid", "数据ID");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> list = new ArrayList<>();
        list.add(new VarcharCol("siteid", "站点", 50));
        list.add(new BigIntCol("formcolid", "数据ID"));
        list.add(new VarcharCol("title", "字段标题", 50));
        list.add(new SmallIntCol("required", "是否必填", 0));
        list.add(new SmallIntCol("hidden", "是否隐藏", 0));
        list.add(new IntCol("span", "占用宽度", 1));
        list.add(new IntCol("sequence", "排序号", 1));
        list.add(new VarcharCol("fielddatatype", "数据分类", 50));
        return list;
    }

    @Override
    public void DataInit() throws YosException {

    }
}
