package common.data;

import common.Controller;
import common.YosException;
import common.data.db.DBConnect;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * 递归查询
 */
public class RecursiveQuerySQL extends BaseSQL<RecursiveQuerySQL> {
    private String cache_tableName;
    private String keyfieldname;
    private String linkkeyfieldname;
    private boolean forward = true;
    private boolean includekeydata = true;

    /**
     * @param controller
     * @param tablename        主表
     * @param linkkeyfieldname 关联字段
     * @throws YosException
     */
    protected RecursiveQuerySQL(Controller controller, String tablename, String linkkeyfieldname) throws YosException {
        super(controller, tablename);
        this.cache_tableName = tablename + "_cache";
        this.keyfieldname = this.uniquecolumnname;
        this.linkkeyfieldname = linkkeyfieldname;
        if (this.keyfieldname.equalsIgnoreCase(linkkeyfieldname)) {
            throw new YosException("linkkeyfieldname和keyfieldname字段相同！");
        }
    }

    /**
     * @param dbConnect
     * @param tablename        主表
     * @param linkkeyfieldname 关联字段
     * @throws YosException
     */
    protected RecursiveQuerySQL(DBConnect dbConnect, String tablename, String linkkeyfieldname) throws YosException {
        super(dbConnect, tablename);
        this.cache_tableName = tablename + "_cache";
        this.keyfieldname = this.uniquecolumnname;
        this.linkkeyfieldname = linkkeyfieldname;
        if (this.keyfieldname.equalsIgnoreCase(linkkeyfieldname)) {
            throw new YosException("linkkeyfieldname和keyfieldname字段相同！");
        }
    }

    /**
     * @param controller
     * @param tablename        主表
     * @param keyfieldname     关键字段
     * @param linkkeyfieldname 关联字段
     * @throws YosException
     */
    protected RecursiveQuerySQL(Controller controller, String tablename, String keyfieldname, String linkkeyfieldname) throws YosException {
        super(controller, tablename);
        this.cache_tableName = tablename + "_cache";
        this.keyfieldname = keyfieldname;
        this.linkkeyfieldname = linkkeyfieldname;
        if (this.keyfieldname.equalsIgnoreCase(linkkeyfieldname)) {
            throw new YosException("linkkeyfieldname和keyfieldname字段相同！");
        }
    }

    /**
     * @param dbConnect
     * @param tablename        主表
     * @param keyfieldname     关键字段
     * @param linkkeyfieldname 关联字段
     * @throws YosException
     */
    protected RecursiveQuerySQL(DBConnect dbConnect, String tablename, String keyfieldname, String linkkeyfieldname) throws YosException {
        super(dbConnect, tablename);
        this.cache_tableName = tablename + "_cache";
        this.keyfieldname = keyfieldname;
        this.linkkeyfieldname = linkkeyfieldname;
        if (this.keyfieldname.equalsIgnoreCase(linkkeyfieldname)) {
            throw new YosException("linkkeyfieldname和keyfieldname字段相同！");
        }
    }

    /**
     * 设置起点数据ID
     *
     * @param uniqueid
     * @return
     * @throws YosException
     */
    public RecursiveQuerySQL setUniqueid(long uniqueid) throws YosException {
        wherelist.add(this.table_alias + "." + this.uniquecolumnname + "=" + uniqueid);
        return this;
    }

    /**
     * 设置起点数据ID
     *
     * @param uniqueid
     * @param forward        向前向后
     * @param includekeydata 是否包含关键数据
     * @return
     * @throws YosException
     */
    public RecursiveQuerySQL setUniqueid(long uniqueid, boolean forward, boolean includekeydata) throws YosException {
        setUniqueid(uniqueid);
        this.forward = forward;
        this.includekeydata = includekeydata;
        return this;
    }

    public String getSQL() throws YosException {
        StringBuilder recursiveSQl = new StringBuilder();

        StringBuffer whereBuffer = new StringBuffer();
        for (String where : wherelist) {
            if (whereBuffer.toString().equals("")) {
                whereBuffer.append(" where ").append(parameterDo(where));
            } else {
                whereBuffer.append(" and ").append(parameterDo(where));
            }
        }

        if (this.forward) {
            recursiveSQl.append(" with recursive " + this.cache_tableName + " as ( ");
            recursiveSQl.append(" select " + this.keyfieldname + " from " + this.tablename).append(whereBuffer);
            recursiveSQl.append(" union all ");
            recursiveSQl.append(" select " + this.tablename + "." + this.keyfieldname + " from " + this.tablename + " inner join " + this.cache_tableName + " on " + this.tablename + "." + this.linkkeyfieldname + " = " + this.cache_tableName + "." + this.keyfieldname);
            recursiveSQl.append(" )");
            recursiveSQl.append("select * from " + this.cache_tableName);
            if (!includekeydata) {
                recursiveSQl.append(" where " + this.keyfieldname + " not in (select " + this.keyfieldname + " from " + this.tablename + whereBuffer + ")");
            }
        } else {
            recursiveSQl.append(" with recursive " + this.cache_tableName + " as ( ");
            recursiveSQl.append(" select " + this.linkkeyfieldname + " from " + this.tablename).append(whereBuffer);
            recursiveSQl.append(" union all ");
            recursiveSQl.append(" select " + this.tablename + "." + this.linkkeyfieldname + " from " + this.tablename + " inner join " + this.cache_tableName + " on " + this.tablename + "." + this.linkkeyfieldname + " is not null and " + this.tablename + "." + this.keyfieldname + " = " + this.cache_tableName + "." + this.linkkeyfieldname);
            recursiveSQl.append(" )");
            recursiveSQl.append(" select " + this.linkkeyfieldname + " as " + this.keyfieldname + " from " + this.cache_tableName + " where " + this.linkkeyfieldname + " is not null");
            if (includekeydata) {
                recursiveSQl.append(" union all ");
                recursiveSQl.append(" select " + this.keyfieldname + " from " + this.tablename).append(whereBuffer);
            }
        }
        return recursiveSQl.toString();
    }


    private ArrayList<String> queryfieldnames = new ArrayList<>();

    /**
     * @param fieldnames
     */
    public RecursiveQuerySQL addQueryFields(String... fieldnames) {
        for (String fieldname : fieldnames) {
            fieldname = fieldname.trim();
            if (!fieldname.equals("")) {
                if (fieldname.contains(",")) {
                    addQueryFields(fieldname.split(","));
                } else {
                    queryfieldnames.add(fieldname);
                }
            }
        }
        return this;
    }

    /**
     * @param fieldnames
     */
    public RecursiveQuerySQL addQueryFields(ArrayList<String> fieldnames) {
        return addQueryFields(fieldnames.toArray(new String[]{}));
    }

    /**
     * 执行查询
     *
     * @return
     * @throws YosException
     */
    public Rows query() throws YosException {
        Rows rows = dbConnect.runSqlQuery(getSQL());
        if (queryfieldnames.size() == 0) {
            return rows;
        } else {
            QuerySQL querySQL = SQLFactory.createQuerySQL(this.dbConnect, this.tablename);
            querySQL.addQueryFields(this.keyfieldname);
            querySQL.addQueryFields(this.queryfieldnames);
            querySQL.setWhere(this.keyfieldname, rows.toArrayList(this.keyfieldname));
            return querySQL.query();
        }
    }

}
