package restcontroller.sysmanage.develop.datalog;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import restcontroller.R;

import java.util.LinkedHashSet;

public class datalog extends Controller {
    public datalog(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "数据日志查询", apiversion = R.ID10010401.v1.class)
    public String queryDataLogList() throws YosException {
        /**
         * 过滤条件设置
         */
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("t2.table_comment like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.olddata like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.newdata like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
            if (whereObject.containsKey("dataid") && !"".equals(whereObject.getString("dataid"))) {
                where.append(" and t1.dataid ='").append(whereObject.getString("dataid")).append("'");
            }
            if (whereObject.containsKey("table_name") && !"".equals(whereObject.getString("table_name"))) {
                where.append(" and t1.table_name like'%").append(whereObject.getString("table_name")).append("%'");
            }
        }
        SQLFactory sqlFactory = new SQLFactory(this, "数据修改日志查询", pageSize, pageNumber, pageSorting);
        sqlFactory.addParameter_SQL("where", where);
        Rows rows = dbConnect.runSqlQuery(sqlFactory.getSQL());
        for (Row row : rows) {
            String table_name = row.getString("table_name");

            JSONObject olddataObject = row.getJSONObject("olddata");
            JSONObject newdataObject = row.getJSONObject("newdata");
            row.put("olddata", olddataObject);
            row.put("newdata", newdataObject);

            LinkedHashSet<String> column_nameList = new LinkedHashSet<>();
            column_nameList.addAll(newdataObject.keySet());
            column_nameList.addAll(olddataObject.keySet());

            JSONArray msgArray = new JSONArray();
            for (String column_name : column_nameList) {
                if (column_name.equals("dataid")) {
                    continue;
                }
                String column_title = getTableColumnTitle(table_name, column_name);
                JSONObject object = new JSONObject();
                object.put("column_title", column_title);
                object.put("oldvalue", olddataObject.getOrDefault(column_name, ""));
                object.put("newvalue", newdataObject.getOrDefault(column_name, ""));
                msgArray.add(object);
            }
            row.put("logcontent", msgArray);
        }
        return getSucReturnObject().setData(rows).toString();
    }
}
