package restcontroller.sysmanage.develop.datafunction;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.DataFunction;
import common.YosException;
import common.annotation.API;
import common.annotation.Param;
import common.data.*;
import restcontroller.R;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class datafunction extends Controller {
    public datafunction(JSONObject content) throws YosException {
        super(content);
    }


    @API(title = "系统函数注册查询", apiversion = R.ID10009101.v1.class)
    public String queryFunctionList() throws YosException {
        /**
         * 过滤条件设置
         */
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("t1.functionname like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.type like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.remarks like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.sqlstr like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.classname like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.functionclass like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
            if (whereObject.containsKey("type") && !"".equals(whereObject.getString("type"))) {
                where.append(" and(");
                where.append("t1.type ='").append(whereObject.getString("type")).append("' ");
                where.append(")");
            }
            if (whereObject.containsKey("isused") && !"".equals(whereObject.getString("isused"))) {
                where.append(" and(");
                where.append("t1.isused ='").append(whereObject.getString("isused")).append("' ");
                where.append(")");
            }
        }
        SQLFactory sqlFactory = new SQLFactory(this, "函数列表查询", pageSize, pageNumber, pageSorting);
        sqlFactory.addParameter_SQL("where", where);
        Rows rows = dbConnect.runSqlQuery(sqlFactory.getSQL());

        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_datafunction_params");
        querySQL.setWhere("sys_datafunctionid", rows.toArrayList("sys_datafunctionid"));
        RowsMap paramsRowsMap = querySQL.query().toRowsMap("sys_datafunctionid");
        for (Row row : rows) {
            row.put("params", paramsRowsMap.get(row.getString("sys_datafunctionid")).toJsonArray());
        }
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "系统函数注册", apiversion = R.ID10009201.v1.class)
    public String insertormodifyFunction() throws YosException {
        long sys_datafunctionid = content.getLong("sys_datafunctionid");
        String functionname = content.getString("functionname");
        String type = content.getString("type");
        String datakey = content.getString("datakey");
        boolean queryforpage = content.getBooleanValue("queryforpage");
        String sqlstr = content.getString("sqlstr", true);
        String classname = content.getString("classname");
        String functionclass = content.getString("functionclass");

        HashMap<String, Param> sys_paramMap = new HashMap<>();
        if (!classname.equals("")) {
            try {
                Class<?> clz = Class.forName("function." + classname);
                for (Field field : clz.getDeclaredFields()) {
                    if (field.isAnnotationPresent(Param.class)) {
                        sys_paramMap.put(field.getName(), field.getAnnotation(Param.class));
                    }
                }
            } catch (Exception e) {
                return getErrReturnObject().setErrMsg("无效的执行类" + classname).toString();
            }
        }
        ArrayList<String> params = getSQLParams(sqlstr);

        String remarks = content.getString("remarks");
        if (sys_datafunctionid <= 0 || dbConnect.runSqlQuery("select * from sys_datafunction where sys_datafunctionid=" + sys_datafunctionid).isEmpty()) {
            sys_datafunctionid = createTableID("sys_datafunction");
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_datafunction");
            insertSQL.setValue("sys_datafunctionid", sys_datafunctionid);
            insertSQL.setValue("functionname", functionname);
            insertSQL.setValue("type", type);
            insertSQL.setValue("classname", classname);
            insertSQL.setValue("queryforpage", queryforpage);
            insertSQL.setValue("sqlstr", sqlstr);
            insertSQL.setValue("remarks", remarks);
            insertSQL.setValue("datakey", datakey);
            insertSQL.setValue("functionclass", functionclass);
            insertSQL.setDateValue("createdate");
            insertSQL.insert();

        } else {
            UpdateSQL rowUpdate = SQLFactory.createUpdateSQL(this, "sys_datafunction");
            if (type.equalsIgnoreCase("query")) {
                rowUpdate.setValue("sqlstr", sqlstr);
            }
            rowUpdate.setValue("remarks", remarks);
            rowUpdate.setValue("queryforpage", queryforpage);
            rowUpdate.setValue("datakey", datakey);
            rowUpdate.setValue("classname", classname);
            rowUpdate.setValue("functionclass", functionclass);
            rowUpdate.setWhere("sys_datafunctionid", sys_datafunctionid);
            rowUpdate.update();
        }

        ArrayList<String> ps = new ArrayList<>();
        ArrayList<String> paramSqlList = new ArrayList<>();
        //获取执行函数的参数
        for (String sys_param : sys_paramMap.keySet()) {
            ps.add(sys_param);
            Param param = sys_paramMap.get(sys_param);
            if (dbConnect.runSqlQuery("select *from sys_datafunction_params where sys_datafunctionid=" + sys_datafunctionid + " and param='" + sys_param + "'").isEmpty()) {
                InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_datafunction_params");
                insertSQL.setValue("sys_datafunctionid", sys_datafunctionid);
                insertSQL.setValue("param", sys_param);
                insertSQL.setValue("paramname", param.paramname());
                insertSQL.setValue("remarks", param.remarks());
                insertSQL.setValue("issystem", param.issystem());
                paramSqlList.add(insertSQL.getSQL());
            } else {
                UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_datafunction_params");
                updateSQL.setValue("paramname", param.paramname());
                updateSQL.setValue("issystem", param.issystem());
                updateSQL.setWhere("sys_datafunctionid", sys_datafunctionid).setWhere("param", param).setWhere("ifnull(paramname,'')=''");
                paramSqlList.add(updateSQL.getSQL());
            }
        }
        //获取sql中的参数
        for (String param : params) {
            if (!sys_paramMap.containsKey(param)) {
                ps.add(param);
                if (dbConnect.runSqlQuery("select *from sys_datafunction_params where sys_datafunctionid=" + sys_datafunctionid + " and param='" + param + "'").isEmpty()) {
                    InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_datafunction_params");
                    insertSQL.setValue("sys_datafunctionid", sys_datafunctionid);
                    insertSQL.setValue("param", param);
                    insertSQL.setValue("issystem", false);
                    paramSqlList.add(insertSQL.getSQL());
                }
            }
        }
        /*
        删除多余的参数
         */
        DeleteSQL deleteSQL = SQLFactory.createDeleteSQL(this, "sys_datafunction_params");
        deleteSQL.setWhere("sys_datafunctionid", sys_datafunctionid);
        deleteSQL.setWhere("param not in $params$");
        deleteSQL.addParameter("params", ps);
        paramSqlList.add(deleteSQL.getSQL());

        dbConnect.runSqlUpdate(paramSqlList);
        return getSucReturnObject().toString();
    }

    @API(title = "系统函数参数设置", apiversion = R.ID10025501.v1.class)
    public String modifyFunctionParams() throws YosException {
        long sys_datafunction_paramsid = content.getLong("sys_datafunction_paramsid");
        String paramname = content.getStringValue("paramname");
        String remarks = content.getStringValue("remarks");
        String value = content.getStringValue("value");
        UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_datafunction_params");
        if (dbConnect.runSqlQuery("select *from sys_datafunction_params where issystem=1 and  sys_datafunction_paramsid=" + sys_datafunction_paramsid).isEmpty()) {
            updateSQL.setValue("value", value);
        }
        updateSQL.setValue("paramname", paramname);
        updateSQL.setValue("remarks", remarks);
        updateSQL.setUniqueid(sys_datafunction_paramsid);
        updateSQL.update();
        return getSucReturnObject().toString();
    }

    @API(title = "系统函数删除", apiversion = R.ID10009301.v1.class)
    public String deleteFunction() throws YosException {
        long sys_datafunctionid = content.getLong("sys_datafunctionid");
        Rows rows = dbConnect.runSqlQuery("select * from sys_datafunction where sys_datafunctionid=" + sys_datafunctionid);
        if (rows.isEmpty()) {
            return getErrReturnObject().setErrMsg("系统函数不存在").toString();
        } else if (rows.get(0).getBoolean("isused")) {
            return getErrReturnObject().setErrMsg("系统函数已被使用").toString();
        }
        ArrayList<String> sqlist = new ArrayList<>();
        sqlist.add("delete from sys_datafunction where sys_datafunctionid=" + sys_datafunctionid);
        sqlist.add("delete from sys_datafunction_params where sys_datafunctionid=" + sys_datafunctionid);
        sqlist.add("delete from sys_datafunction_bind where sys_datafunctionid=" + sys_datafunctionid);
        dbConnect.runSqlUpdate(sqlist);
        return getSucReturnObject().toString();
    }

    @API(title = "业务端根据执行函数id查询方案参数列表", apiversion = R.ID20231212111202.v1.class)
    public String queryParam() throws YosException {
        Long sys_datafunctionid = content.getLongValue("sys_datafunctionid");
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_datafunction",
                "sys_datafunctionid", "functionname", "remarks", "createdate", "status").setTableAlias("t1");
        querySQL.addQueryFields("createby", "\'admin\'");
        querySQL.setWhere("t1.sys_datafunctionid", sys_datafunctionid);
        Rows rows = querySQL.query();
        if (rows.isEmpty()) {
            return getSucReturnObject().setData(new Row()).toString();
        }
        Row detail = rows.get(0);
        Rows paramRows = dbConnect.runSqlQuery("SELECT * from sys_datafunction_params WHERE issystem=0 and param!='siteid' and sys_datafunctionid=" + sys_datafunctionid);
        detail.put("param", paramRows);
        return getSucReturnObject().setData(detail).toString();
    }

    @API(title = "业务端根据表ID查询执行函数", apiversion = R.ID20231208134202.v1.class)
    public String list() throws YosException {
        Long ownerid = content.getLongValue("ownerid");
        String ownertable = content.getStringValue("ownertable");
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_datafunction_bind").setTableAlias("t1");
        querySQL.addJoinTable(JOINTYPE.left, "sys_datafunction", "t2", "t2.sys_datafunctionid=t1.sys_datafunctionid"
                , "functionname", "remarks", "isused", "createdate");
        querySQL.setWhere("t1.ownertable", ownertable).setWhere("t1.ownerid", ownerid);
        querySQL.setWhere("t1.sys_datafunctionid in (SELECT sys_datafunctionid from sys_datafunction_params WHERE param='siteid' and value='" + siteid + "')");
        Rows rows = querySQL.query();

        QuerySQL paramsQuery = SQLFactory.createQuerySQL(this, "sys_datafunction_params");
        paramsQuery.setWhere("sys_datafunctionid", rows.toArrayList("sys_datafunctionid"));
        paramsQuery.setWhere("issystem=0 and param!='siteid'");
        RowsMap paramMap = paramsQuery.query().toRowsMap("sys_datafunctionid");

        for (Row detailRow : rows) {
            detailRow.put("param", paramMap.get(detailRow.getString("sys_datafunctionid")));
        }
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "执行函数方案-绑定", apiversion = R.ID20231208134002.v1.class)
    public String insertOrUpdatePlan() throws YosException {
        Long sys_datafunctionid = content.getLongValue("sys_datafunctionid");
        JSONArray items = content.getJSONArray("items");
        ArrayList<String> sqlList = new ArrayList<>();
        for (Object obj : items) {
            JSONObject item = (JSONObject) obj;
            Long ownerid = item.getLongValue("ownerid");
            String ownertable = item.getStringValue("ownertable");
            Rows rows = dbConnect.runSqlQuery("SELECT * from sys_datafunction_bind WHERE ownerid=" + ownerid + " and ownertable='" + ownertable + "'");
            if (rows.isEmpty()) {
                InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_datafunction_bind");
                insertSQL.setUniqueid(createTableID("sys_datafunction_bind"));
                insertSQL.setValue("ownerid", ownerid);
                insertSQL.setValue("ownertable", ownertable);
                insertSQL.setValue("sys_datafunctionid", sys_datafunctionid);
                sqlList.add(insertSQL.getSQL());
            } else {
                UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_datafunction_bind");
                updateSQL.setUniqueid(rows.get(0).getLong("sys_datafunction_bindid"));
                updateSQL.setValue("sys_datafunctionid", sys_datafunctionid);
                sqlList.add(updateSQL.getSQL());
            }
        }
        dbConnect.runSqlUpdate(sqlList);
        return getSucReturnObject().toString();
    }


    @API(title = "函数执行", apiversion = R.ID10009401.v1.class)
    public String execute() throws YosException {
        String functionname = content.getString("functionname");
        Rows rows = dbConnect.runSqlQuery("select * from sys_datafunction where functionname='" + functionname + "'");
        if (rows.isEmpty()) {
            JSONArray array = new JSONArray();
            array.add(new JSONObject());
            return getSucReturnObject().setData(array).toString();
        }

        DataFunction dataFunction = DataFunction.get(this, functionname);
        if (content.containsKey("parameter")) {
            JSONObject parameterObject = content.getJSONObject("parameter");
            Iterator<String> it = parameterObject.keySet().iterator();
            while (it.hasNext()) {
                String parameter = it.next();
                String value = String.valueOf(parameterObject.get(parameter));
                dataFunction.addParameter(parameter, value);
            }
        }
        if (dataFunction.type.equals("query")) {
            return getSucReturnObject().setData(dataFunction.getList()).toString();
        } else if (dataFunction.type.equals("update")) {
            return getSucReturnObject().setData(dataFunction.action()).toString();
        } else {
            return getSucReturnObject().toString();
        }
    }
}
