package restcontroller.sysmanage.develop.apimanage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.annotation.CACHEING;
import common.api.YOSAPI;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.db.SQLiteMemory;
import common.data.db.SQLiteTable;
import common.parameter.parameter;
import restcontroller.R;
import utility.tools.Encryption;

import java.util.Calendar;
import java.util.HashMap;

@API(title = "管理端-开发-API接口监控")
public class ApiMonitor extends Controller {
    public ApiMonitor(JSONObject content) throws YosException {
        super(content);
    }

    /**
     * 获取注解使用情况
     */
    @API(title = "接口信息查询", apiversion = R.ID10004301.v1.class, intervaltime = 2000)
    public String queryApiList() throws YosException {
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("t1.classname like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.title like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t2.method like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t2.title like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t2.apiid ='").append(whereObject.getString("condition")).append("' ");
                where.append(")");
            }
            if (whereObject.containsKey("iscacheing") && !"".equals(whereObject.getString("iscacheing"))) {
                where.append(" and(");
                where.append("t2.iscacheing ='").append(whereObject.getString("iscacheing")).append("' ");
                where.append(")");
            }
            if (whereObject.containsKey("accesstoken") && !"".equals(whereObject.getString("accesstoken"))) {
                where.append(" and(");
                where.append("t2.accesstoken ='").append(whereObject.getString("accesstoken")).append("' ");
                where.append(")");
            }
        }

        Rows methodrows = null;
        if (content.getBooleanValue("simple")) {
            if (content.getBooleanValue("apiwithid")) {
                methodrows = SQLiteMemory.runSqlQuery("select distinct t1.classname,t1.title as classtitle,t1.notes as classnotes,t2.method,t2.title,t2.notes,t2.cacheinglife,t2.iscacheing,t2.iscacheingclean,t2.cleandatas,t2.intervaltime,t2.accesstoken,t2.apiid,t2.apiversion,t2.deprecated from apiclass t1 inner join apimethod t2 on t1.classname=t2.classname where t2.apiid!='' and " + where + " order by t1.classname,t2.method");
            } else {
                methodrows = SQLiteMemory.runSqlQuery("select distinct t1.classname,t1.title as classtitle,t1.notes as classnotes,t2.method,t2.title,t2.notes,t2.cacheinglife,t2.iscacheing,t2.iscacheingclean,t2.cleandatas,t2.intervaltime,t2.accesstoken,t2.apiid,t2.apiversion,t2.deprecated from apiclass t1 inner join apimethod t2 on t1.classname=t2.classname where" + where + " order by t1.classname,t2.method");
            }
        } else {
//            Rows methodrows_count = SQLiteMemory.runSqlQuery(
//                    "select t1.classname,t1.title as classtitle,t1.notes as classnotes,t2.method,t2.title,t2.notes,t2.cacheinglife," +
//                            "t2.iscacheing,t2.iscacheingclean,t2.cleandatas,t2.intervaltime,t2.accesstoken,t2.apiid,t2.apiversion,t2.deprecated," +
//                            "count(t3.requestlogid) as requesttimes,sum(ifnull(t3.iscacheing,0)) as readcachetimes,max(ifnull(t3.runtime,0))as maxruntime,round(avg(ifnull(t3.runtime,0))) avgruntime,ifnull(max(t3.createdate),'') as lastrequesttime,t3.runtime as lastruntime " +
//                            "from apiclass t1 " +
//                            "inner join apimethod t2 on t1.classname=t2.classname " +
//                            "left join apirequestlog t3 on t2.classname=t3.classname and t2.method=t3.method " +
//                            "where" + where + " " +
//                            "group by t1.classname,t1.title,t1.notes,t2.method,t2.title,t2.notes,t2.cacheinglife,t2.iscacheing,t2.iscacheingclean,t2.cleandatas,t2.intervaltime,t2.accesstoken,t2.apiid,t2.apiversion,t2.deprecated");
//            for (Row row : methodrows_count) {
//                SQLiteMemory.runSqlUpdate("update apimethod set requesttimes=" + row.getLong("requesttimes") + ",readcachetimes=" + row.getLong("readcachetimes") + ",lastrequesttime='" + row.getString("lastrequesttime") + "',requesttimelong_last=" + row.getLong("lastruntime") + ",requesttimelong_avg=" + row.getBigDecimal("avgruntime").longValue() + " where  classname='" + row.getString("classname") + "' and method='" + row.getString("method") + "'");
//            }

            Rows methodrows_count = SQLiteMemory.runSqlQuery(
                    "select t1.classname,t2.method," +
                            "round(avg(ifnull(t3.runtime,0))) avgruntime " +
                            "from apiclass t1 " +
                            "inner join apimethod t2 on t1.classname=t2.classname " +
                            "left join apirequestlog t3 on t2.classname=t3.classname and t2.method=t3.method " +
                            "where" + where + " " +
                            "group by t1.classname,t2.method");
            for (Row row : methodrows_count) {
                SQLiteMemory.runSqlUpdate("update apimethod set requesttimelong_avg=" + row.getBigDecimal("avgruntime").longValue() + " where  classname='" + row.getString("classname") + "' and method='" + row.getString("method") + "'");
            }

            pageSorting = pageSorting.equals("''") ? "t1.classname,t2.method" : pageSorting;

            methodrows = SQLiteMemory.runSqlQuery("select t1.classname,t1.title as classtitle,t1.notes as classnotes,t2.method,t2.title,t2.notes,t2.cacheinglife," +
                    "t2.iscacheing,t2.iscacheingclean,t2.cleandatas,t2.intervaltime,t2.accesstoken,t2.apiid,t2.apiversion,t2.deprecated,t2.requesttimes,t2.lastrequesttime,t2.requesttimelong_last,t2.requesttimelong_avg from apiclass t1 " +
                    "inner join apimethod t2 on t1.classname=t2.classname where" + where + " order by " + pageSorting + " LIMIT " + pageSize + " OFFSET " + pageSize * (pageNumber - 1));

            methodrows.totalPage = new Double(Math.ceil((double) methodrows_count.size() / (double) pageSize)).longValue();//总页数
            methodrows.totalRows = methodrows_count.size();//总行数
            for (Row methodrow : methodrows) {
                JSONObject requestmsg = new JSONObject(true);
                requestmsg.put("requesttimes", methodrow.getLong("requesttimes"));//请求次数
                requestmsg.put("readcachetimes", methodrow.getLong("readcachetimes"));//缓存读取次数
                requestmsg.put("requesttimelong_last", methodrow.getLong("requesttimelong_last"));//最新请求时长
                requestmsg.put("requesttimelong_avg", methodrow.getLong("requesttimelong_avg"));//请求平均时长
                requestmsg.put("lastrequesttime", methodrow.getString("lastrequesttime"));//最新请求时间
                methodrow.put("requestmsg", requestmsg);
                methodrow.put("cleandatas", JSON.parseArray(methodrow.getString("cleandatas")));

                Rows apidocrows = dbConnect.runSqlQuery("select requestjson,requestnotes,responsejson,responsenotes from sys_apidoc where apiid='" + methodrow.getString("apiid") + "' and apiversion='" + methodrow.getString("apiversion") + "'");
                if (apidocrows.isEmpty()) {
                    JSONObject requestjsonObject = new JSONObject();
                    requestjsonObject.put("accesstoken", Encryption.Encode_MD5(String.valueOf(Calendar.getInstance().getTimeInMillis())));
                    requestjsonObject.put("id", methodrow.getString("apiid"));
                    requestjsonObject.put("content", new JSONObject());

                    methodrow.put("requestjson", requestjsonObject);
                    methodrow.put("responsejson", new JSONObject());
                    methodrow.put("requestnotes", "");
                    methodrow.put("responsenotes", "");
                } else {
                    methodrow.put("requestjson", apidocrows.get(0).getJSONObject("requestjson"));
                    methodrow.put("responsejson", apidocrows.get(0).getJSONObject("responsejson"));
                    methodrow.put("requestnotes", apidocrows.get(0).getString("requestnotes"));
                    methodrow.put("responsenotes", apidocrows.get(0).getString("responsenotes"));
                }
            }
        }

        Rows approws = dbConnect.runSqlQuery("select t1.apiid,t1.apiversion,t2.systemappname from sys_apiapps t1 inner join sys_systemapp t2 on t1.systemappid=t2.systemappid");
        RowsMap appidrowsMap = approws.toRowsMap("apiid");

        HashMap<String, String> codermap = getOptionType("coder");
        for (Row row : methodrows) {
            row.put("apps", new JSONArray());
            String apiid = row.getString("apiid");
            String apiversion = row.getString("apiversion");

            if (appidrowsMap.containsKey(apiid)) {
                RowsMap apiversionMap = appidrowsMap.get(apiid).toRowsMap("apiversion");
                if (apiversionMap.containsKey(apiversion)) {
                    row.put("apps", apiversionMap.get(apiversion).toJsonArray("systemappname"));
                }
            }
            if (apiid != null && !apiid.equals("")) {
                row.put("coder", codermap.getOrDefault(apiid.substring(apiid.length() - 2), ""));
                row.put("intervaltime_active", YOSAPI.getApi(Long.parseLong(apiid), Integer.parseInt(apiversion)).getApiIntervaltime());
            } else {
                row.put("coder", "");
                row.put("intervaltime_active", "");
            }
        }
        return getSucReturnObject().setData(methodrows).toString();
    }

    /**
     * 查询接口请求日志
     *
     * @return
     * @throws YosException
     */
    @API(title = "接口请求日志查询", apiversion = R.ID10004401.v1.class)
    public String queryApiRequestLog() throws YosException {
        String classname = content.getString("classname");
        classname = classname.replace("restcontroller.", "");
        String method = content.getString("method");

        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("request like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or usermsg like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
            if (whereObject.getBooleanValue("withoutcacheing")) {
                where.append(" and ifnull(iscacheing,0) = 0");
            }
        }

        SQLiteTable sqLiteTable = SQLiteTable.getTable("apirequestlog");
        if (!sqLiteTable.dosNotExist()) {
            Rows rows = SQLiteMemory.runSqlQuery("select requestlogid,createdate,request,usermsg,iscacheing from apirequestlog where classname ='" + classname + "' and method ='" + method + "' and " + where + " order by createdate desc LIMIT " + pageSize + " OFFSET " + pageSize * (pageNumber - 1));
            for (Row row : rows) {
                row.put("request", JSONObject.parseObject(row.getString("request")));
                row.put("usermsg", JSONObject.parseObject(row.getString("usermsg")));
            }
            Rows rowscount = SQLiteMemory.runSqlQuery("select count(0) as count from apirequestlog where classname='" + classname + "' and method='" + method + "' and " + where);

            rows.totalPage = new Double(Math.ceil((double) rowscount.get(0).getLong("count") / (double) pageSize)).longValue();//总页数
            rows.totalRows = rowscount.get(0).getLong("count");//总行数
            return getSucReturnObject().setData(rows).toString();
        }
        return getSucReturnObject().setData(new Rows()).toString();
    }

    /**
     * 查询接口请求日志
     *
     * @return
     * @throws YosException
     */
    @API(title = "接口请求SQL日志查询", apiversion = R.ID10004501.v1.class)
    public String queryApiRequestSQLLog() throws YosException {
        String requestlogid = content.getString("requestlogid");
        SQLiteTable sqLiteTable = SQLiteTable.getTable("apirequestsqllog");
        if (!sqLiteTable.dosNotExist()) {
            Rows rows = SQLiteMemory.runSqlQuery("select sql,runtime,success,errmsg,numofaffectedrows,classname,method from apirequestsqllog where requestlogid='" + requestlogid + "' order by createtimeinmillis");
            return getSucReturnObject().setData(rows).toString();
        }
        return getSucReturnObject().setData(new Rows()).toString();
    }
}
