package beans.report;

import common.Controller;
import common.YosException;
import common.data.QuerySQL;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;

import java.util.ArrayList;
import java.util.HashMap;

public class Report {

    /**
     * 查询报表、打印的浏览次数
     *
     * @param controller
     * @param sys_reportid 报表ID
     * @param dataid       打印数据ID，报表为0
     * @return
     * @throws YosException
     */
    public static int getViewCount(Controller controller, long sys_reportid, long dataid) throws YosException {
        ArrayList<Long> list = new ArrayList<>();
        list.add(dataid);
        return getViewCount(controller, sys_reportid, list).getOrDefault(dataid, 0);
    }

    /**
     * 查询报表、打印的浏览次数
     *
     * @param controller
     * @param sys_reportid 报表ID
     * @param dataids      打印数据ID，报表为0
     * @return
     * @throws YosException
     */
    public static HashMap<Long, Integer> getViewCount(Controller controller, long sys_reportid, ArrayList<Long> dataids) throws YosException {
        QuerySQL querySQL = SQLFactory.createQuerySQL(controller, "sys_report_session", "dataid");
        querySQL.addQueryFields("count", "count(0)");
        querySQL.setWhere("sys_reportid", sys_reportid);
        querySQL.setWhere("dataid", dataids);
        querySQL.addGroupBy("dataid");
        Rows rows = querySQL.query();
        HashMap<Long, Integer> map = new HashMap<>();
        for (Row row : rows) {
            map.put(row.getLong("dataid"), row.getInteger("count"));
        }
        return map;
    }

    /**
     * 查询我的报表、打印的浏览次数
     *
     * @param controller
     * @param sys_reportid 报表ID
     * @param dataid       打印数据ID，报表为0
     * @return
     * @throws YosException
     */
    public static int getMyViewCount(Controller controller, long sys_reportid, long dataid) throws YosException {
        ArrayList<Long> list = new ArrayList<>();
        list.add(dataid);
        return getMyViewCount(controller, sys_reportid, list).getOrDefault(dataid, 0);
    }

    /**
     * 查询我的报表、打印的浏览次数
     *
     * @param controller
     * @param sys_reportid 报表ID
     * @param dataids      打印数据ID，报表为0
     * @return
     * @throws YosException
     */
    public static HashMap<Long, Integer> getMyViewCount(Controller controller, long sys_reportid, ArrayList<Long> dataids) throws YosException {
        QuerySQL querySQL = SQLFactory.createQuerySQL(controller, "sys_report_session", "dataid");
        querySQL.addQueryFields("count", "count(0)");
        querySQL.setWhere("sys_reportid", sys_reportid);
        querySQL.setWhere("dataid", dataids);
        querySQL.setWhere("userid", controller.userid);
        querySQL.addGroupBy("dataid");
        Rows rows = querySQL.query();
        HashMap<Long, Integer> map = new HashMap<>();
        for (Row row : rows) {
            map.put(row.getLong("dataid"), row.getInteger("count"));
        }
        return map;
    }

}
