package utility.wechat.work;

import common.YosException;
import common.data.Row;
import common.data.Rows;
import common.data.db.DBConnect;

import java.util.HashMap;

public class Parameter {

    /**
     * 消息类型
     *
     * @author Administrator
     */
    public static class MsgType {
        public static String text = "text";
        public static String event = "event";
        public static String image = "image";
        public static String voice = "voice";
        public static String video = "video";
        public static String shortvideo = "shortvideo";
        public static String location = "location";
    }

    public static class EventType {
        public static String subscribe = "subscribe";// 成员关注/取消关注
        public static String LOCATION = "LOCATION";// 上报地理位置事件
        public static String CLICK = "click";// 点击菜单拉取消息的事件推
        public static String VIEW = "VIEW";// 点击菜单跳转链接的事件推
        public static String scancode_push = "scancode_push";// 扫码推事件的事件推
        public static String scancode_waitmsg = "scancode_waitmsg";// 扫码推事件且弹出“消息接收中”提示框的事件推
        public static String pic_sysphoto = "pic_sysphoto";// 弹出系统拍照发图的事件推
        public static String pic_photo_or_album = "pic_photo_or_album";// 弹出拍照或,相册发图的事件推
        public static String pic_weixin = "pic_weixin";// 弹出微信相册发图器的事件推
        public static String location_select = "location_select";// 弹出地理位置选择器的事件推
        public static String enter_agent = "enter_agent";// 成员进入应用的事件推
        public static String batch_job_result = "batch_job_result";// 异步任务完成事件推
    }

    private static HashMap<String, Row> parameterMap = new HashMap<>();

    public static Row getWorkParameter(String systemclient) throws YosException {
        if (!parameterMap.containsKey(systemclient)) {
            Rows rows = new DBConnect().runSqlQuery("select * from sys_wechatapp where systemclient='" + systemclient + "'");
            if (rows.size() == 1) {
                parameterMap.put(systemclient, rows.get(0));
            } else {
                throw new YosException("找不到对应的微信应用设置");
            }
        }
        return parameterMap.getOrDefault(systemclient, new Row());
    }
}
