package utility.kujiale;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import utility.tools.Encryption;
import utility.tools.WebRequest;

import java.util.ArrayList;

public class kujiale {
    private String appKey="";
    private String appSecret="";


    public kujiale(String appKey, String appSecret){
        this.appKey=appKey;
        this.appSecret=appSecret;
    }

    /**
     * 获取用户列表
     * @param start
     * @param num
     */
    public  void getUserList(int start,int num) {
        final long timestamp = System.currentTimeMillis();
        // 签名生成的两种方式之一，在有appuid入参的情况下，需要将appuid也加入计算。
        Encryption encryption = new Encryption();
        final String sign = encryption.Encode_MD5(this.appSecret + this.appKey + timestamp);
        WebRequest webRequest = new WebRequest();
        String a = webRequest.doGet("https://openapi.kujiale.com/v2/user?appkey=" + this.appKey + "&timestamp=" + timestamp + "&sign=" + sign + "&start="+start+"&num="+num);
        System.out.println(a);
    }

    /**
     * 获取方案分类列表
     * @param start
     * @param num
     * @param appuid
     */
    public void getClassList(int start,int num,String appuid) {
        final long timestamp = System.currentTimeMillis();
        // 签名生成的两种方式之一，在有appuid入参的情况下，需要将appuid也加入计算。
        Encryption encryption = new Encryption();
        final String sign = encryption.Encode_MD5(appSecret + appKey +appuid+ timestamp);
        WebRequest webRequest = new WebRequest();
        String a = webRequest.doGet("https://openapi.kujiale.com/v2/design/tag/list?appkey=" + this.appKey + "&timestamp=" + timestamp + "&sign=" + sign + "&start="+start+"&num="+num+"&appuid="+appuid);
        System.out.println(a);
    }

    /**
     * 获取用户方案
     * @param start
     * @param num
     * @param appuid
     */
    public void getDesignList(int start,int num,String appuid) {
        final long timestamp = System.currentTimeMillis();
        // 签名生成的两种方式之一，在有appuid入参的情况下，需要将appuid也加入计算。
        Encryption encryption = new Encryption();
        final String sign = encryption.Encode_MD5(appSecret + appKey +appuid+ timestamp);
        WebRequest webRequest = new WebRequest();
        String a = webRequest.doGet("https://openapi.kujiale.com/v2/design/list?appkey=" + this.appKey + "&timestamp=" + timestamp + "&sign=" + sign + "&start="+start+"&num="+num+"&appuid="+appuid);
        System.out.println(a);
    }

    /**
     * 获取用户方案渲染图
     * @param start
     * @param num
     * @param design_id
     */
    public void getDesignRender(int start,int num,String design_id) {
        final long timestamp = System.currentTimeMillis();
        // 签名生成的两种方式之一，在有appuid入参的情况下，需要将appuid也加入计算。
        Encryption encryption = new Encryption();
        final String sign = encryption.Encode_MD5(appSecret + appKey + timestamp);
        WebRequest webRequest = new WebRequest();
        String a = webRequest.doGet("https://openapi.kujiale.com/v2/renderpic/list?appkey=" + this.appKey + "&timestamp=" + timestamp + "&sign=" + sign + "&start="+start+"&num="+num+"&design_id="+design_id);
        System.out.println(a);
    }

    /**
     * 获取用户方案漫游
     * @param appuid
     * @param design_id
     */
//    public void getDesignRoam(String appuid,String design_id) {
//        final long timestamp = System.currentTimeMillis();
//        // 签名生成的两种方式之一，在有appuid入参的情况下，需要将appuid也加入计算。
//        Encryption encryption = new Encryption();
//        final String sign = encryption.Encode_MD5(appSecret + appKey+appuid + timestamp);
//        WebRequest webRequest = new WebRequest();
//        String a = webRequest.doGet("https://openapi.kujiale.com/v2/pano/roam/list?appkey=" + this.appKey + "&timestamp=" + timestamp + "&sign=" + sign+"&appuid="+appuid +"&design_id="+design_id);
//    }
    /**
     * 创建全屋漫游链接
     * @param picIds
     */
    public void createDesignRoam(ArrayList<String>picIds) {
        final long timestamp = System.currentTimeMillis();
        // 签名生成的两种方式之一，在有appuid入参的情况下，需要将appuid也加入计算。
        Encryption encryption = new Encryption();
        final String sign = encryption.Encode_MD5(appSecret + appKey + timestamp);
        WebRequest webRequest = new WebRequest();

        JSONObject requestObject=new JSONObject();
        requestObject.put("override",false);
        JSONArray picIdsArray=new JSONArray();
        picIdsArray.addAll(picIds);
        requestObject.put("picIds",picIdsArray);
        System.out.println(requestObject.toJSONString());
        String a = webRequest.doPostKuJiaLe(requestObject.toJSONString(),"https://openapi.kujiale.com/v2/renderpic/pano?appkey=" + this.appKey + "&timestamp=" + timestamp + "&sign=" + sign);
        System.out.println(a);
    }

    public static void main(String args[]) {
        final String appKey = "E4cUIMIBeQ";
        final String appSecret = "5uumTJeJLQrp9r6HvZggG1muelv5OqnT";
//        new kujiale(appKey,appSecret).getUserList(0,10000);
//        new kujiale(appKey,appSecret).getClassList(0,10,"102415");
//        new kujiale(appKey,appSecret).getDesignList(0,10,"102415");
//        new kujiale(appKey,appSecret).getDesignRender(0,10,"3FO49BG1RTW7");
//        new kujiale(appKey,appSecret).getDesignRoam("102415","3FO49BG1RTW7");
        ArrayList<String>list =new ArrayList<>();
        list.add("3FNYSU9NDR0R");
        list.add("3FNYSUBGODHE");
        list.add("3FNYYJ5N2WH1");
        list.add("3FNYYJ63OGMH");
        new kujiale(appKey,appSecret).createDesignRoam(list);

    }

}
