package utility.bankdocking;

import com.alibaba.fastjson.JSONArray;
import common.YosException;
import utility.bankdocking.abc.ABC;
import utility.bankdocking.boc.BOC;
import utility.bankdocking.boc.domain.TradeInfoResponseDetail;
import utility.bankdocking.ccb.BBC;
import utility.bankdocking.zjrc.domain.PageInfo;
import utility.bankdocking.zjrc.HttpConnService03;

import java.util.List;

public class bankdocking {
    /**
     * 建行流水
     *
     * @param accno     收款账号
     * @param startdate 开始日期20220301
     * @param enddate   结束日期20220315
     * @return
     */
    public static JSONArray getCCBBills(String siteid, String accno, int startdate, int enddate) throws YosException {
        return new BBC().query(siteid, startdate, enddate);
    }

    /**
     * 农行流水
     *
     * @param starttime 开始时间戳，取自最新的一条农行流水的时间戳，如没有流水，则传"0"
     * @return
     */
    public static JSONArray getABCBills(String siteid, String starttime) throws YosException {
        return new ABC().query(siteid, starttime);
    }

    /**
     * 中国银行流水
     *
     * @param begnum 本次查询的交易起始位置
     * @return
     */
    public static List<TradeInfoResponseDetail> getBOCBills(String siteid, int begnum) throws YosException {
        return new BOC().query(siteid, begnum);
    }


    /**
     * 浙江农信银行贷款申请查询
     *
     * @param fsonum 订单号
     * @param IDTYPE 订单号
     * @param ID     订单号
     * @return
     */
    public static PageInfo getJZRCBills(String fsonum, String IDTYPE, String ID) {
        return HttpConnService03.LoanApplication(IDTYPE, ID, fsonum, "5", "1");
    }
}
