package restcontroller.sysmanage.develop.userauthforweb;

import beans.accountpay.AccountPay;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.annotation.CACHEING;
import common.annotation.CACHEING_CLEAN;
import common.annotation.cm;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.SQLFactory;
import common.parameter.parameter;
import restcontroller.R;
import utility.zentao.zentao;

import java.util.ArrayList;
import java.util.HashMap;

@API(title = "管理端-开发-权限管理-权限查询")
public class userauth extends Controller {
    public userauth(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "web端获取当前登陆角色授权信息", apiversion = R.ID10017001.v1.class)
    @CACHEING
    public String query_userauth() throws YosException {
        String showplace = "1";
        if (content.containsKey("place")) {
            showplace = content.getString("place");//1:工作台；2：快捷区；3：设置区
        }
        if (dbConnect.runSqlQuery("select * from sys_users where sysadministrator=1 and userid=" + userid).isEmpty()) {
            /*
             * 获取角色系统授权
             */
            SQLFactory systemsql = new SQLFactory(this, "获取角色系统授权");
            systemsql.addParameter("userid", userid);
            systemsql.addParameter("siteid", siteid);
            systemsql.addParameter("systemclient", systemclient);
            systemsql.addParameter("showplace", showplace);
            Rows systemRows = dbConnect.runSqlQuery(systemsql);
            for (Row row : systemRows) {
                row.put("iconurl", getSystemIconUrl(row.getLong("systemid"), "icon"));
                row.put("iconurl_mainnav", getSystemIconUrl(row.getLong("systemid"), "mainnavicon"));
            }
            /*
             * 获取角色模块授权
             */
            SQLFactory modulesql = new SQLFactory(this, "获取角色模块授权");
            modulesql.addParameter("userid", userid);
            modulesql.addParameter("siteid", siteid);
            modulesql.addParameter("systemclient", systemclient);
            modulesql.addParameter("showplace", showplace);
            Rows moduleRows = dbConnect.runSqlQuery(modulesql);
            for (Row row : moduleRows) {
                row.put("iconurl", getSystemModuleIconUrl(row.getLong("systemmoduleid"), "icon"));
                row.put("iconurl_mainnav", getSystemModuleIconUrl(row.getLong("systemmoduleid"), "mainnavicon"));
            }
            RowsMap moduleRowsMap = moduleRows.toRowsMap("systemid");

            /*
             * 获取角色应用授权
             */
            SQLFactory appsql = new SQLFactory(this, "获取角色应用授权");
            appsql.addParameter("userid", userid);
            appsql.addParameter("siteid", siteid);
            appsql.addParameter("systemclient", systemclient);
            appsql.addParameter("showplace", showplace);
            Rows appRows = dbConnect.runSqlQuery(appsql);
            RowsMap appRowsMap = appRows.toRowsMap("systemmoduleid");

            /*
             * 获取角色功能授权
             */
            SQLFactory optionsql = new SQLFactory(this, "获取角色功能授权");
            optionsql.addParameter("userid", userid);
            optionsql.addParameter("siteid", siteid);
            Rows OptionRows = dbConnect.runSqlQuery(optionsql);
            RowsMap optionRowsMap = OptionRows.toRowsMap("systemappid");
            /*
             * 获取角色限制栏位
             */
            SQLFactory hiddenfieldsql = new SQLFactory(this, "获取角色限制栏位");
            hiddenfieldsql.addParameter("userid", userid);
            hiddenfieldsql.addParameter("siteid", siteid);
            RowsMap hiddenfieldRowsMap = dbConnect.runSqlQuery(hiddenfieldsql).toRowsMap("systemappid");

            /*
             * 获取应用表单配置
             */
            SQLFactory formsql = new SQLFactory(this, "获取角色应用表单配置");
            formsql.addParameter_in("systemappid", appRows.toArrayList("systemappid"));
            Rows formrows = dbConnect.runSqlQuery(formsql);
            RowsMap formRowsMap = formrows.toRowsMap("systemappid");

            SQLFactory formcolsql = new SQLFactory(this, "获取角色应用表单栏位配置");
            formcolsql.addParameter_in("formid", formrows.toArrayList("formid"));
            Rows allformcolRows = dbConnect.runSqlQuery(formcolsql);
            RowsMap siteformcolRowsMap = dbConnect.runSqlQuery("select formcolid,title,required,hidden,span from sys_systemapp_formcols_site where siteid='" + siteid + "'").toRowsMap("formcolid");

            for (Row allformcolRow : allformcolRows) {
                if (siteformcolRowsMap.containsKey(allformcolRow.getString("formcolid"))) {
                    Rows sitecolsRows = siteformcolRowsMap.get(allformcolRow.getString("formcolid"));
                    if (!sitecolsRows.get(0).getString("title").equals("")) {
                        allformcolRow.put("title", sitecolsRows.get(0).getString("title"));
                    }
                    if (sitecolsRows.get(0).getInteger("span") > 1) {
                        allformcolRow.put("span", sitecolsRows.get(0).getInteger("span"));
                    }
                    if (sitecolsRows.get(0).getInteger("required") == 1) {
                        allformcolRow.put("required", 1);
                    }
                    if (sitecolsRows.get(0).getInteger("hidden") == 1) {
                        allformcolRow.put("hidden", 1);
                    }

                }
            }
            RowsMap fromcolRowsMap = allformcolRows.toRowsMap("formid");

            /*
             * 获取应用表格配置
             */
            SQLFactory tablesql = new SQLFactory(this, "获取角色应用表格配置");
            tablesql.addParameter_in("systemappid", appRows.toArrayList("systemappid"));
            Rows tablerows = dbConnect.runSqlQuery(tablesql);
            RowsMap tableRowsMap = tablerows.toRowsMap("systemappid");

            SQLFactory tablecolsql = new SQLFactory(this, "获取角色应用表格栏位配置");
            tablecolsql.addParameter_in("tableid", tablerows.toArrayList("tableid"));
            Rows alltablecolRows = dbConnect.runSqlQuery(tablecolsql);
            RowsMap sitetablecolRowsMap = dbConnect.runSqlQuery("select tablecolid,title,width,hidden from sys_systemapp_tablecols_site where siteid='" + siteid + "'").toRowsMap("tablecolid");

            ArrayList<Row> hiddenRow = new ArrayList<>();
            for (Row tablecolRow : alltablecolRows) {
                if (sitetablecolRowsMap.containsKey(tablecolRow.getString("tablecolid"))) {
                    Rows sitecolsRows = sitetablecolRowsMap.get(tablecolRow.getString("tablecolid"));
                    if (!sitecolsRows.get(0).getString("title").equals("")) {
                        tablecolRow.put("title", sitecolsRows.get(0).getString("title"));
                    }
                    if (sitecolsRows.get(0).getInteger("width") > 0) {
                        tablecolRow.put("width", sitecolsRows.get(0).getInteger("width"));
                    }
                    if (sitecolsRows.get(0).getInteger("hidden") == 1) {
                        tablecolRow.put("hidden", 1);
                    }
                }
                if (tablecolRow.getBoolean("hidden")) {
                    hiddenRow.add(tablecolRow);
                }
            }
            for (Row row : hiddenRow) {
                alltablecolRows.remove(row);
            }
            RowsMap tablecolRowsMap = alltablecolRows.toRowsMap("tableid");

            /*
             * 获取应用小组件配置
             */
            SQLFactory wedgitsql = new SQLFactory(this, "获取角色应用小组件配置");
            wedgitsql.addParameter_in("systemappid", appRows.toArrayList("systemappid"));
            RowsMap wedgitRowsMap = dbConnect.runSqlQuery(wedgitsql).toRowsMap("systemappid");


            for (Row systemRow : systemRows) {
                Rows modulerows = moduleRowsMap.get(systemRow.getString("systemid"));
                for (Row moduleRow : modulerows) {
                    Rows approws = appRowsMap.get(moduleRow.getString("systemmoduleid"));
                    for (Row appRow : approws) {
                        String systemappid = appRow.getString("systemappid");

                        Rows optionRows = optionRowsMap.get(systemappid);
                        optionRows.removeColumn(new String[]{"systemappid"});

                        Rows hiddenfieldRows = hiddenfieldRowsMap.get(systemappid);
                        hiddenfieldRows.removeColumn(new String[]{"systemappid"});

                        Rows wedgitsRows = wedgitRowsMap.get(systemappid);
                        wedgitsRows.removeColumn(new String[]{"systemappid"});

                        JSONObject fromObject = new JSONObject();
                        Rows formRows = formRowsMap.get(systemappid);
                        for (Row formRow : formRows) {
                            Rows formcolRows = fromcolRowsMap.get(formRow.getString("formid"));
                            formcolRows.removeColumn(new String[]{"formcolid"});
                            formRow.put("formcols", formcolRows);
                            fromObject.put(formRow.getString("form"), formRow);
                        }
                        formRows.removeColumn(new String[]{"systemappid", "form"});


                        JSONObject tableObject = new JSONObject();
                        Rows tableRows = tableRowsMap.get(systemappid);
                        for (Row tableRow : tableRows) {
                            Rows tablecolRows = tablecolRowsMap.get(tableRow.getString("tableid"));
                            tablecolRows.removeColumn(new String[]{"tablecolid"});
                            tableRow.put("tablecols", tablecolRows);
                            tableObject.put(tableRow.getString("table"), tableRow);
                        }
                        tableRows.removeColumn(new String[]{"systemappid", "table"});

                        JSONObject metaObject = new JSONObject();
                        metaObject.put("title", appRow.getString("systemappname"));
                        metaObject.put("auth", optionRows);
                        metaObject.put("hiddenfields", hiddenfieldRows);
                        metaObject.put("wedgits", wedgitsRows);
                        metaObject.put("forms", fromObject);
                        metaObject.put("tables", tableObject);

                        appRow.put("path", appRow.getString("apppath"));
                        appRow.put("path_index", appRow.getString("apppath_index"));
                        appRow.put("name", appRow.getString("systemapp"));
                        appRow.put("meta", metaObject);
                        appRow.put("component", "");
                        appRow.put("isneedpay", AccountPay.isNeedPay(this, systemappid));
                    }
                    moduleRow.put("apps", approws);
                }
                systemRow.put("modules", modulerows);
            }
            appRows.removeColumn(new String[]{"systemappname", "systemapp", "apppath", "apppath_index"});
            parameter.userauth_systemappids.put(userid, appRows);
            return getSucReturnObject().setData(systemRows).toString();
        } else {
            /*
            系统管理员权限获取，无需授权，返回所有功能权限
             */
            /*
             * 获取角色系统授权
             */
            SQLFactory systemsql = new SQLFactory(this, "获取系统管理员角色系统授权");
            systemsql.addParameter("systemclient", systemclient);
            systemsql.addParameter("showplace", showplace);
            Rows systemRows = dbConnect.runSqlQuery(systemsql);
            for (Row row : systemRows) {
                row.put("iconurl", getSystemIconUrl(row.getLong("systemid"), "icon"));
                row.put("iconurl_mainnav", getSystemIconUrl(row.getLong("systemid"), "mainnavicon"));
            }
            /*
             * 获取角色模块授权
             */
            SQLFactory modulesql = new SQLFactory(this, "获取系统管理员角色模块授权");
            modulesql.addParameter("systemclient", systemclient);
            modulesql.addParameter("showplace", showplace);
            Rows moduleRows = dbConnect.runSqlQuery(modulesql);
            for (Row row : moduleRows) {
                row.put("iconurl", getSystemModuleIconUrl(row.getLong("systemmoduleid"), "icon"));
                row.put("iconurl_mainnav", getSystemModuleIconUrl(row.getLong("systemmoduleid"), "mainnavicon"));
            }
            RowsMap moduleRowsMap = moduleRows.toRowsMap("systemid");
            /*
             * 获取角色应用授权
             */
            SQLFactory appsql = new SQLFactory(this, "获取系统管理员角色应用授权");
            appsql.addParameter("systemclient", systemclient);
            appsql.addParameter("showplace", showplace);
            Rows appRows = dbConnect.runSqlQuery(appsql);
            RowsMap appRowsMap = appRows.toRowsMap("systemmoduleid");

            /*
             * 获取角色功能授权
             */
            SQLFactory optionsql = new SQLFactory(this, "获取系统管理员角色功能授权");
            optionsql.addParameter("siteid", siteid);
            Rows OptionRows = dbConnect.runSqlQuery(optionsql);
            RowsMap optionRowsMap = OptionRows.toRowsMap("systemappid");

            /*
             * 获取应用表单配置
             */
            SQLFactory formsql = new SQLFactory(this, "获取角色应用表单配置");
            formsql.addParameter_in("systemappid", appRows.toArrayList("systemappid"));
            Rows formrows = dbConnect.runSqlQuery(formsql);
            RowsMap formRowsMap = formrows.toRowsMap("systemappid");

            SQLFactory formcolsql = new SQLFactory(this, "获取角色应用表单栏位配置");
            formcolsql.addParameter_in("formid", formrows.toArrayList("formid"));
            Rows allformcolRows = dbConnect.runSqlQuery(formcolsql);
            RowsMap siteformcolRowsMap = dbConnect.runSqlQuery("select formcolid,title,required,hidden,span from sys_systemapp_formcols_site where siteid='" + siteid + "'").toRowsMap("formcolid");

            for (Row allformcolRow : allformcolRows) {
                if (siteformcolRowsMap.containsKey(allformcolRow.getString("formcolid"))) {
                    Rows sitecolsRows = siteformcolRowsMap.get(allformcolRow.getString("formcolid"));
                    if (!sitecolsRows.get(0).getString("title").equals("")) {
                        allformcolRow.put("title", sitecolsRows.get(0).getString("title"));
                    }
                    if (sitecolsRows.get(0).getInteger("span") > 1) {
                        allformcolRow.put("span", sitecolsRows.get(0).getInteger("span"));
                    }
                    if (sitecolsRows.get(0).getInteger("required") == 1) {
                        allformcolRow.put("required", 1);
                    }
                    if (sitecolsRows.get(0).getInteger("hidden") == 1) {
                        allformcolRow.put("hidden", 1);
                    }
                }
            }
            RowsMap fromcolRowsMap = allformcolRows.toRowsMap("formid");

            /*
             * 获取应用表格配置
             */
            SQLFactory tablesql = new SQLFactory(this, "获取角色应用表格配置");
            tablesql.addParameter_in("systemappid", appRows.toArrayList("systemappid"));
            Rows tablerows = dbConnect.runSqlQuery(tablesql);
            RowsMap tableRowsMap = tablerows.toRowsMap("systemappid");

            SQLFactory tablecolsql = new SQLFactory(this, "获取角色应用表格栏位配置");
            tablecolsql.addParameter_in("tableid", tablerows.toArrayList("tableid"));
            Rows alltablecolRows = dbConnect.runSqlQuery(tablecolsql);
            RowsMap sitetablecolRowsMap = dbConnect.runSqlQuery("select tablecolid,title,width,hidden from sys_systemapp_tablecols_site where siteid='" + siteid + "'").toRowsMap("tablecolid");

            ArrayList<Row> hiddenRow = new ArrayList<>();
            for (Row tablecolRow : alltablecolRows) {
                if (sitetablecolRowsMap.containsKey(tablecolRow.getString("tablecolid"))) {
                    Rows sitecolsRows = sitetablecolRowsMap.get(tablecolRow.getString("tablecolid"));
                    if (!sitecolsRows.get(0).getString("title").equals("")) {
                        tablecolRow.put("title", sitecolsRows.get(0).getString("title"));
                    }
                    if (sitecolsRows.get(0).getInteger("width") > 0) {
                        tablecolRow.put("width", sitecolsRows.get(0).getInteger("width"));
                    }
                    if (sitecolsRows.get(0).getInteger("hidden") == 1) {
                        tablecolRow.put("hidden", 1);
                    }
                }
                if (tablecolRow.getBoolean("hidden")) {
                    hiddenRow.add(tablecolRow);
                }
            }
            for (Row row : hiddenRow) {
                alltablecolRows.remove(row);
            }
            RowsMap tablecolRowsMap = alltablecolRows.toRowsMap("tableid");

            /*
             * 获取应用小组件配置
             */
            SQLFactory wedgitsql = new SQLFactory(this, "获取角色应用小组件配置");
            wedgitsql.addParameter_in("systemappid", appRows.toArrayList("systemappid"));
            RowsMap wedgitRowsMap = dbConnect.runSqlQuery(wedgitsql).toRowsMap("systemappid");


            for (Row systemRow : systemRows) {
                Rows modulerows = moduleRowsMap.get(systemRow.getString("systemid"));
                for (Row moduleRow : modulerows) {
                    Rows approws = appRowsMap.get(moduleRow.getString("systemmoduleid"));
                    for (Row appRow : approws) {
                        String systemappid = appRow.getString("systemappid");

                        Rows optionRows = optionRowsMap.get(systemappid);
                        optionRows.removeColumn(new String[]{"systemappid"});

                        Rows wedgitsRows = wedgitRowsMap.get(systemappid);
                        wedgitsRows.removeColumn(new String[]{"systemappid"});

                        JSONObject fromObject = new JSONObject();
                        Rows formRows = formRowsMap.get(systemappid);
                        for (Row formRow : formRows) {
                            Rows formcolRows = fromcolRowsMap.get(formRow.getString("formid"));
                            formcolRows.removeColumn(new String[]{"formcolid"});
                            formRow.put("formcols", formcolRows);
                            fromObject.put(formRow.getString("form"), formRow);
                        }
                        formRows.removeColumn(new String[]{"systemappid", "form"});


                        JSONObject tableObject = new JSONObject();
                        Rows tableRows = tableRowsMap.get(systemappid);
                        for (Row tableRow : tableRows) {
                            Rows tablecolRows = tablecolRowsMap.get(tableRow.getString("tableid"));
                            tablecolRows.removeColumn(new String[]{"tablecolid"});
                            tableRow.put("tablecols", tablecolRows);
                            tableObject.put(tableRow.getString("table"), tableRow);
                        }
                        tableRows.removeColumn(new String[]{"systemappid", "table"});

                        JSONObject metaObject = new JSONObject();
                        metaObject.put("title", appRow.getString("systemappname"));
                        metaObject.put("auth", optionRows);
                        metaObject.put("hiddenfields", new JSONArray());
                        metaObject.put("wedgits", wedgitsRows);
                        metaObject.put("forms", fromObject);
                        metaObject.put("tables", tableObject);

                        appRow.put("path", appRow.getString("apppath"));
                        appRow.put("path_index", appRow.getString("apppath_index"));
                        appRow.put("name", appRow.getString("systemapp"));
                        appRow.put("meta", metaObject);
                        appRow.put("component", "");
                        appRow.put("isneedpay", false);
                    }
                    moduleRow.put("apps", approws);
                }
                systemRow.put("modules", modulerows);
            }
            appRows.removeColumn(new String[]{"systemappname", "systemapp", "apppath", "apppath_index"});
            parameter.userauth_systemappids.put(userid, appRows);
            return getSucReturnObject().setData(systemRows).toString();
        }
    }

    @API(title = "获取当前登陆角色快捷方式信息", apiversion = R.ID10017101.v1.class)
    @CACHEING
    public String query_usershortcuts() throws YosException {
        String shortcuttype = "systemmodule";
        if (content.containsKey("shortcuttype")) {
            shortcuttype = content.getString("shortcuttype");
        }
        if (shortcuttype.equalsIgnoreCase("systemmodule")) {
            /*
             *查询账号有无营销物料的快捷方式，如果没有，则自动加入
             */
            if (systemclient.equalsIgnoreCase("web")) {
                if (dbConnect.runSqlQuery("select * from sys_shortcuts where siteid='" + siteid + "' and userid='" + userid + "' and systemclient='" + systemclient + "'").isEmpty()) {
                    SQLFactory sqlFactory = new SQLFactory(this, "模块快捷方式插入");
                    sqlFactory.addParameter("systemclient", systemclient);
                    sqlFactory.addParameter("siteid", siteid);
                    sqlFactory.addParameter("userid", userid);
                    sqlFactory.addParameter("systemmoduleid", 210);//媒体库
                    sqlFactory.addParameter("sequence", 1);
                    sqlFactory.addParameter("location", "mainnav");
                    sqlFactory.addParameter("issystem", 1);
                    sqlFactory.addParameter("sys_shortcutsid", createTableID("sys_shortcuts"));
                    dbConnect.runSqlUpdate(sqlFactory.getSQL());
                }
            }
            SQLFactory modulesql = new SQLFactory(this, "获取角色模块快捷方式");
            modulesql.addParameter("userid", userid);
            modulesql.addParameter("siteid", siteid);
            modulesql.addParameter("systemclient", systemclient);
            Rows moduleRows = dbConnect.runSqlQuery(modulesql);

            for (Row row : moduleRows) {
                row.put("iconurl", getSystemModuleIconUrl(row.getLong("systemmoduleid"), "icon"));
                row.put("iconurl_mainnav", getSystemModuleIconUrl(row.getLong("systemmoduleid"), "mainnavicon"));
            }
            return getSucReturnObject().setData(moduleRows).toString();
        } else if (shortcuttype.equalsIgnoreCase("systemapp")) {
            SQLFactory modulesql = new SQLFactory(this, "获取角色应用快捷方式");
            modulesql.addParameter("userid", userid);
            modulesql.addParameter("siteid", siteid);
            modulesql.addParameter("systemclient", systemclient);
            Rows moduleRows = dbConnect.runSqlQuery(modulesql);
            return getSucReturnObject().setData(moduleRows).toString();
        }
        return getSucReturnObject().setData(new Rows()).toString();
    }

    @API(title = "创建登陆角色快捷方式", intervaltime = 1000, apiversion = R.ID10017201.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = userauth.class, method = {"query_usershortcuts"})})
    public String create_usershortcuts() throws YosException {
        long systemmoduleid = content.getLongValue("systemmoduleid");
        long systemappid = content.getLongValue("systemappid");
        String location = (String) content.getOrDefault("location", "mainnav");
        if (systemmoduleid > 0 && systemappid == 0) {
            SQLFactory sqlFactory = new SQLFactory(this, "模块快捷方式插入");
            sqlFactory.addParameter("systemclient", systemclient);
            sqlFactory.addParameter("siteid", siteid);
            sqlFactory.addParameter("userid", userid);
            sqlFactory.addParameter("systemmoduleid", systemmoduleid);
            sqlFactory.addParameter("sequence", 1);
            sqlFactory.addParameter("location", location);
            sqlFactory.addParameter("issystem", 0);
            sqlFactory.addParameter("sys_shortcutsid", createTableID("sys_shortcuts"));
            dbConnect.runSqlUpdate(sqlFactory.getSQL());
        } else if (systemmoduleid == 0 && systemappid > 0) {
            SQLFactory sqlFactory = new SQLFactory(this, "应用快捷方式插入");
            sqlFactory.addParameter("systemclient", systemclient);
            sqlFactory.addParameter("siteid", siteid);
            sqlFactory.addParameter("userid", userid);
            sqlFactory.addParameter("systemappid", systemappid);
            sqlFactory.addParameter("sequence", 1);
            sqlFactory.addParameter("location", location);
            sqlFactory.addParameter("issystem", 0);
            sqlFactory.addParameter("sys_shortcutsid", createTableID("sys_shortcuts"));
            dbConnect.runSqlUpdate(sqlFactory.getSQL());
        }
        return getSucReturnObject().toString();
    }

    @API(title = "删除登陆角色快捷方式", intervaltime = 1000, apiversion = R.ID10017301.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = userauth.class, method = {"query_usershortcuts"})})
    public String delete_usershortcuts() throws YosException {
        long systemmoduleid = content.getLongValue("systemmoduleid");
        long systemappid = content.getLongValue("systemappid");
        String location = (String) content.getOrDefault("location", "mainnav");
        if (systemmoduleid > 0 && systemappid == 0) {
            dbConnect.runSqlUpdate("delete from sys_shortcuts where siteid='" + siteid + "' and systemclient='" + systemclient + "' and userid='" + userid + "' and location='" + location + "' and systemmoduleid='" + systemmoduleid + "'");
        } else if (systemmoduleid == 0 && systemappid > 0) {
            dbConnect.runSqlUpdate("delete from sys_shortcuts where siteid='" + siteid + "' and systemclient='" + systemclient + "' and userid='" + userid + "' and location='" + location + "' and systemappid='" + systemappid + "'");
        }
        return getSucReturnObject().toString();
    }

    @API(title = "添加禅道任务或bug", apiversion = R.ID10017401.v1.class)
    public String addZenTao() throws YosException {
        String type = content.getString("type");//task/bug
        long id = content.getLong("id");
        long systemappid = content.getLong("systemappid");

        SQLFactory sqlFactory = new SQLFactory(this, "禅道任务绑定");
        sqlFactory.addParameter("zentaoid", createTableID("zentao"));
        sqlFactory.addParameter("systemappid", systemappid);
        sqlFactory.addParameter("id", id);
        sqlFactory.addParameter("type", type);
        dbConnect.runSqlUpdate(sqlFactory.getSQL());
        return getSucReturnObject().toString();
    }
}
