SELECT t1.sys_site_systempartitionid,
       t3.partitionname,
       t2.enddate,
       t2.userid,
       (UNIX_TIMESTAMP(t2.enddate) - UNIX_TIMESTAMP(CURRENT_DATE)) / 86400 days,
       t4.name
from sys_payorder t1
         INNER JOIN sys_payorderitems t2 ON t2.sys_payorderid = t1.sys_payorderid and t2.siteid = t1.siteid
         INNER JOIN sys_site_systempartition t3
                    ON t3.sys_site_systempartitionid = t1.sys_site_systempartitionid and t3.siteid = t1.siteid
         INNER JOIN sa_agent_hr t4 ON t4.userid = t2.userid and t4.siteid = t2.siteid
WHERE t1.ispaid = 1
  and t1.siteid = $siteid$
  and t1.deleted = 0
  and t2.userid in $userid$
  and t2.enddate > CURRENT_DATE
  and UNIX_TIMESTAMP(t2.enddate) - UNIX_TIMESTAMP(CURRENT_DATE) <= 86400 * $days$