package restcontroller.sysmanage.develop.sys_object;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.annotation.CACHEING;
import common.annotation.CACHEING_CLEAN;
import common.annotation.cm;
import common.data.*;
import common.data.db.DBConnect;
import common.data.db.DBConnectPool;
import common.data.SQLFactory;
import common.data.db.SQLiteMemory;
import restcontroller.R;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;

@API(title = "管理端-开发-数据库管理")
public class sys_object extends Controller {
    public sys_object(JSONObject content) throws YosException {
        super(content);
    }

    /**
     * 表信息查询
     *
     * @return
     */
    @API(title = "表信息查询", apiversion = R.ID10000101.v1.class)
    public String queryObjectList() throws YosException {
        /**
         * 过滤条件设置
         */
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("t1.table_name like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.table_comment like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.uniquecolumnname ='").append(whereObject.getString("condition")).append("' ");
                where.append(")");
            }
            if (whereObject.containsKey("issystem") && !"".equals(whereObject.getString("issystem"))) {
                where.append(" and(");
                where.append("t1.issystem ='").append(whereObject.getString("issystem")).append("' ");
                where.append(")");
            }
            if (whereObject.containsKey("app") && !"".equals(whereObject.getString("app"))) {
                where.append(" and(");
                where.append("exists (select * from sys_objectapps inner join sys_systemapp on sys_objectapps.systemappid=sys_systemapp.systemappid and sys_objectapps.table_name=t1.table_name and (sys_systemapp.systemapp like'%" + whereObject.getString("app") + "%' or sys_systemapp.systemappname like '%" + whereObject.getString("app") + "%')  )");
                where.append(")");
            }
            if (whereObject.containsKey("fieldname") && !"".equals(whereObject.getString("fieldname"))) {
                where.append(" and(");
                where.append("exists (select * from sys_objectcols where sys_objectcols.table_name=t1.table_name and (sys_objectcols.column_name like'%" + whereObject.getString("fieldname") + "%' or sys_objectcols.column_title like '%" + whereObject.getString("fieldname") + "%')  )");
                where.append(")");
            }
        }
        SQLFactory selectTable = new SQLFactory(this, "表信息查询", pageSize, pageNumber, pageSorting);
        selectTable.addParameter_SQL("where", where);
        selectTable.addParameter("TABLE_SCHEMA", dbConnect.getDBName());
        Rows tableRows = dbConnect.runSqlQuery(selectTable.getSQL());

        QuerySQL sys_objectappsQuerySQL = SQLFactory.createQuerySQL(this, "sys_objectapps", "table_name");
        sys_objectappsQuerySQL.addJoinTable(JOINTYPE.inner, "sys_systemapp", "sys_systemapp", "systemappid=:systemappid", "systemappname");
        sys_objectappsQuerySQL.setWhere("sys_objectapps.table_name", tableRows.toArrayList("table_name"));
        RowsMap sys_objectappsRowsMap = sys_objectappsQuerySQL.query().toRowsMap("table_name");

        ArrayList<String> sys_objectcolsList = dbConnect.runSqlQuery("select distinct table_name from sys_objectcols where savedatalog=1").toArrayList("table_name");

        for (Row row : tableRows) {
            String table_name = row.getString("table_name");
            row.put("apps", sys_objectappsRowsMap.get(table_name).toJsonArray("systemappname"));
            row.put("savedatalog", sys_objectcolsList.contains(table_name) ? 1 : 0);
        }
        return getSucReturnObject().setData(tableRows).toString();
    }

    /**
     * 表字段信息查询
     *
     * @return
     */
    @API(title = "表字段信息查询", apiversion = R.ID10000201.v1.class)
    public String queryObjectColList() throws YosException {
        String table_name = content.getString("table_name");
        /**
         * 过滤条件设置
         */
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("column_name like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or column_comment like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
        }
        SQLFactory selectTableCol = new SQLFactory(this, "字段信息查询", pageSize, pageNumber, pageSorting);
        selectTableCol.addParameter("table_name", table_name);
        selectTableCol.addParameter_SQL("where", where);
        Rows tableRows = dbConnect.runSqlQuery(selectTableCol.getSQL());
        return getSucReturnObject().setData(tableRows).toString();
    }

    /**
     * 新增修改表
     *
     * @return
     */
    @API(title = "新增修改表", apiversion = R.ID10000301.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = sys_object.class, method = {"queryObjectColList", "queryObjectList", "queryColumnSequence"})})
    public String insertormodify_object() throws YosException {
        String table_name = content.getString("table_name").toLowerCase();

        String table_comment = content.getString("table_comment");
        int sequence = content.getIntValue("sequence");

        if (table_name.equals("") || !String.valueOf(table_name.charAt(0)).matches("^[a-zA-Z]*")) {
            return getErrReturnObject().setErrMsg("表名必须以小写英文字母开头").toString();
        }

        if (!table_name.replace("_", "").matches("^[a-z0-9]*")) {
            return getErrReturnObject().setErrMsg("表名必须为小写英文字母或英文数字组合").toString();
        }
        if ("".equals(table_comment)) {
            return getErrReturnObject().setErrMsg("数据表描述不可为空").toString();
        }
        ArrayList<String> list = new ArrayList<>();
        if (dbConnect.runSqlQuery("select *from sys_object where table_name='" + table_name + "'").isEmpty()) {
            String uniquecolumnname = table_name + "id";//唯一字段值
            SQLFactory insertTable = new SQLFactory(this, "表新增");
            insertTable.addParameter("table_name", table_name);
            insertTable.addParameter("table_comment", table_comment);
            insertTable.addParameter("uniquecolumnname", uniquecolumnname);
            insertTable.addParameter("sequence", sequence);
            list.add(insertTable.getSQL());
            {
                SQLFactory insertCol = new SQLFactory(this, "字段新增");
                insertCol.addParameter("table_name", table_name);
                insertCol.addParameter("column_name", uniquecolumnname);
                insertCol.addParameter("column_title", table_comment + "ID");
                insertCol.addParameter("column_default", "null");
                insertCol.addParameter("numeric_precision", 19);
                insertCol.addParameter("numeric_scale", 0);
                insertCol.addParameter("column_type", "bigint");
                insertCol.addParameter("column_comment", table_comment + "ID");
                insertCol.addParameter("is_nullable", 0);
                insertCol.addParameter("savedatalog", 0);
                insertCol.addParameter("uniqued", 1);
                insertCol.addParameter("sequence", 1);
                list.add(insertCol.getSQL());
            }
            {
                SQLFactory insertCol = new SQLFactory(this, "字段新增");
                insertCol.addParameter("table_name", table_name);
                insertCol.addParameter("column_name", "siteid");
                insertCol.addParameter("column_title", "站点");
                insertCol.addParameter("column_default", "null");
                insertCol.addParameter("numeric_precision", 50);
                insertCol.addParameter("numeric_scale", 0);
                insertCol.addParameter("column_type", "varchar");
                insertCol.addParameter("column_comment", "站点ID");
                insertCol.addParameter("is_nullable", 0);
                insertCol.addParameter("savedatalog", 0);
                insertCol.addParameter("uniqued", 0);
                insertCol.addParameter("sequence", 2);
                list.add(insertCol.getSQL());
            }
//            {
//                SQLFactory insertCol = new SQLFactory(this, "字段新增");
//                insertCol.addParameter("table_name", table_name);
//                insertCol.addParameter("column_name", "createdepid");
//                insertCol.addParameter("column_title", "创建人部门ID");
//                insertCol.addParameter("column_default", "null");
//                insertCol.addParameter("numeric_precision", 19);
//                insertCol.addParameter("numeric_scale", 0);
//                insertCol.addParameter("column_type", "bigint");
//                insertCol.addParameter("column_comment", "创建人部门ID");
//                insertCol.addParameter("is_nullable", 0);
//                insertCol.addParameter("savedatalog", 0);
//                insertCol.addParameter("uniqued", 0);
//                insertCol.addParameter("sequence", 1001);
//                list.add(insertCol.getSQL());
//            }
            if (!content.getBooleanValue("isasync")) {
                SQLFactory insertCol = new SQLFactory(this, "字段新增");
                insertCol.addParameter("table_name", table_name);
                insertCol.addParameter("column_name", "createuserid");
                insertCol.addParameter("column_title", "创建人账号ID");
                insertCol.addParameter("column_default", "null");
                insertCol.addParameter("numeric_precision", 19);
                insertCol.addParameter("numeric_scale", 0);
                insertCol.addParameter("column_type", "bigint");
                insertCol.addParameter("column_comment", "创建人账号ID");
                insertCol.addParameter("is_nullable", 1);
                insertCol.addParameter("savedatalog", 0);
                insertCol.addParameter("uniqued", 0);
                insertCol.addParameter("sequence", 1002);
                list.add(insertCol.getSQL());
            }
            if (!content.getBooleanValue("isasync")) {
                SQLFactory insertCol = new SQLFactory(this, "字段新增");
                insertCol.addParameter("table_name", table_name);
                insertCol.addParameter("column_name", "createby");
                insertCol.addParameter("column_title", "创建人");
                insertCol.addParameter("column_default", "null");
                insertCol.addParameter("numeric_precision", 50);
                insertCol.addParameter("numeric_scale", 0);
                insertCol.addParameter("column_type", "varchar");
                insertCol.addParameter("column_comment", "创建人");
                insertCol.addParameter("is_nullable", 1);
                insertCol.addParameter("savedatalog", 0);
                insertCol.addParameter("uniqued", 0);
                insertCol.addParameter("sequence", 1003);
                list.add(insertCol.getSQL());
            }
            if (!content.getBooleanValue("isasync")) {
                SQLFactory insertCol = new SQLFactory(this, "字段新增");
                insertCol.addParameter("table_name", table_name);
                insertCol.addParameter("column_name", "createdate");
                insertCol.addParameter("column_title", "创建时间");
                insertCol.addParameter("column_default", "null");
                insertCol.addParameter("numeric_precision", 19);
                insertCol.addParameter("numeric_scale", 0);
                insertCol.addParameter("column_type", "datetime");
                insertCol.addParameter("column_comment", "创建时间");
                insertCol.addParameter("is_nullable", 1);
                insertCol.addParameter("savedatalog", 0);
                insertCol.addParameter("uniqued", 0);
                insertCol.addParameter("sequence", 1004);
                list.add(insertCol.getSQL());
            }
//             if (!content.getBooleanValue("isasync")) {
//                SQLFactory insertCol = new SQLFactory(this, "字段新增");
//                insertCol.addParameter("table_name", table_name);
//                insertCol.addParameter("column_name", "authuserid");
//                insertCol.addParameter("column_title", "数据归属人账号ID");
//                insertCol.addParameter("column_default", "null");
//                insertCol.addParameter("numeric_precision", 19);
//                insertCol.addParameter("numeric_scale", 0);
//                insertCol.addParameter("column_type", "bigint");
//                insertCol.addParameter("column_comment", "数据归属人账号ID");
//                insertCol.addParameter("is_nullable", 0);
//                insertCol.addParameter("savedatalog", 0);
//                insertCol.addParameter("uniqued", 0);
//                insertCol.addParameter("sequence", 1005);
//                list.add(insertCol.getSQL());
//            }
//            if (!content.getBooleanValue("isasync")) {
//                SQLFactory insertCol = new SQLFactory(this, "字段新增");
//                insertCol.addParameter("table_name", table_name);
//                insertCol.addParameter("column_name", "authdepid");
//                insertCol.addParameter("column_title", "数据归属人部门ID");
//                insertCol.addParameter("column_default", "null");
//                insertCol.addParameter("numeric_precision", 19);
//                insertCol.addParameter("numeric_scale", 0);
//                insertCol.addParameter("column_type", "bigint");
//                insertCol.addParameter("column_comment", "数据归属人部门ID");
//                insertCol.addParameter("is_nullable", 0);
//                insertCol.addParameter("savedatalog", 0);
//                insertCol.addParameter("uniqued", 0);
//                insertCol.addParameter("sequence", 1006);
//                list.add(insertCol.getSQL());
//            }
            if (!content.getBooleanValue("isasync")) {
                SQLFactory insertCol = new SQLFactory(this, "字段新增");
                insertCol.addParameter("table_name", table_name);
                insertCol.addParameter("column_name", "changeuserid");
                insertCol.addParameter("column_title", "修改人账号ID");
                insertCol.addParameter("column_default", "null");
                insertCol.addParameter("numeric_precision", 19);
                insertCol.addParameter("numeric_scale", 0);
                insertCol.addParameter("column_type", "bigint");
                insertCol.addParameter("column_comment", "修改人账号ID");
                insertCol.addParameter("is_nullable", 1);
                insertCol.addParameter("savedatalog", 0);
                insertCol.addParameter("uniqued", 0);
                insertCol.addParameter("sequence", 1007);
                list.add(insertCol.getSQL());
            }
            if (!content.getBooleanValue("isasync")) {
                SQLFactory insertCol = new SQLFactory(this, "字段新增");
                insertCol.addParameter("table_name", table_name);
                insertCol.addParameter("column_name", "changeby");
                insertCol.addParameter("column_title", "修改人");
                insertCol.addParameter("column_default", "null");
                insertCol.addParameter("numeric_precision", 50);
                insertCol.addParameter("numeric_scale", 0);
                insertCol.addParameter("column_type", "varchar");
                insertCol.addParameter("column_comment", "修改人");
                insertCol.addParameter("is_nullable", 1);
                insertCol.addParameter("savedatalog", 0);
                insertCol.addParameter("uniqued", 0);
                insertCol.addParameter("sequence", 1008);
                list.add(insertCol.getSQL());
            }
            if (!content.getBooleanValue("isasync")) {
                SQLFactory insertCol = new SQLFactory(this, "字段新增");
                insertCol.addParameter("table_name", table_name);
                insertCol.addParameter("column_name", "changedate");
                insertCol.addParameter("column_title", "修改时间");
                insertCol.addParameter("column_default", "null");
                insertCol.addParameter("numeric_precision", 19);
                insertCol.addParameter("numeric_scale", 0);
                insertCol.addParameter("column_type", "datetime");
                insertCol.addParameter("column_comment", "修改时间");
                insertCol.addParameter("is_nullable", 1);
                insertCol.addParameter("savedatalog", 0);
                insertCol.addParameter("uniqued", 0);
                insertCol.addParameter("sequence", 1009);
                list.add(insertCol.getSQL());
            }
        } else {
            Rows sys_objectrows = dbConnect.runSqlQuery("select *from sys_object where table_name='" + table_name + "'");
            if (sys_objectrows.isEmpty()) {
                return getErrReturnObject().setErrMsg("不存在的表！").toString();
            }
            if (sys_objectrows.get(0).getBoolean("issystem")) {
                return getErrReturnObject().setErrMsg("系统表不可修改！").toString();
            }
            String old_table_comment = sys_objectrows.get(0).getString("table_comment");
            if (!old_table_comment.equals(table_comment)) {
                SQLFactory modifyTable = new SQLFactory(this, "表修改");
                modifyTable.addParameter("table_name", table_name);
                modifyTable.addParameter("table_comment", table_comment);
                modifyTable.addParameter("sequence", sequence);
                list.add(modifyTable.getSQL());

                /*
                 *将其他表中用到该字段的名称都进行统一调整
                 */
                String uniquecolumnname = sys_objectrows.get(0).getString("uniquecolumnname");
                list.add("update sys_objectcols set status=(case when status is null then 'C' else status end ),column_title='" + table_comment + "',column_comment='" + table_comment + "ID' where table_name='" + table_name + "' and column_name='" + uniquecolumnname + "'");
                list.add("update sys_objectcols set status=(case when status is null then 'C' else status end ),column_title='" + table_comment + "',column_comment='" + table_comment + "ID' where table_name!='" + table_name + "' and column_name='" + uniquecolumnname + "'");
                list.add("update sys_object set status=(case when status is null then 'C' else status end ) where table_name!='" + table_name + "' and exists(select * from sys_objectcols where sys_objectcols.table_name=sys_object.table_name and column_name='" + uniquecolumnname + "')");
            } else {
                list.add("update sys_object set sequence=" + sequence + " where table_name='" + table_name + "'");
            }
        }
        dbConnect.runSqlUpdate(list);
        return getSucReturnObject().toString();
    }

    /**
     * 删除表
     *
     * @return
     */
    @API(title = "删除表", apiversion = R.ID10000401.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = sys_object.class, method = {"queryObjectList"})})
    public String delete_object() throws YosException {
        String table_name = content.getString("table_name").toLowerCase();
        boolean isdelete = content.getBooleanValue("isdelete");

        Rows rows = dbConnect.runSqlQuery("select * from sys_object where table_name='" + table_name + "'");
        boolean issystem = rows.get(0).getBoolean("issystem");
        if (issystem) {
            return getErrReturnObject().setErrMsg("系统表不可删除！").toString();
        }
        ArrayList<String> list = new ArrayList<>();
        String oldstatus = rows.get(0).getString("status");
        if (oldstatus.equals("C")) {
            return getErrReturnObject().setErrMsg("当前状态不可删除！").toString();
        }
        if (isdelete) {
            if (oldstatus.equals("A")) {
                list.add("delete from sys_object where table_name='" + table_name + "'");
                list.add("delete from sys_objectcols where table_name='" + table_name + "'");
            } else {
                if (dbConnect.runSqlQuery("select count(0) as count from " + table_name).get(0).getLong("count") > 0) {
                    return getErrReturnObject().setErrMsg("该表存在数据，不可删除！").toString();
                }
                list.add("update sys_object set status='D' where table_name='" + table_name + "'");
                list.add("update sys_objectcols set status='D' where table_name='" + table_name + "'");
            }
        } else {
            list.add("update sys_object set status=null where table_name='" + table_name + "'");
            list.add("update sys_objectcols set status=null where table_name='" + table_name + "'");
        }
        dbConnect.runSqlUpdate(list);
        return getSucReturnObject().toString();
    }

    @API(title = "新增数据版本号字段", apiversion = R.ID10023001.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = sys_object.class, method = {"queryObjectColList", "queryObjectList", "queryObjectColListForAdd", "queryColumnSequence"})})
    public String insertDataVersionColumn() throws YosException {
        String table_name = content.getString("table_name").toLowerCase();
        Rows tablerows = dbConnect.runSqlQuery("select * from sys_object where table_name='" + table_name + "'");
        if (tablerows.isEmpty()) {
            return getErrReturnObject().setErrMsg("不存在表" + table_name).toString();
        }
        if (!tablerows.get(0).getString("status").equals("")) {
            return getErrReturnObject().setErrMsg("当前表状态下不可添加数据版本号字段，请先进行应用配置更改").toString();
        }

        String column_name = getdataversioncolumnname(table_name);
        if (dbConnect.runSqlQuery("select * from sys_objectcols where table_name='" + table_name + "' and column_name='" + column_name + "'").isEmpty()) {
            ArrayList<String> sqlist = new ArrayList<>();
            SQLFactory insertCol = new SQLFactory(this, "字段新增");
            insertCol.addParameter("table_name", table_name);
            insertCol.addParameter("column_name", column_name);
            insertCol.addParameter("column_default", "1");
            insertCol.addParameter("column_type", "int");
            insertCol.addParameter("numeric_precision", 10);
            insertCol.addParameter("numeric_scale", 0);
            insertCol.addParameter("column_comment", "数据版本号");
            insertCol.addParameter("column_title", "数据版本号");
            insertCol.addParameter("is_nullable", 0);
            insertCol.addParameter("savedatalog", 0);
            insertCol.addParameter("uniqued", 0);
            insertCol.addParameter("sequence", 3);
            sqlist.add(insertCol.getSQL());
            sqlist.add("update sys_object set status='C' where table_name='" + table_name + "' and ifnull(status,'')=''");
            dbConnect.runSqlUpdate(sqlist);
            cleanTableColumnTitle(table_name, column_name);
            cleanTableColumnNamesMaps(table_name);
            applydbchanges();
        }
        return getSucReturnObject().toString();
    }

    /**
     * 新增修改表字段
     *
     * @return
     */
    @API(title = "新增修改表字段", apiversion = R.ID10000501.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = sys_object.class, method = {"queryObjectColList", "queryObjectList", "queryObjectColListForAdd", "queryColumnSequence"})})
    public String insertormodify_objectcol() throws YosException {
        String table_name = content.getString("table_name").toLowerCase();
        String column_name = content.getString("column_name").toLowerCase();
        boolean issync = content.getBooleanValue("issync");
        if (column_name.equals("") || !String.valueOf(column_name.charAt(0)).matches("^[a-z]*")) {
            return getErrReturnObject().setErrMsg("字段名称必须以英文字母开头").toString();
        }
        if (!column_name.replace("_", "").matches("^[a-z0-9]*")) {
            return getErrReturnObject().setErrMsg("字段名称为英文字母或英文数字组合").toString();
        }
        String column_default = content.getStringValue("column_default");
        String column_type = content.getString("column_type");
        String column_comment = content.getString("column_comment");
        String column_title = content.getString("column_title");
        int numeric_precision = content.getInteger("numeric_precision");
        int numeric_scale = content.getInteger("numeric_scale");
        boolean savedatalog = content.getBooleanValue("savedatalog");
        if (savedatalog) {
            if (dbConnect.runSqlQuery("select column_name from sys_objectcols where table_name='" + table_name + "' and column_name='changeuserid'").isEmpty()) {
                return getErrReturnObject().setErrMsg("添加changeuserid后才可开启数据日志").toString();
            }
        }
        switch (column_type) {
            case "bigint":
            case "datetime": {
                numeric_precision = 19;
                numeric_scale = 0;
                break;
            }
            case "int":
            case "date": {
                numeric_precision = 10;
                numeric_scale = 0;
                break;
            }
            case "smallint": {
                numeric_precision = 5;
                numeric_scale = 0;
                break;
            }
        }
        boolean is_nullable = content.getBooleanValue("is_nullable");
        boolean uniqued = content.getBooleanValue("uniqued");
        Rows sys_objectRows = dbConnect.runSqlQuery("select *from sys_object where table_name='" + table_name + "'");
        if (sys_objectRows.isEmpty()) {
            return getErrReturnObject().setErrMsg(table_name + "表不存在！").toString();
        }
        if (sys_objectRows.get(0).getBoolean("issystem") && !issync) {
            return getErrReturnObject().setErrMsg("系统表不可修改！").toString();
        }
        if (sys_objectRows.get(0).getString("uniquecolumnname").equals(column_name) && !issync) {
            return getErrReturnObject().setErrMsg("表ID字段不可修改").toString();
        }
        if (getdataversioncolumnname(table_name).equalsIgnoreCase(column_name) && !issync) {
            return getErrReturnObject().setErrMsg("数据版本号字段不可修改").toString();
        }
        if (getdataversioncolumnname(table_name).equals(column_name) && !issync) {
            return getErrReturnObject().setErrMsg("当前字段名称为系统保留字段，不可手工添加").toString();
        }
        ArrayList<String> sqllist = new ArrayList<>();
        if (dbConnect.runSqlQuery("select * from sys_objectcols where table_name='" + table_name + "' and column_name='" + column_name + "'").isEmpty()) {
            SQLFactory insertCol = new SQLFactory(this, "字段新增");
            insertCol.addParameter("table_name", table_name);
            insertCol.addParameter("column_name", column_name);
            insertCol.addParameter("column_default", column_default);
            insertCol.addParameter("column_type", column_type);
            if (column_type.equals("text")) {
                insertCol.addParameter("numeric_precision", "null");
                insertCol.addParameter("numeric_scale", 0);
            } else {
                insertCol.addParameter("numeric_precision", numeric_precision);
                insertCol.addParameter("numeric_scale", numeric_scale);
            }
            insertCol.addParameter("column_comment", column_comment);
            insertCol.addParameter("column_title", column_title);
            insertCol.addParameter("is_nullable", is_nullable);
            insertCol.addParameter("savedatalog", savedatalog);
            insertCol.addParameter("uniqued", uniqued);
            insertCol.addParameter("sequence", 3);
            sqllist.add(insertCol.getSQL());
        } else {
            SQLFactory modifyCol = new SQLFactory(this, "字段修改");
            modifyCol.addParameter("table_name", table_name);
            modifyCol.addParameter("column_name", column_name);
            modifyCol.addParameter("column_title", column_title);
            modifyCol.addParameter("column_default", column_default);
            modifyCol.addParameter("column_type", column_type);
            if (column_type.equals("text")) {
                modifyCol.addParameter("numeric_precision", "null");
                modifyCol.addParameter("numeric_scale", 0);
            } else {
                modifyCol.addParameter("numeric_precision", numeric_precision);
                modifyCol.addParameter("numeric_scale", numeric_scale);
            }
            modifyCol.addParameter("numeric_precision", numeric_precision);
            modifyCol.addParameter("numeric_scale", numeric_scale);
            modifyCol.addParameter("column_comment", column_comment);
            modifyCol.addParameter("is_nullable", is_nullable);
            modifyCol.addParameter("savedatalog", savedatalog);
            modifyCol.addParameter("uniqued", uniqued);
            sqllist.add(modifyCol.getSQL());
        }
        sqllist.add("update sys_object set status='C' where table_name='" + table_name + "' and ifnull(status,'')=''");
        dbConnect.runSqlUpdate(sqllist);
        cleanTableColumnTitle(table_name, column_name);
        cleanTableColumnNamesMaps(table_name);
        return getSucReturnObject().toString();
    }

    /**
     * 删除字段
     *
     * @return
     */
    @API(title = "删除字段", apiversion = R.ID10000601.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = sys_object.class, method = {"queryObjectColList", "queryObjectList", "queryObjectColListForAdd", "queryColumnSequence"})})
    public String delete_objectcol() throws YosException {
        String table_name = content.getString("table_name").toLowerCase();
        String column_name = content.getString("column_name").toLowerCase();
        boolean isdelete = content.getBooleanValue("isdelete");
        Rows sys_objectRows = dbConnect.runSqlQuery("select *from sys_object where table_name='" + table_name + "'");
        if (sys_objectRows.isEmpty()) {
            return getErrReturnObject().setErrMsg(table_name + "表不存在！").toString();
        }
        if (sys_objectRows.get(0).getBoolean("issystem")) {
            return getErrReturnObject().setErrMsg("系统表不可修改！").toString();
        }
        if (sys_objectRows.get(0).getString("uniquecolumnname").equals(column_name)) {
            return getErrReturnObject().setErrMsg("表ID字段不可删除").toString();
        }
        Rows rows = dbConnect.runSqlQuery("select * from sys_objectcols where table_name='" + table_name + "' and column_name='" + column_name + "'");
        String oldstatus = rows.get(0).getString("status");
        if (oldstatus.equals("C")) {
            return getErrReturnObject().setErrMsg("当前状态不可删除！").toString();
        }
        ArrayList<String> list = new ArrayList<>();
        if (isdelete) {
            if ("A".equals(oldstatus)) {
                list.add("delete from sys_objectcols where table_name='" + table_name + "' and column_name='" + column_name + "'");
            } else {
                list.add("update sys_objectcols set status='D' where table_name='" + table_name + "' and column_name='" + column_name + "'");
                list.add("update sys_object set status='C' where table_name='" + table_name + "'");
            }
        } else {
            if ("D".equals(oldstatus)) {
                list.add("update sys_objectcols set status=null where table_name='" + table_name + "' and column_name='" + column_name + "'");
            }
        }
        dbConnect.runSqlUpdate(list);
        return getSucReturnObject().toString();
    }

    /**
     * 表字段信息查询
     *
     * @return
     */
    @API(title = "快速添加字段查询", apiversion = R.ID10000701.v1.class)
    @CACHEING
    public String queryObjectColListForAdd() throws YosException {
        String table_name = content.getString("table_name");
        /**
         * 过滤条件设置
         */
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append(" t1.column_name like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.column_comment like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.table_name like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t2.table_comment like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
        }
        SQLFactory selectTableCol = new SQLFactory(this, "快速添加字段查询", pageSize, pageNumber, pageSorting);
        selectTableCol.addParameter("table_name", table_name);
        selectTableCol.addParameter_SQL("where", where);
        Rows tableRows = dbConnect.runSqlQuery(selectTableCol.getSQL());
        return getSucReturnObject().setData(tableRows).toString();
    }

    /**
     * 数据库应用配置更改
     *
     * @return
     */
    @API(title = "数据库应用配置更改", apiversion = R.ID10002001.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = sys_object.class, method = {"queryObjectColList", "queryObjectList", "queryObjectColListForAdd", "queryColumnSequence"})})
    public String applydbchanges() throws YosException {
        String table_name = content.getString("table_name").toLowerCase();
        Rows tablerows = dbConnect.runSqlQuery("select * from sys_object where table_name='" + table_name + "'");
        if (tablerows.isEmpty()) {
            return getErrReturnObject().setErrMsg("不存在的数据表").toString();
        }
        Rows tablecolrows = dbConnect.runSqlQuery("select * from sys_objectcols where table_name='" + table_name + "' and status is not null ");
        Row tableRow = tablerows.get(0);
        String uniquecolumnname = tableRow.getString("uniquecolumnname");
        ArrayList<String> sqllist = new ArrayList<>();
        String tablestatus = tableRow.getString("status");
        String table_comment = tableRow.getString("table_comment");
        switch (tablestatus) {
            case "C": {
                sqllist.add("alter table " + table_name + " comment '" + table_comment + "';");
                for (Row tablecolrow : tablecolrows) {
                    String colstatus = tablecolrow.getString("status");//更改状态
                    String column_name = tablecolrow.getString("column_name");//字段名称
                    String column_type = tablecolrow.getString("column_type");//字段类型
                    int numeric_precision = tablecolrow.getInteger("numeric_precision");//长度
                    int numeric_scale = tablecolrow.getInteger("numeric_scale");//小数位数
                    String column_default = tablecolrow.getString("column_default");//默认值
                    boolean is_nullable = tablecolrow.getBoolean("is_nullable");//是否允许为空
                    String column_comment = tablecolrow.getString("column_comment");//字段备注

                    String type = getColumn_type(column_type, numeric_precision, numeric_scale);

                    //判断字段是否已存在
                    boolean isallreadycolhave = !dbConnect.runSqlQuery("SELECT * FROM INFORMATION_SCHEMA.`COLUMNS` WHERE TABLE_SCHEMA = '" + dbConnect.getDBName() + "' and TABLE_NAME='" + table_name + "' and COLUMN_NAME='" + column_name + "'").isEmpty();

                    switch (colstatus) {
                        case "C":
                        case "A": {
                            if (isallreadycolhave) {
                                if (table_name.equalsIgnoreCase("sys_datalog") && column_name.equalsIgnoreCase("datalogid")) {
                                    sqllist.add("alter table " + table_name + " modify " + column_name + " bigint auto_increment comment '" + column_comment + "';");
                                } else {
                                    sqllist.add("alter table " + table_name + " modify " + column_name + " " + type + (column_default.equals("") ? " " : (" default '" + column_default + "' ")) + (is_nullable ? "null" : "not null") + " comment '" + column_comment + "';");
                                }
                            } else {
                                if (table_name.equalsIgnoreCase("sys_datalog") && column_name.equalsIgnoreCase("datalogid")) {
                                    sqllist.add("alter table " + table_name + " add " + column_name + " bigint auto_increment comment '" + column_comment + "';");
                                } else {
                                    sqllist.add("alter table " + table_name + " add " + column_name + " " + type + (column_default.equals("") ? " " : (" default '" + column_default + "' ")) + (is_nullable ? "null" : "not null") + " comment '" + column_comment + "';");
                                }
                            }
                            break;
                        }
                        case "D": {
                            if (isallreadycolhave) {
                                sqllist.add("alter table " + table_name + " drop column " + column_name + ";");
                            }
                            sqllist.add("delete from sys_objectcols where table_name='" + table_name + "' and  column_name='" + column_name + "';");
                            break;
                        }
                        default:
                            break;
                    }
                }
                break;
            }
            case "A": {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("create table ").append(table_name);
                stringBuffer.append("(");
                for (Row tablecolrow : tablecolrows) {
                    String column_name = tablecolrow.getString("column_name");//字段名称
                    String column_type = tablecolrow.getString("column_type");//字段类型
                    int numeric_precision = tablecolrow.getInteger("numeric_precision");//长度
                    int numeric_scale = tablecolrow.getInteger("numeric_scale");//小数位数
                    String column_default = tablecolrow.getString("column_default");//默认值
                    boolean is_nullable = tablecolrow.getBoolean("is_nullable");//是否允许为空
                    String column_comment = tablecolrow.getString("column_comment");//字段备注
                    String type = getColumn_type(column_type, numeric_precision, numeric_scale);

                    stringBuffer.append(column_name + " " + type + (column_default.equals("") ? " " : (" default '" + column_default + "' ")) + (is_nullable ? "null" : "not null") + " comment '" + column_comment + "',");
                }
                stringBuffer.replace(stringBuffer.length() - 1, stringBuffer.length(), "");
                stringBuffer.append(")");
                stringBuffer.append("comment '" + table_comment + "';");
                sqllist.add(stringBuffer.toString());
                break;
            }
            case "D": {
                //判断表是否已存在
                boolean isallreadytablehave = !dbConnect.runSqlQuery("SELECT TABLE_NAME,TABLE_COMMENT,TABLE_ROWS  FROM information_schema.`TABLES` where TABLE_SCHEMA='" + dbConnect.getDBName() + "' and TABLE_NAME='" + table_name + "'").isEmpty();
                if (isallreadytablehave) {
                    sqllist.add("drop table " + table_name + ";");
                }
                sqllist.add("delete from sys_object where table_name='" + table_name + "';");
                sqllist.add("delete from sys_objectcols where table_name='" + table_name + "';");
                break;
            }
            default:
                break;
        }
        if (sqllist.isEmpty()) {
            return getErrReturnObject().setErrMsg("无可执行的数据库更改").toString();
        }

        /**
         * 数据库备份
         */
//        if (!new MysqlExport(table_name).export()) {
//            return getErrReturnObject().setErrMsg("数据表备份失败！").toString();
//        }
        sqllist.add("update sys_object set status=null,changedate=now() where table_name='" + table_name + "'");
        sqllist.add("update sys_objectcols set status=null where table_name='" + table_name + "'");

        /*
        将当前账号外的其他账号登出
         */
        loguserout();
        /*
         * 将所有数据库连接关闭
         */
        LinkedList<DBConnectPool.YosConnection> list = DBConnectPool.POOLS_MAP.get("default");
        for (DBConnectPool.YosConnection connection : list) {
            try {
                connection.getConnection().close();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        dbConnect.runSqlUpdate(sqllist);
        /*
         * 如果需要保存数据日志，则创建数据保存触发器
         */
        createDataLogTrigger(table_name);
        createDataVersionTrigger(table_name);

        /*
        创建索引
         */
        if (!tablestatus.equals("D")) {
            content.put("issimple", true);
            create_Index();
//            ArrayList<String> sqlist = new ArrayList<>();
//            /* 为表创建主键 */
//            if (!uniquecolumnname.equalsIgnoreCase("") && dbConnect.runSqlQuery("select *from INFORMATION_SCHEMA.KEY_COLUMN_USAGE where TABLE_NAME='" + table_name + "' and CONSTRAINT_NAME='PRIMARY'").isEmpty()) {
//                sqlist.add("alter table " + table_name + " add constraint " + table_name + "_pk primary key (" + uniquecolumnname + ");");
//            }
//
//            Rows colrows = dbConnect.runSqlQuery("select * from sys_objectcols where table_name='" + table_name + "' and column_name!='" + uniquecolumnname + "'");
//            for (Row colrow : colrows) {
//                String column_name = colrow.getString("column_name");
//                boolean uniqued = colrow.getBoolean("uniqued");
//                //判断如果该字段为其他表的唯一id字段，则自动创建索引
//                String uindex_name = column_name + "_uindex";
//                String index_name = column_name + "_index_foreign";
//                String siteid_index_name = "siteid_index";
//                Rows uindexrows = dbConnect.runSqlQuery("select t1.name from INFORMATION_SCHEMA.INNODB_INDEXES t1 inner join INFORMATION_SCHEMA.INNODB_TABLES t2 on t1.TABLE_ID=t2.TABLE_ID where t2.NAME='" + dbConnect.getDBName() + "/" + table_name + "' and t1.name='" + uindex_name + "'; ");
//                Rows indexrows = dbConnect.runSqlQuery("select t1.name from INFORMATION_SCHEMA.INNODB_INDEXES t1 inner join INFORMATION_SCHEMA.INNODB_TABLES t2 on t1.TABLE_ID=t2.TABLE_ID where t2.NAME='" + dbConnect.getDBName() + "/" + table_name + "' and t1.name='" + index_name + "'; ");
//                Rows siteidindexrows = dbConnect.runSqlQuery("select t1.name from INFORMATION_SCHEMA.INNODB_INDEXES t1 inner join INFORMATION_SCHEMA.INNODB_TABLES t2 on t1.TABLE_ID=t2.TABLE_ID where t2.NAME='" + dbConnect.getDBName() + "/" + table_name + "' and t1.name='" + siteid_index_name + "'; ");
//
//                if (uniqued && !indexrows.isEmpty()) {
//                    sqlist.add("drop index " + index_name + " on " + table_name + ";");
//                }
//                if (!uniqued && uindexrows.isNotEmpty()) {/*删除唯一索引*/
//                    sqlist.add("drop index " + uindex_name + " on " + table_name + ";");
//                }
//                if (!uniqued && isTableUniqueColumnName(column_name) && indexrows.isEmpty()) {/*创建外键索引*/
//                    sqlist.add("create index " + index_name + " on " + table_name + " (" + column_name + ");");
//                }
//                if (uniqued && uindexrows.isEmpty()) {
//                    sqlist.add("create unique index " + uindex_name + " on " + table_name + " (" + column_name + ");");
//                }
//                if (column_name.equals("siteid") && siteidindexrows.isEmpty()) {
//                    sqlist.add("create index " + siteid_index_name + " on " + table_name + " (" + column_name + ");");
//                }
//            }
//            if (!sqlist.isEmpty()) {
//                dbConnect.runSqlUpdate(sqlist);
//            }
        }
        return getSucReturnObject().toString();
    }

    /**
     * 创建日志生成触发器
     *
     * @param table_name
     */
    private void createDataLogTrigger(String table_name) throws YosException {
        ArrayList<String> sqllist = new ArrayList<>();

        String[] trigger_names = new String[]{"insert_savedatalog_" + table_name, "update_savedatalog_" + table_name, "delete_savedatalog_" + table_name};
        /*
         * 如果触发器已存在，则先删除该触发器
         */
        for (String trigger_name : trigger_names) {
            if (dbConnect.runSqlQuery("select * from information_schema.TRIGGERS where TRIGGER_SCHEMA='" + dbConnect.getDBName() + "' and TRIGGER_NAME='" + trigger_name + "'").isNotEmpty()) {
                sqllist.add("DROP TRIGGER " + trigger_name + ";");
            }
        }

        boolean iscreatetrigger = true;
        /*
         * 获取当前表需要记录日志的字段
         */
        Rows savedatalogColumns = dbConnect.runSqlQuery("select column_name from sys_objectcols where table_name='" + table_name + "' and savedatalog=1");
        iscreatetrigger = !savedatalogColumns.isEmpty() && iscreatetrigger;

        /*
         * 判断当前表是否存在修改人账号id字段，如不存在，则不允许进行日志记录
         */
        Rows havechangeuserid = dbConnect.runSqlQuery("select column_name from sys_objectcols where table_name='" + table_name + "' and column_name='changeuserid'");
        iscreatetrigger = !havechangeuserid.isEmpty() && iscreatetrigger;

        if (iscreatetrigger) {
            String uniquecolumnname = getuniquecolumnname(table_name);
            for (String trigger_name : trigger_names) {
                if (trigger_name.startsWith("insert")) {
                    StringBuffer newdatastr = new StringBuffer();
                    for (Row savedatalogColumnRow : savedatalogColumns) {
                        String column_name = savedatalogColumnRow.getString("column_name");
                        newdatastr.append("CONCAT('\"" + column_name + "\":\"',ifnull(new." + column_name + ",''),'\",'),");
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(" create TRIGGER ").append(trigger_name).append(" after insert on ").append(table_name).append(" FOR EACH ROW begin ");
                    stringBuffer.append(" insert into sys_datalog( type,table_name, dataid, olddata, newdata, changeuserid, changedate, changeby)");
                    stringBuffer.append(" select 'insert', '").append(table_name).append("',new.").append(uniquecolumnname).append(",").
                            append(" '{}',").
                            append(" CONCAT('{',CONCAT(" + newdatastr.substring(0, newdatastr.length() - 1) + "),CONCAT('\"dataid\":\"',new." + uniquecolumnname + ",'\"'),'}'),").
                            append("new.changeuserid,now(),sys_users.name from sys_users ");
                    stringBuffer.append(" where sys_users.userid=new.changeuserid");
                    stringBuffer.append("; end; ");
                    sqllist.add(stringBuffer.toString());
                } else if (trigger_name.startsWith("update")) {
                    StringBuffer wherestr = new StringBuffer();
                    StringBuffer olddatastr = new StringBuffer();
                    StringBuffer newdatastr = new StringBuffer();
                    for (Row savedatalogColumnRow : savedatalogColumns) {
                        String column_name = savedatalogColumnRow.getString("column_name");
                        if (wherestr.toString().equals("")) {
                            wherestr.append("ifnull(new." + column_name + ",'')!=ifnull(old." + column_name + ",'')");
                        } else {
                            wherestr.append(" OR ifnull(new." + column_name + ",'')!=ifnull(old." + column_name + ",'')");
                        }
                        olddatastr.append("case when ifnull(old." + column_name + ",'')!=ifnull(new." + column_name + ",'') then CONCAT('\"" + column_name + "\":\"',ifnull(old." + column_name + ",''),'\",') else '' end,");
                        newdatastr.append("case when ifnull(old." + column_name + ",'')!=ifnull(new." + column_name + ",'') then CONCAT('\"" + column_name + "\":\"',ifnull(new." + column_name + ",''),'\",') else '' end,");
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(" create TRIGGER ").append(trigger_name).append(" after update on ").append(table_name).append(" FOR EACH ROW begin ");
                    stringBuffer.append(" insert into sys_datalog( type,table_name, dataid, olddata, newdata, changeuserid, changedate, changeby)");
                    stringBuffer.append(" select 'update','").append(table_name).append("',new.").append(uniquecolumnname).append(",").
                            append(" CONCAT('{',CONCAT(" + olddatastr.substring(0, olddatastr.length() - 1) + "),CONCAT('\"dataid\":\"',old." + uniquecolumnname + ",'\"'),'}'),").
                            append(" CONCAT('{',CONCAT(" + newdatastr.substring(0, newdatastr.length() - 1) + "),CONCAT('\"dataid\":\"',new." + uniquecolumnname + ",'\"'),'}'),").
                            append("new.changeuserid,now(),sys_users.name from sys_users ");
                    stringBuffer.append(" where sys_users.userid=new.changeuserid and(" + wherestr + ")");
                    stringBuffer.append("; end; ");
                    sqllist.add(stringBuffer.toString());
                } else if (trigger_name.startsWith("delete")) {
                    StringBuffer olddatastr = new StringBuffer();
                    for (Row savedatalogColumnRow : savedatalogColumns) {
                        String column_name = savedatalogColumnRow.getString("column_name");
                        olddatastr.append("CONCAT('\"" + column_name + "\":\"',ifnull(old." + column_name + ",''),'\",'),");
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(" create TRIGGER ").append(trigger_name).append(" after delete on ").append(table_name).append(" FOR EACH ROW begin ");
                    stringBuffer.append(" insert into sys_datalog(type, table_name, dataid, olddata, newdata, changeuserid, changedate, changeby)");
                    stringBuffer.append(" select 'delete','").append(table_name).append("',old.").append(uniquecolumnname).append(",").
                            append(" CONCAT('{',CONCAT(" + olddatastr.substring(0, olddatastr.length() - 1) + "),CONCAT('\"dataid\":\"',old." + uniquecolumnname + ",'\"'),'}'),").
                            append(" '{}',").
                            append("old.changeuserid,now(),sys_users.name from sys_users ");
                    stringBuffer.append(" where sys_users.userid=old.changeuserid");
                    stringBuffer.append("; end; ");
                    sqllist.add(stringBuffer.toString());
                }
            }
            dbConnect.runSqlUpdate(sqllist);
        }
    }


    /**
     * 创建数据版本触发器
     *
     * @param table_name
     * @throws YosException
     */
    private void createDataVersionTrigger(String table_name) throws YosException {
        String trigger_name = "update_" + table_name + "_dvc";
        String dataversioncolumnname = getdataversioncolumnname(table_name);
        ArrayList<String> sqllist = new ArrayList<>();
        boolean isallreadyhavetrigger = dbConnect.runSqlQuery("select * from information_schema.TRIGGERS where TRIGGER_SCHEMA='" + dbConnect.getDBName() + "' and TRIGGER_NAME='" + trigger_name + "'").isNotEmpty();
        boolean isneedtrigger = dbConnect.runSqlQuery("select * from sys_objectcols where table_name='" + table_name + "' and column_name='" + dataversioncolumnname + "'").isNotEmpty();

        if (isneedtrigger && !isallreadyhavetrigger) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" create TRIGGER ").append(trigger_name).append(" before update on ").append(table_name).append(" FOR EACH ROW begin ");
            stringBuffer.append(" IF NEW.").append(dataversioncolumnname).append(" = OLD.").append(dataversioncolumnname).append(" ");
            stringBuffer.append(" THEN SET NEW.").append(dataversioncolumnname).append(" = NEW.").append(dataversioncolumnname).append(" + 1;");
            stringBuffer.append(" ELSE SIGNAL SQLSTATE '45000' SET MESSAGE_TEXT = 'DataVersion conflict';");
            stringBuffer.append(" END IF");
            stringBuffer.append("; end; ");
            sqllist.add(stringBuffer.toString());
        } else if (!isneedtrigger && isallreadyhavetrigger) {
            sqllist.add("DROP TRIGGER " + trigger_name + ";");
        }
        if (!sqllist.isEmpty()) {
            dbConnect.runSqlUpdate(sqllist);
        }
    }

    private String getColumn_type(String column_type, int numeric_precision, int numeric_scale) {
        if (column_type.equals("varchar")) {
            return "varchar(" + numeric_precision + ")";
        } else if (column_type.equals("decimal")) {
            return "decimal(" + numeric_precision + "," + numeric_scale + ")";
        } else if (column_type.equals("integer")) {
            return "int";
        } else {
            return column_type;
        }
    }

    /**
     * 从数据库提取最新数据结构
     *
     * @return
     */
    @API(title = "从数据库提取最新数据结构", apiversion = R.ID10016801.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = sys_object.class, method = {"queryObjectColList", "queryObjectList", "queryObjectColListForAdd", "queryColumnSequence"})})
    public String refreshDbMsg() throws YosException {
        if (true) {
            return getErrReturnObject().setErrMsg("功能已停用").toString();
        }
        if (!dbConnect.runSqlQuery("select * from  sys_object where status in('A','C','D')").isEmpty()) {
            return getErrReturnObject().setErrMsg("存在未应用的配置更改，不可执行此操作").toString();
        }
        if (!dbConnect.runSqlQuery("select  * from sys_objectcols where status in('A','C','D')").isEmpty()) {
            return getErrReturnObject().setErrMsg("存在未应用的配置更改，不可执行此操作").toString();
        }
        ArrayList<String> sqllist = new ArrayList<>();
        Rows db_tableRows = dbConnect.runSqlQuery("SELECT t1.TABLE_NAME,t1.TABLE_COMMENT,case when t2.table_name is null then 'A'else 'C' end STATUS FROM information_schema.`TABLES` t1\n" +
                "left join sys_object t2 on t1.TABLE_NAME=t2.table_name\n" +
                "where t1.TABLE_SCHEMA='" + dbConnect.getDBName() + "' and (t2.table_name is null or t1.TABLE_COMMENT!=t2.table_comment)");

        Rows db_columnRows = dbConnect.runSqlQuery("select t1.TABLE_NAME,t1.COLUMN_NAME,t1.COLUMN_DEFAULT,t1.NUMERIC_PRECISION,t1.NUMERIC_SCALE,t1.COLUMN_TYPE,t1.COLUMN_COMMENT,t1.IS_NULLABLE,\n" +
                "       case when t2.column_name is null then 'A'else 'C' end STATUS\n" +
                "       from (\n" +
                "                 SELECT TABLE_NAME,\n" +
                "                        COLUMN_NAME,\n" +
                "                        COLUMN_DEFAULT,\n" +
                "                        case\n" +
                "                            when COLUMN_TYPE like '%(%' then REPLACE(\n" +
                "                                    REPLACE(REPLACE(COLUMN_TYPE, SUBSTRING_INDEX(COLUMN_TYPE, '(', '1'), ''), '(', ''),\n" +
                "                                    ')', '')\n" +
                "                            else ifnull(NUMERIC_PRECISION, 0) end       as NUMERIC_PRECISION,\n" +
                "                        ifnull(NUMERIC_SCALE, 0)                        as NUMERIC_SCALE,\n" +
                "                        SUBSTRING_INDEX(COLUMN_TYPE, '(', '1')          as COLUMN_TYPE,\n" +
                "                        COLUMN_COMMENT,\n" +
                "                        case when IS_NULLABLE = 'yes' then 1 else 0 end as IS_NULLABLE\n" +
                "                 FROM information_schema.`COLUMNS`\n" +
                "                 WHERE TABLE_SCHEMA = '" + dbConnect.getDBName() + "'\n" +
                "             )t1\n" +
                "left join sys_objectcols t2 on t1.TABLE_NAME=t2.table_name and t1.COLUMN_NAME=t2.column_name\n" +
                "where t2.column_name is null or t1.column_default!=t2.column_default or t1.NUMERIC_PRECISION!=t2.numeric_precision or t1.NUMERIC_SCALE!=t2.numeric_scale\n" +
                "or t1.COLUMN_TYPE!=t2.column_type or ifnull(t1.COLUMN_COMMENT,'')!=ifnull(t2.column_comment,'') or t1.IS_NULLABLE!=t2.is_nullable");

        if (db_tableRows.isEmpty() && db_columnRows.isEmpty()) {
            return getWarnReturnObject().setWarnMsg("表字段结构正常！").toString();
        }

        for (Row db_tableRow : db_tableRows) {
            String table_name = db_tableRow.getString("TABLE_NAME");
            String table_comment = db_tableRow.getString("TABLE_COMMENT");
            String status = db_tableRow.getString("STATUS");
            if (status.equals("A")) {
                sqllist.add(" insert  into sys_object(table_name, table_comment, issystem, createdate) select '" + table_name + "','" + table_comment + "',1,now() ");
            } else {
                sqllist.add(" update sys_object set table_comment='" + table_comment + "',changedate=now() where table_name='" + table_name + "'");
            }
        }
        for (Row db_columnRow : db_columnRows) {
            String TABLE_NAME = db_columnRow.getString("TABLE_NAME");
            String COLUMN_NAME = db_columnRow.getString("COLUMN_NAME");
            String COLUMN_DEFAULT = db_columnRow.getString("COLUMN_DEFAULT");
            long NUMERIC_PRECISION = db_columnRow.getLong("NUMERIC_PRECISION");
            long NUMERIC_SCALE = db_columnRow.getLong("NUMERIC_SCALE");
            String COLUMN_TYPE = db_columnRow.getString("COLUMN_TYPE");
            String COLUMN_COMMENT = db_columnRow.getString("COLUMN_COMMENT");
            long IS_NULLABLE = db_columnRow.getLong("IS_NULLABLE");
            String STATUS = db_columnRow.getString("STATUS");
            if (STATUS.equals("A")) {
                sqllist.add(" insert into sys_objectcols(table_name, column_name, column_default, numeric_precision, numeric_scale, column_type, column_comment, is_nullable, createdate) select '" + TABLE_NAME + "', '" + COLUMN_NAME + "', '" + COLUMN_DEFAULT + "', '" + NUMERIC_PRECISION + "', '" + NUMERIC_SCALE + "', '" + COLUMN_TYPE + "', '" + COLUMN_COMMENT + "', '" + IS_NULLABLE + "', now()");
            } else {
                sqllist.add(" update sys_objectcols set column_type='" + COLUMN_TYPE + "', column_default='" + COLUMN_DEFAULT + "',numeric_precision='" + NUMERIC_PRECISION + "',numeric_scale='" + NUMERIC_SCALE + "',column_comment='" + COLUMN_COMMENT + "',is_nullable='" + IS_NULLABLE + "',changedate=now() where table_name='" + TABLE_NAME + "' and column_name='" + COLUMN_NAME + "'");
            }
        }
        dbConnect.runSqlUpdate(sqllist);
        return getSucReturnObject().toString();
    }

    @API(title = "表触发器查询", apiversion = R.ID10000801.v1.class)
    public String query_TriggerList() throws YosException {
        SQLFactory sqlFactory = new SQLFactory(this, "表触发器查询");
        sqlFactory.addParameter("table_name", content.getString("table_name"));
        sqlFactory.addParameter("dbname", dbConnect.getDBName());
        Rows rows = dbConnect.runSqlQuery(sqlFactory);
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "表索引查询", apiversion = R.ID10000901.v1.class)
    public String query_IndexList() throws YosException {
        String table_name = content.getString("table_name");
        RowsMap columnmap = getTableColumns(table_name);
        SQLFactory indexsql = new SQLFactory(this, "表索引查询");
        indexsql.addParameter("table_name", dbConnect.getDBName() + "/" + table_name);
        Rows indexrows = dbConnect.runSqlQuery(indexsql.getSQL());
        for (Row indexrow : indexrows) {
            SQLFactory indexcolsql = new SQLFactory(this, "表索引字段查询");
            indexcolsql.addParameter("INDEX_ID", indexrow.getString("INDEX_ID"));
            Rows columns = dbConnect.runSqlQuery(indexcolsql.getSQL());
            for (Row column : columns) {
                String column_name = column.getString("NAME");
                if (columnmap.containsKey(column_name)) {
                    column.put("column_title", columnmap.get(column_name).get(0).getString("column_title"));
                } else {
                    column.put("column_title", "");
                }
            }
            indexrow.put("columns", columns);
        }
        return getSucReturnObject().setData(indexrows).toString();
    }

    @API(title = "表索引删除", apiversion = R.ID10022601.v1.class)
    public String delete_Index() throws YosException {
        String table_name = content.getString("table_name");
        String index_name = content.getString("name");
        if (index_name.equalsIgnoreCase("PRIMARY") || index_name.equalsIgnoreCase("GEN_CLUST_INDEX")) {
            return getErrReturnObject().setErrMsg("该索引不可删除！").toString();
        }
        dbConnect.runSqlUpdate("drop index " + index_name + " on " + table_name + ";");
        return getSucReturnObject().toString();
    }

    @API(title = "表索引创建", apiversion = R.ID10022701.v1.class)
    public String create_Index() throws YosException {
        String table_name = content.getString("table_name");
        boolean issimple = content.getBooleanValue("issimple");
        if (issimple) {
            String uniquecolumnname = getuniquecolumnname(table_name);
            ArrayList<String> sqlist = new ArrayList<>();
            /* 为表创建主键 */
            if (!uniquecolumnname.equalsIgnoreCase("") && dbConnect.runSqlQuery("select *from INFORMATION_SCHEMA.KEY_COLUMN_USAGE where TABLE_NAME='" + table_name + "' and CONSTRAINT_NAME='PRIMARY'").isEmpty()) {
                sqlist.add("alter table " + table_name + " add constraint " + table_name + "_pk primary key (" + uniquecolumnname + ");");
            }
            Rows colrows = dbConnect.runSqlQuery("select * from sys_objectcols where table_name='" + table_name + "' and column_name!='" + uniquecolumnname + "'");
            for (Row colrow : colrows) {
                String column_name = colrow.getString("column_name");
                boolean uniqued = colrow.getBoolean("uniqued");
                //判断如果该字段为其他表的唯一id字段，则自动创建索引
                String uindex_name = column_name + "_uindex";
                String index_name = column_name + "_index_foreign";
                String siteid_index_name = "siteid_index";
                Rows uindexrows = dbConnect.runSqlQuery("select t1.name from INFORMATION_SCHEMA.INNODB_INDEXES t1 inner join INFORMATION_SCHEMA.INNODB_TABLES t2 on t1.TABLE_ID=t2.TABLE_ID where t2.NAME='" + dbConnect.getDBName() + "/" + table_name + "' and t1.name='" + uindex_name + "'; ");
                Rows indexrows = dbConnect.runSqlQuery("select t1.name from INFORMATION_SCHEMA.INNODB_INDEXES t1 inner join INFORMATION_SCHEMA.INNODB_TABLES t2 on t1.TABLE_ID=t2.TABLE_ID where t2.NAME='" + dbConnect.getDBName() + "/" + table_name + "' and t1.name='" + index_name + "'; ");
                Rows siteidindexrows = dbConnect.runSqlQuery("select t1.name from INFORMATION_SCHEMA.INNODB_INDEXES t1 inner join INFORMATION_SCHEMA.INNODB_TABLES t2 on t1.TABLE_ID=t2.TABLE_ID where t2.NAME='" + dbConnect.getDBName() + "/" + table_name + "' and t1.name='" + siteid_index_name + "'; ");

                if (uniqued && !indexrows.isEmpty()) {
                    sqlist.add("drop index " + index_name + " on " + table_name + ";");
                }
                if (!uniqued && uindexrows.isNotEmpty()) {/*删除唯一索引*/
                    sqlist.add("drop index " + uindex_name + " on " + table_name + ";");
                }
                if (!uniqued && isTableUniqueColumnName(column_name) && indexrows.isEmpty()) {/*创建外键索引*/
                    sqlist.add("create index " + index_name + " on " + table_name + " (" + column_name + ");");
                }
                if (uniqued && uindexrows.isEmpty()) {
                    sqlist.add("create unique index " + uindex_name + " on " + table_name + " (" + column_name + ");");
                }
                if (column_name.equals("siteid") && siteidindexrows.isEmpty()) {
                    sqlist.add("create index " + siteid_index_name + " on " + table_name + " (" + column_name + ");");
                }
                if (getColumnType(table_name, column_name).equals("smallint")) {
                    index_name = column_name + "_index";
                    Rows rows = dbConnect.runSqlQuery("select t1.name from INFORMATION_SCHEMA.INNODB_INDEXES t1 inner join INFORMATION_SCHEMA.INNODB_TABLES t2 on t1.TABLE_ID=t2.TABLE_ID where t2.NAME='" + dbConnect.getDBName() + "/" + table_name + "' and t1.name='" + index_name + "'; ");
                    if (rows.isEmpty()) {
                        sqlist.add("create index " + index_name + " on " + table_name + " (" + column_name + ");");
                    }
                }
            }
            if (!sqlist.isEmpty()) {
                dbConnect.runSqlUpdate(sqlist);
            }
        } else {
            String index_name = content.getString("name");
            SQLFactory indexsql = new SQLFactory(this, "表索引查询");
            indexsql.addParameter("table_name", dbConnect.getDBName() + "/" + table_name);
            RowsMap rowsMap = dbConnect.runSqlQuery(indexsql.getSQL()).toRowsMap("name");
            if (rowsMap.containsKey(index_name)) {
                return getErrReturnObject().setErrMsg("索引已存在！").toString();
            }
            JSONArray columns = content.getJSONArray("columns");
            StringBuilder c = new StringBuilder();
            for (Object o : columns) {
                if (c.toString().equals("")) {
                    c.append((String) o);
                } else {
                    c.append(",").append((String) o);
                }
            }
            if (c.toString().equals("")) {
                return getErrReturnObject().setErrMsg("请指定索引字段").toString();
            }
            dbConnect.runSqlUpdate("create index " + index_name + " on " + table_name + " (" + c + ");");
        }
        return getSucReturnObject().toString();
    }

    @API(title = "表索引创建_全部", apiversion = R.ID10024501.v1.class)
    public String create_AllIndex() throws YosException {
        content.put("issimple", 1);
        Rows objectrows = dbConnect.runSqlQuery("select table_name from sys_object where ifnull(status,'')=''");
        for (Row objectrow : objectrows) {
            String table_name = objectrow.getString("table_name");
            content.put("table_name", table_name);
            create_Index();
        }
        return getSucReturnObject().toString();
    }


    @API(title = "表字段排序查询", apiversion = R.ID10001001.v1.class)
    @CACHEING
    public String queryColumnSequence() throws YosException {
        String table_name = content.getString("table_name");
        Rows columnSequenceRows = dbConnect.runSqlQuery("select column_name,column_comment,ROW_NUMBER()over(order by sequence,createdate desc) sequence from sys_objectcols where table_name='" + table_name + "'");
        return getSucReturnObject().setData(columnSequenceRows).toString();
    }

    @API(title = "表字段排序", apiversion = R.ID10001101.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = sys_object.class, method = {"queryObjectList", "queryObjectColList", "queryColumnSequence"})})
    public String updateColumnSequence() throws YosException {
        String table_name = content.getString("table_name");
        JSONArray columnsArray = content.getJSONArray("columns");
        ArrayList<String> sqlist = new ArrayList<>();
        for (Object object : columnsArray) {
            JSONObject columnObject = (JSONObject) object;
            String column_name = columnObject.getString("column_name");
            int sequence = columnObject.getIntValue("sequence");
            sqlist.add("update sys_objectcols set sequence=" + sequence + " where table_name='" + table_name + "' and column_name='" + column_name + "'");
        }
        if (!sqlist.isEmpty()) {
            dbConnect.runSqlUpdate(sqlist);
        }
        return getSucReturnObject().toString();
    }

    @API(title = "数据表应用查询", apiversion = R.ID10001201.v1.class)
    @CACHEING
    public String queryObjectApps() throws YosException {
        String table_name = content.getString("table_name");
        SQLFactory sqlFactory = new SQLFactory(this, "数据表关联应用查询");
        sqlFactory.addParameter("table_name", table_name);
        Rows rows = dbConnect.runSqlQuery(sqlFactory.getSQL());
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "数据表应用选择", apiversion = R.ID10001301.v1.class)
    public String selectObjectApps() throws YosException {
        /**
         * 过滤条件设置
         */
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("t1.systemapp like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.systemappname like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
        }
        String table_name = content.getString("table_name");
        SQLFactory sqlFactory = new SQLFactory(this, "数据表应用选择", pageSize, pageNumber, pageSorting);
        sqlFactory.addParameter("table_name", table_name);
        sqlFactory.addParameter_SQL("where", where);
        Rows rows = dbConnect.runSqlQuery(sqlFactory.getSQL());
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "数据表应用添加", apiversion = R.ID10001401.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = sys_object.class, method = {"queryObjectList", "queryObjectApps"})})
    public String addObjectApps() throws YosException {
        String table_name = content.getString("table_name");
        long systemappid = content.getLong("systemappid");

        SQLFactory sqlFactory = new SQLFactory(this, "数据表关联应用添加");
        sqlFactory.addParameter("sys_objectappsid", createTableID("sys_objectapps"));
        sqlFactory.addParameter("systemappid", systemappid);
        sqlFactory.addParameter("table_name", table_name);
        dbConnect.runSqlUpdate(sqlFactory.getSQL());
        return getSucReturnObject().toString();
    }

    @API(title = "数据表应用删除", apiversion = R.ID10001501.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = sys_object.class, method = {"queryObjectList", "queryObjectApps"})})
    public String deleteObjectApps() throws YosException {
        String sys_objectappsid = content.getString("sys_objectappsid");
        dbConnect.runSqlUpdate("delete from sys_objectapps where sys_objectappsid=" + sys_objectappsid);
        return getSucReturnObject().toString();
    }

    @API(title = "数据表数据查询", apiversion = R.ID10001601.v1.class)
    public String dataquery() throws YosException {
        String sql = content.getStringValue("sql", true).toLowerCase();
        String datakey = content.getString("datakey", "default");
        sql = sql.replace("\\'", "'");
        if (sql.equals("")) {
            return getErrReturnObject().setErrMsg("请输入有效的sql语句").toString();
        }
        Rows rows = null;
        long starttime = Calendar.getInstance().getTimeInMillis();
        try {
            if (datakey.equalsIgnoreCase("sqliteCache")) {
                rows = SQLiteMemory.runSqlQueryWithFieldMeta(sql);
            } else {
                rows = new DBConnect(datakey).runSqlQuery(sql);
            }
        } catch (YosException e) {
            return getErrReturnObject().setErrMsg(e.getMessage()).toString();
        }
        long endtime = Calendar.getInstance().getTimeInMillis();
        JSONObject object = new JSONObject();
        object.put("rows", rows);
        object.put("columns", rows.getFieldList());
        JSONObject metaObject = (JSONObject) JSON.toJSON(rows.getFieldMetaMap());
        for (String fieldname : rows.getFieldMetaMap().keySet()) {
            String tablename = rows.getFieldMeta(fieldname).getTable_name();
            metaObject.getJSONObject(fieldname).put("column_title", getTableColumnTitle(tablename, rows.getFieldMeta(fieldname).getColumn_name()));
            metaObject.getJSONObject(fieldname).put("fieldtype", rows.getFieldMeta(fieldname).getFieldtype().getSimpleName());
        }
        object.put("columnsmeta", metaObject);
        object.put("runtime", (endtime - starttime) / 1000.000);
        return getSucReturnObject().setData(object).toString();
    }

    @API(title = "SQL语句执行过程解释", apiversion = R.ID10022801.v1.class)
    public String SQLExplain() throws YosException {
        String sql = content.getString("sql", true).toLowerCase();
        sql = sql.replace("\\'", "'");
        Rows rows = new DBConnect().runSqlQuery("explain " + sql);
        return getSucReturnObject().setData(rows).toString();
    }


    @API(title = "sql模版查询", apiversion = R.ID10001701.v1.class)
    public String queryTempletSQL() throws YosException {
        long sys_dataquery_sqltempletid = content.getLong("sys_dataquery_sqltempletid");
        Rows rows = dbConnect.runSqlQuery("select * from sys_dataquery_sqltemplet where sys_dataquery_sqltempletid=" + sys_dataquery_sqltempletid);
        if (rows.isNotEmpty()) {
            return getSucReturnObject().setData(rows.get(0)).toString();
        } else {
            return getErrReturnObject().setErrMsg("找不到有效的SQL模板").toString();
        }
    }

    @API(title = "sql模版新增", apiversion = R.ID10001801.v1.class)
    public String insertTempletSQL() throws YosException {
        String templetname = content.getString("templetname");
        String datakey = content.getString("datakey");
        String sqlstr = content.getString("sqlstr", true);
        SQLFactory sqlFactory = new SQLFactory("sql:insert into sys_dataquery_sqltemplet(sys_dataquery_sqltempletid,templetname,datakey,sqlstr) select $sys_dataquery_sqltempletid$,$templetname$,$datakey$,$sqlstr$");
        sqlFactory.addParameter("sys_dataquery_sqltempletid", createTableID("sys_dataquery_sqltemplet"));
        sqlFactory.addParameter("templetname", templetname);
        sqlFactory.addParameter("datakey", datakey);
        sqlFactory.addParameter("sqlstr", sqlstr);
        dbConnect.runSqlUpdate(sqlFactory.getSQL());
        return getSucReturnObject().toString();
    }

    @API(title = "sql模版删除", apiversion = R.ID10001901.v1.class)
    public String deleteTempletSQL() throws YosException {
        long sys_dataquery_sqltempletid = content.getLong("sys_dataquery_sqltempletid");
        dbConnect.runSqlUpdate("delete from sys_dataquery_sqltemplet where sys_dataquery_sqltempletid=" + sys_dataquery_sqltempletid);
        return getSucReturnObject().toString();
    }

    @API(title = "根据datakey查询数据库表结构", apiversion = R.ID10003201.v1.class)
    @CACHEING(life = 5)
    public String queryTableFieldsByDataKey() throws YosException {
        String datakey = content.getString("datakey");
        JSONObject object = new JSONObject();

        switch (datakey) {
            case "default": {
                RowsMap tableRowsMap = dbConnect.runSqlQuery("select table_name,column_name from sys_objectcols").toRowsMap("table_name");
                for (String table_name : tableRowsMap.keySet()) {
                    object.put(table_name, tableRowsMap.get(table_name).toArray("column_name"));
                }
                break;
            }
            case "sqliteCache": {
                RowsMap tableRowsMap = dbConnect.runSqlQuery("select table_name,column_name from sys_cacheobjectcols").toRowsMap("table_name");
                for (String table_name : tableRowsMap.keySet()) {
                    object.put(table_name, tableRowsMap.get(table_name).toArray("column_name"));
                }
                break;
            }
            default: {
                DBConnect dbConnect = new DBConnect(datakey);
                switch (dbConnect.getDBProduct()) {
                    case "MySQL": {
                        RowsMap tableRowsMap = dbConnect.runSqlQuery("SELECT TABLE_NAME, COLUMN_NAME FROM INFORMATION_SCHEMA.`COLUMNS` WHERE TABLE_SCHEMA = '" + dbConnect.getDBName() + "'").toRowsMap("TABLE_NAME");
                        for (String table_name : tableRowsMap.keySet()) {
                            object.put(table_name, tableRowsMap.get(table_name).toArray("COLUMN_NAME"));
                        }
                        break;
                    }
                    case "SQL Server": {
                        RowsMap tableRowsMap = dbConnect.runSqlQuery("select TABLE_NAME,COLUMN_NAME from information_schema.columns").toRowsMap("TABLE_NAME");
                        for (String table_name : tableRowsMap.keySet()) {
                            object.put(table_name, tableRowsMap.get(table_name).toArray("COLUMN_NAME"));
                        }
                        break;
                    }
                    case "Oracle": {
                        break;
                    }
                    default: {
                        break;
                    }
                }
                break;
            }
        }

        return getSucReturnObject().setData(object).toString();
    }
}
