package restcontroller.sysmanage.develop.hotupdate;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.SQLFactory;
import common.parameter.parameter;
import common.websocket.WebSocket;
import org.apache.commons.io.IOUtils;
import restcontroller.R;
import utility.zip.ZipUtil;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;

/**
 * web端热更新
 */
@API(title = "管理端-开发-web端代码热更新管理")
public class webupdate extends Controller {
    public webupdate(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "热更新记录查询", apiversion = R.ID10012601.v1.class)
    public String queryUpdateLog() throws YosException {
        SQLFactory sqlFactory = new SQLFactory(this, "查询更新记录", pageSize, pageNumber, pageSorting);
        sqlFactory.addParameter("porttype", "web");
        Rows rows = dbConnect.runSqlQuery(sqlFactory.getSQL());
        RowsMap attinfosmap = getAttachmentUrl("sys_hotupdate", rows.toArrayList("updateid", new ArrayList<>()));
        for (Row row : rows) {
            row.put("attinfos", attinfosmap.get(row.getString("updateid")));
        }
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "web端热更新", apiversion = R.ID10012701.v1.class)
    public String webUpdate() throws YosException {
        String fnotes = content.getString("fnotes");
        Long attachmentid = content.getLong("attachmentid");
        String filepath = Parameter.get("system_web_path");
        File file = new File(filepath);
        if (!file.exists() && !file.mkdir()) {
            return getErrReturnObject().setErrMsg("web端部署路径创建失败：" + filepath).toString();
        }
        String fileurl = filepath + "/web_update.zip";
        InputStream inputStream = getPostFileInputStream(attachmentid);
        if (inputStream != null) {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(fileurl);
                int ch = 0;
                while ((ch = inputStream.read()) != -1) {
                    fileOutputStream.write(ch);
                }
                fileOutputStream.flush();
            } catch (Exception e) {
                e.printStackTrace();
                return getErrReturnObject().setErrMsg(e.getMessage()).toString();
            } finally {
                IOUtils.closeQuietly(fileOutputStream);
                IOUtils.closeQuietly(inputStream);
            }
            try {
                //如果文件存在中，则删除文件夹下其他文件
                if (new File(fileurl).exists()) {
                    fielDelete(new File(filepath));
                }
                //开始解压web_update文件
                ZipUtil.unZip(fileurl, filepath);

                refreshWebClient(fnotes);
            } catch (Exception e) {
                e.printStackTrace();
                return getErrReturnObject().setErrMsg(e.getMessage()).toString();
            }
        } else {
            return getErrReturnObject().toString();
        }
        long updateid = createTableID("sys_hotupdate");
        SQLFactory sqlFactory = new SQLFactory(this, "插入更新记录");
        sqlFactory.addParameter("updateid", updateid);
        sqlFactory.addParameter("classname", "");
        sqlFactory.addParameter("fnotes", fnotes);
        sqlFactory.addParameter("createby", username);
        sqlFactory.addParameter("porttype", "web");
        sqlFactory.addParameter("status", "已更新");
        sqlFactory.addParameter("updatetime", getDateTime_Str());
        dbConnect.runSqlUpdate(sqlFactory);
        createFileLink("sys_hotupdate", updateid, "default", attachmentid);
        return getSucReturnObject().toString();
    }

    private void fielDelete(File file) {
        if (!file.isFile()) {
            File[] subfiles = file.listFiles();
            if (subfiles != null) {
                for (File subfile : subfiles) {
                    if (subfile.getName().contains("web_update")) {
                        continue;
                    }
                    fielDelete(subfile);
                }
            }
        } else {
            file.delete();
        }
    }

    /**
     * 通知前端刷新web
     */
    public void refreshWebClient(String message) {
        for (long usersiteid : parameter.websocketClients.keySet()) {
            try {
                Iterator<WebSocket> it = parameter.websocketClients.get(usersiteid).values().iterator();
                while (it.hasNext()) {
                    WebSocket webSocket = it.next();
                    if (webSocket.getSystemclient().equalsIgnoreCase("web")) {
                        JSONObject methodobject = new JSONObject();
                        methodobject.put("class", "remind");//提醒
                        methodobject.put("type", "系统");//消息类型
                        methodobject.put("title", "refresh");
                        methodobject.put("message", message);
                        webSocket.sendSystemMessage(methodobject);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}
