package common.parameter;

import com.alibaba.fastjson.JSONObject;
import common.data.Row;
import common.data.Rows;
import common.websocket.WebSocket;

import java.lang.reflect.Method;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 参数及全局数据表
 *
 * @author SHENJW
 */
public class parameter {
    /**
     * token:usersiteid对应表
     */
    public static HashMap<String, Long> tokenlist = new HashMap<String, Long>(16);
    /**
     * token有效期时间戳
     */
    public static HashMap<String, Long> tokenendtimemillis = new HashMap<String, Long>(16);
    /**
     * token:sessionid对应表
     */
    public static HashMap<String, String> tokenSessionidlist = new HashMap<String, String>(16);
    /**
     * token:systemclient对应表
     */
    public static HashMap<String, String> tokensystemclientlist = new HashMap<String, String>(16);
    /**
     * usersiteid:账号信息 对应表
     */
    public static HashMap<Long, Row> usersiteIdList = new HashMap<Long, Row>(16);
    /**
     * 登录 手机号:验证码 对应表
     */
    public static HashMap<String, String> phonenumber_password = new HashMap<String, String>(16);
    /**
     * 登陆 验证码:请求端 对应表
     */
    public static HashMap<String, String> password_systemclient = new HashMap<String, String>(16);
    /**
     * 登录 验证码:有效期 对应表
     */
    public static HashMap<String, Date> phonenumber_date = new HashMap<String, Date>(16);
    //websocket连接池 usersiteid:(token:session)
    public static Map<Long, ConcurrentHashMap<String, WebSocket>> websocketClients = new ConcurrentHashMap<Long, ConcurrentHashMap<String, WebSocket>>();
    /**
     * 账号登陆时间，usersiteid，date
     */
    public static Map<Long, Date> loginDate = new HashMap<Long, Date>();
    /**
     * 接口访问间隔时长校验
     */
    public static Map<Method, Map<String, Long>> APIIntervaltimeCheck = new HashMap<>();


    /**
     * 维护一个全局静态变量
     *
     * @param key
     * @param value
     */
    public static void putStaticVariable(String key, Object value) {
        systemStaticVariable.put(key, value);
    }

    /**
     * 获取一个全局静态变量
     *
     * @param key
     * @return
     */
    public static <T> T getStaticVariable(String key) {
        return (T) systemStaticVariable.get(key);
    }

    private static HashMap<String, Object> systemStaticVariable = new HashMap<>();
}
