package utility.enterpriseonline;

import beans.parameter.Parameter;
import beans.thirdapi.ThirdApi;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.Controller;
import common.YosException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.util.EntityUtils;

import java.util.ArrayList;

/**
 * 天眼查
 */
public class tyc extends BaseClass {

    private static String getToken() {
        try {
            return Parameter.get("tyc_token");
        } catch (Exception e) {
            try {
                Parameter.create(new BaseClass(), "tyc_token", "", "天眼查token");
                return Parameter.get("tyc_token");
            } catch (Exception e2) {
            }
        }
        return "";
    }

    /**
     * 企业搜索
     *
     * @param key
     * @param pageSize
     * @param pageNum
     * @return
     */
    public static ArrayList<Enterprise> search(Controller controller, String key, int pageSize, int pageNum) throws YosException {
        ArrayList<Enterprise> list = new ArrayList<>();
        try {
            String url = "https://open.api.tianyancha.com/services/open/search/2.0?" + "word=" + key + "&pageSize=" + pageSize + "&pageNum=" + pageNum;
            JSONObject resultObject = JSONObject.parseObject(executeGet(url));
            if (resultObject.containsKey("result") && resultObject.getJSONObject("result").getIntValue("total") > 0) {
                JSONArray searchArray = resultObject.getJSONObject("result").getJSONArray("items");
                System.err.println();
                for (int i = 0; i < searchArray.size(); i++) {
                    JSONObject obj = searchArray.getJSONObject(i);
                    Enterprise enterprise = new Enterprise();
                    enterprise.setCompanyName(obj.getStringValue("name"));
                    enterprise.setTaxNum(obj.getStringValue("creditCode"));
                    enterprise.setCreditCode(obj.getStringValue("creditCode"));
                    enterprise.setLegalPerson(obj.getStringValue("legalPersonName"));
                    enterprise.setRegProvince(obj.getStringValue("base"));
                    list.add(enterprise);
                }
            }
            ThirdApi.createLog(controller, "天眼查", "企业搜索", url, resultObject.toJSONString(), 0.01);
        } catch (Exception e) {
            //e.printStackTrace();
        }
        return list;
    }

    /**
     * 企业基本信息查询
     *
     * @param name
     * @return
     */
    public static Enterprise getBaseInfo(Controller controller, String companyName) {
        Enterprise enterprise = new Enterprise();
        try {
            String url = "https://open.api.tianyancha.com/services/open/ic/baseinfoV2/2.0?" + "keyword=" + companyName;
            JSONObject resultObject = JSONObject.parseObject(executeGet(url));
            System.err.println(resultObject);
            if (resultObject.containsKey("result")) {
                JSONObject searchObject = resultObject.getJSONObject("result");
                enterprise.setCompanyName(searchObject.getStringValue("name"));
                enterprise.setTaxNum(searchObject.getStringValue("taxNumber"));
                enterprise.setCreditCode(searchObject.getStringValue("creditCode"));
                enterprise.setAddress(searchObject.getStringValue("regLocation"));
                enterprise.setRegCity(searchObject.getStringValue("city"));
                enterprise.setRegArea(searchObject.getStringValue("district"));
                enterprise.setLegalPerson(searchObject.getStringValue("legalPersonName"));
                enterprise.setPhone(searchObject.getStringValue("phoneNumber"));
                enterprise.setWebsite(searchObject.getStringValue("websiteList"));
                enterprise.setEmail(searchObject.getStringValue("email"));
                enterprise.setStaffNumRange(searchObject.getStringValue("staffNumRange"));
                enterprise.setRegCapital(searchObject.getStringValue("regCapital"));
                enterprise.setRegNumber(searchObject.getStringValue("regNumber"));
                enterprise.setIndustry(searchObject.getStringValue("industry"));
                enterprise.setFromTime(getDate_Str(searchObject.getLongValue("fromTime")));
                enterprise.setToTime(getDate_Str(searchObject.getLongValue("toTime")));
                enterprise.setBusinessScope(searchObject.getStringValue("businessScope"));
            }
            ThirdApi.createLog(controller, "天眼查", "企业基本信息（含企业联系方式）", url, resultObject.toJSONString(), 0.2);
        } catch (Exception e) {
            //e.printStackTrace();
        }
        return enterprise;
    }

    private static String executeGet(String url) {
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout(httpParams, 1000);
        HttpConnectionParams.setSoTimeout(httpParams, 1000);
        HttpClient httpClient = new DefaultHttpClient(httpParams);
        String result = null;
        try {
            HttpGet get = new HttpGet(url);
            // 设置header
            get.setHeader("Authorization", getToken());
            // 设置类型
            HttpResponse response = httpClient.execute(get);
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString(entity, "utf-8");

        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            httpClient.getConnectionManager().shutdown();
        }
        return result;
    }
}
