package restcontroller.system;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.annotation.CACHEING;
import common.data.*;
import restcontroller.R;
import utility.enterpriseonline.Enterprise;
import utility.enterpriseonline.tyc;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;

@API(title = "行政区域查询")
public class tools extends Controller {
    public tools(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "省份查询", accesstoken = false, apiversion = R.ID10002801.v1.class)
    @CACHEING(life = 3600)
    public String query_arealist() throws YosException {
        long countryid = 1;
        if (content.containsKey("countryid")) {
            countryid = content.getLongValue("countryid");
        }

        Rows provincerows = dbConnect.runSqlQuery("select provinceid,province from t_province where countryid=" + countryid + " order by provinceid");
        RowsMap cityrowsMap = dbConnect.runSqlQuery("select cityid,city,provinceid from t_city order by cityid").toRowsMap("provinceid");
        RowsMap countyrowsMap = dbConnect.runSqlQuery("select countyid,county,cityid from t_county order by countyid").toRowsMap("cityid");

        JSONObject provinceObject = new JSONObject(true);
        for (Row provincerow : provincerows) {
            JSONObject cityObject = new JSONObject(true);
            for (Row cityrow : cityrowsMap.get(provincerow.getString("provinceid"))) {
                ArrayList<String> countylist = countyrowsMap.get(cityrow.getString("cityid")).toArrayList("county");
                if (countylist.isEmpty()) {
                    countylist.add("市辖区");
                }
                cityObject.put(cityrow.getString("city"), countylist);
            }
            provinceObject.put(provincerow.getString("province"), cityObject);
        }
        return getSucReturnObject().setData(provinceObject).toString();
    }

    @API(title = "前端日志记录", accesstoken = false, apiversion = R.ID10022501.v1.class)
    public String saveWebClientErrLog() throws YosException {
        if ("true".equals(Parameter.get("system_client_logsave"))) {
            String keyname = content.getString("keyname");
            String log = content.getString("log");
            dbConnect.runSqlUpdate("insert into sys_log(logid,type,keyname,msg,createtime) values(" + createTableID("sys_log") + ",'前端','" + keyname + "','" + log + "',now())");
        }
        return getSucReturnObject().toString();
    }

    @API(title = "根据rowindex查询指定的字段值", apiversion = R.ID10002901.v1.class)
    public String querylistdatabyrowindex() throws YosException {
        String uniqueid = content.getStringValue("uniqueid");//当前数据行的数据id
        int rowindex = content.getIntValue("rowindex");//当前数据行的行号
        boolean forward = content.getBooleanValue("forward");//是否下一条
        boolean ismodify = true;
        if (content.containsKey("ismodify")) {
            ismodify = content.getBoolean("ismodify");//是否已修改，如果前段判断数据没有修改，则不再检查当前数据，前端不传则默认数据都修改
        }
        int newrowindex = forward ? (rowindex + 1) : (rowindex - 1);//需要获取的行号

        String listqueryid = content.getStringValue("listqueryid");
        String fieldname = content.getStringValue("fieldname");

        JSONObject nowobject;
        JSONObject lastobject = new JSONObject();
        if (QuerySQL.QuerySQLMap.containsKey(listqueryid)) {
            if (forward && !uniqueid.equals("") && ismodify) {
                nowobject = querylistdatabyrowindex_get(listqueryid, fieldname, rowindex);
                if (!nowobject.getStringValue("data").equalsIgnoreCase(uniqueid)) {
                    newrowindex = rowindex;//如果当前数据已不满足查询条件，则该行缺位，自动往前补一位
                    lastobject = nowobject;
                }
            }
            if (newrowindex != rowindex) {
                lastobject = querylistdatabyrowindex_get(listqueryid, fieldname, newrowindex);
            }
            lastobject.put("rowindex", newrowindex);
        }
        return getSucReturnObject().setData(lastobject).toString();
    }

    public JSONObject querylistdatabyrowindex_get(String listqueryid, String fieldname, int rowindex) {
        JSONObject object = new JSONObject();
        try {
            QuerySQL querySQL = QuerySQL.QuerySQLMap.get(listqueryid).clone().setPage(1, rowindex);
            Rows rows = querySQL.query(rowindex);
            if (rows.isNotEmpty()) {
                long totalrows = rows.getTotalRows();
                int pagesize = querySQL.pageSize_s;

                object.put("data", fieldname.equals("") ? rows.get(0).getLong(querySQL.uniquecolumnname) : rows.get(0).get(fieldname));

                object.put("pageSize", pagesize);
                object.put("pageNumber", (rowindex + pagesize - 1) / pagesize);

                object.put("total", totalrows);
                object.put("pageTotal", (totalrows + pagesize - 1) / pagesize);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return object;
    }

    @API(title = "创建一个数据id", apiversion = R.ID10025901.v1.class)
    public String createTableDataId() throws YosException {
        String tablename = content.getString("tablename");
        if (dbConnect.runSqlQuery("select * from sys_object where table_name='" + tablename + "'").isEmpty()) {
            return getErrReturnObject().setErrMsg("无效的表名").toString();
        }
        return getSucReturnObject().setData(createTableID(tablename)).toString();
    }



    @API(title = "App请求日志创建", apiversion = R.ID10030001.v1.class)
    public String createAppRequestLog() throws YosException {
        long systemappid = request.getSystemappId();
        if (systemappid > 0) {
            new Thread() {
                @Override
                public void run() {
                    super.run();
                    try {
                        String requesttime = new SimpleDateFormat("HH:mm:ss").format(Calendar.getInstance().getTime());
                        String date = getDate_Str();
                        Rows rows = dbConnect.runSqlQuery("select sys_systemapp_logid from sys_systemapp_log where siteid='" + siteid + "' and userid=" + userid + " and `date`='" + date + "' and systemappid=" + systemappid);
                        if (rows.isEmpty()) {
                            InsertSQL insertSQL = SQLFactory.createInsertSQL(dbConnect, "sys_systemapp_log");
                            insertSQL.setValue("systemappid", systemappid);
                            insertSQL.setValue("userid", userid);
                            insertSQL.setValue("siteid", siteid);
                            insertSQL.setValue("`date`", date);
                            JSONArray requesttimeArray = new JSONArray();
                            requesttimeArray.add(requesttime);
                            insertSQL.setValue("requesttime", requesttimeArray);
                            insertSQL.setValue("times", 1);
                            insertSQL.insert();
                        } else {
                            long sys_systemapp_logid = rows.get(0).getLong("sys_systemapp_logid");
                            dbConnect.runSqlUpdate("update sys_systemapp_log set times=times+1,requesttime=JSON_ARRAY_APPEND(requesttime, '$', '" + requesttime + "') where sys_systemapp_logid=" + sys_systemapp_logid);
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
        return getSucReturnObject().toString();
    }

    @API(title = "企业列表在线查找", intervaltime = 2000, apiversion = R.ID20221208103601.v1.class)
    @CACHEING(life = 1440)
    public String queryEnterpriseListOnline() throws YosException {
        String keyword = content.getString("keyword");
        int pageNumber = content.getIntValue("pageNumber");
        int pageSize = content.getIntValue("pageSize");
        ArrayList<Enterprise> list = tyc.search(this, keyword, pageSize, pageNumber);
        return getSucReturnObject().setData(list).toString();
    }

    @API(title = "企业详情在线查找", intervaltime = 2000, apiversion = R.ID2024060715002601.v1.class)
    @CACHEING(life = 1440)
    public String queryEnterpriseOnline() throws YosException {
        String companyName = content.getString("companyName");
        Enterprise enterprise = tyc.getBaseInfo(this, companyName);
        return getSucReturnObject().setData(enterprise).toString();
    }
}
