select *
from (
         select t1.systemid,
                t1.systemname,
                null     as systemclientid,
                null     as systemclientname,
                null     as systemmoduleid,
                null     as systemmodulename,
                null     as systemappid,
                null     as systemappname,
                'system' as type
         from sys_system t1
         where t1.systemid not in $systemid_up$
         union all
         select t2.systemid,
             t2.systemname,
             t1.systemclientid,
             t1.systemclientname,
             null as systemmoduleid,
             null as systemmodulename,
             null as systemappid,
             null as systemappname,
             'client' as type
         from sys_systemclient t1
             inner join sys_system t2
         on t1.systemid = t2.systemid
         where t1.systemclientid not in $systemclientid_up$
         union all
         select t3.systemid,
             t3.systemname,
             t2.systemclientid,
             t2.systemclientname,
             t1.systemmoduleid,
             t1.systemmodulename,
             null as systemappid,
             null as systemappname,
             'module' as type
         from sys_systemmodule t1
             inner join sys_systemclient t2
         on t1.systemclientid = t2.systemclientid
             inner join sys_system t3 on t2.systemid = t3.systemid
         where t1.systemmoduleid not in $systemmoduleid_up$
         union all
         select t4.systemid,
             t4.systemname,
             t3.systemclientid,
             t3.systemclientname,
             t2.systemmoduleid,
             t2.systemmodulename,
             t1.systemappid,
             t1.systemappname,
             'app' as type
         from sys_systemapp t1
             inner join sys_systemmodule t2
         on t1.systemmoduleid = t2.systemmoduleid
             inner join sys_systemclient t3 on t2.systemclientid = t3.systemclientid
             inner join sys_system t4 on t3.systemid = t4.systemid
         where t1.systemappid not in $systemappid_up$
     ) t
where t.systemid > 0
  and t.systemid not in $systemid$
  and ifnull(t.systemclientid,0) not in $systemclientid$
  and ifnull(t.systemmoduleid,0) not in $systemmoduleid$
  and ifnull(t.systemappid,0) not in $systemappid$