package restcontroller.sysmanage.develop.parameter;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.*;
import restcontroller.R;

@API(title = "系统参数设置")
public class parameter extends Controller {
    public parameter(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "系统参数查询", apiversion = R.ID10014801.v1.class)
    public String queryParameterList() throws YosException {
        Rows rows = dbConnect.runSqlQuery("select * from sys_parameter order by sequence");
        for (Row row : rows) {
            if (row.getString("paramgroup").equals("")) {
                row.put("paramgroup", "其他参数");
            }
        }
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "系统参数新增", apiversion = R.ID10014901.v1.class)
    public String insertParameter() throws YosException {
        String paramname = content.getString("paramname");
        String type = content.getStringValue("type");
        String paramvalue = content.getStringValue("paramvalue", true);
        String remarks = content.getStringValue("remarks");
        String paramgroup = content.getStringValue("paramgroup");
        if (paramname.equals("")) {
            return getErrReturnObject().setErrMsg("参数名称不可为空").toString();
        }
        if (dbConnect.runSqlQuery("select sys_parameterid from sys_parameter where paramname='" + paramname + "'").isNotEmpty()) {
            return getErrReturnObject().setErrMsg("参数名称不可重复").toString();
        }
        if (type.equalsIgnoreCase("boolean")) {
            try {
                content.getBoolean("paramvalue");
            } catch (Exception e) {
                return getErrReturnObject().setErrMsg("参数值不符合指定的参数类型").toString();
            }
        } else if (type.equalsIgnoreCase("number")) {
            try {
                content.getFloatValue("paramvalue");
            } catch (Exception e) {
                return getErrReturnObject().setErrMsg("参数值不符合指定的参数类型").toString();
            }
        }

        InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_parameter");
        insertSQL.setValue("sys_parameterid", createTableID("sys_parameter"));
        insertSQL.setValue("paramname", paramname);
        insertSQL.setValue("paramvalue", paramvalue);
        insertSQL.setValue("remarks", remarks);
        insertSQL.setValue("type", type);
        insertSQL.setValue("paramgroup", paramgroup);
        insertSQL.setValue("changeuserid", userid);
        insertSQL.insert();

        Parameter.cleanSysParameter(paramname);
        return getSucReturnObject().toString();
    }

    @API(title = "系统参数修改", apiversion = R.ID10015001.v1.class)
    public String updateParameter() throws YosException {
        String paramname = content.getString("paramname");
        String type = content.getStringValue("type");
        String paramvalue = content.getString("paramvalue", true);
        String remarks = content.getString("remarks");
        String paramgroup = content.getStringValue("paramgroup");
        if (paramname.equals("")) {
            return getErrReturnObject().setErrMsg("参数名称不可为空").toString();
        }
        if (type.equalsIgnoreCase("boolean")) {
            try {
                content.getBoolean("paramvalue");
            } catch (Exception e) {
                return getErrReturnObject().setErrMsg("参数值不符合指定的参数类型").toString();
            }
        } else if (type.equalsIgnoreCase("number")) {
            try {
                content.getFloatValue("paramvalue");
            } catch (Exception e) {
                return getErrReturnObject().setErrMsg("参数值不符合指定的参数类型").toString();
            }
        }
        if (dbConnect.runSqlQuery("select sys_parameterid from sys_parameter where paramname='" + paramname + "'").isEmpty()) {
            return getErrReturnObject().setErrMsg("找不到指定的系统参数").toString();
        } else {
            UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_parameter");
            updateSQL.setValue("type", type);
            updateSQL.setValue("paramvalue", paramvalue);
            updateSQL.setValue("remarks", remarks);
            updateSQL.setValue("paramgroup", paramgroup);
            updateSQL.setWhere("paramname", paramname);
            updateSQL.update();
        }
        Parameter.cleanSysParameter(paramname);
        return getSucReturnObject().toString();
    }

    @API(title = "系统参数删除", apiversion = R.ID10015101.v1.class)
    public String deleteParameter() throws YosException {
        String paramname = content.getString("paramname");
        dbConnect.runSqlUpdate("delete from sys_parameter where paramname='" + paramname + "'");
        Parameter.cleanSysParameter(paramname);
        return getSucReturnObject().toString();
    }

    @API(title = "系统参数同步", notes = "不包含参数值", apiversion = R.ID10015201.v1.class)
    public String asyncParameter() throws YosException {
        String paramname = content.getString("paramname");
        String remarks = content.getString("remarks");
        String type = content.getStringValue("type");
        String paramgroup = content.getStringValue("paramgroup");

        Rows rows = dbConnect.runSqlQuery("select * from sys_parameter where paramname='" + paramname + "'");
        if (rows.isEmpty()) {
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_parameter");
            insertSQL.setValue("sys_parameterid", createTableID("sys_parameter"));
            insertSQL.setValue("paramname", paramname);
            insertSQL.setValue("paramvalue", "");
            insertSQL.setValue("remarks", remarks);
            insertSQL.setValue("type", type);
            insertSQL.setValue("paramgroup", paramgroup);
            insertSQL.setValue("changeuserid", userid);
            insertSQL.insert();
        } else {
            dbConnect.runSqlUpdate("update sys_parameter set remarks='" + remarks + "',paramgroup='" + paramgroup + "' where paramname='" + paramname + "'");
        }
        return getSucReturnObject().toString();
    }


    @API(title = "获取项目名称", apiversion = R.ID10015301.v1.class)
    public String getProjectName() throws YosException {
        Parameter.create(this, "system_projectname", "YOS", "项目名称");
        return getSucReturnObject().setData(dbConnect.runSqlQuery("select paramvalue from sys_parameter where paramname='system_projectname'")).toString();
    }
}
