package restcontroller.sysmanage.develop.apidoc;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.api.YOSAPI;
import common.data.*;
import common.data.db.SQLiteMemory;
import restcontroller.R;
import utility.tools.Encryption;

import java.util.Calendar;
import java.util.HashMap;

public class apidoc extends Controller {
    public apidoc(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "应用api-应用关联数据表查询", apiversion = R.ID10003601.v1.class)
    public String queryAppTableList() throws YosException {
        long systemappid = content.getLong("systemappid");
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_objectapps").setTableAlias("t1");
        querySQL.addJoinTable(JOINTYPE.inner, "sys_object", "t2", "t1.table_name = t2.table_name");
        querySQL.addQueryFields("t1.sys_objectappsid, t1.systemappid, t1.table_name, t2.table_comment, t2.issystem, t2.uniquecolumnname");
        querySQL.setWhere("t1.systemappid", systemappid);
        querySQL.setOrderBy("t1.sequence");
        Rows rows = querySQL.query();
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "应用api-应用关联数据表添加", apiversion = R.ID10003701.v1.class)
    public String addAppTable() throws YosException {
        long systemappid = content.getLong("systemappid");
        String table_name = content.getString("table_name");
        InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_objectapps");
        insertSQL.setValue("sys_objectappsid", createTableID("sys_objectapps"));
        insertSQL.setValue("systemappid", systemappid).setValue("table_name", table_name);
        insertSQL.setWhere("not exists(select *from sys_objectapps where systemappid=" + systemappid + " and table_name='" + table_name + "')");
        insertSQL.insert();
        return getSucReturnObject().toString();
    }

    @API(title = "应用api-应用关联数据表删除", apiversion = R.ID10003801.v1.class)
    public String deleteAppTable() throws YosException {
        String sys_objectappsid = content.getString("sys_objectappsid");
        dbConnect.runSqlUpdate("delete from sys_objectapps where sys_objectappsid=" + sys_objectappsid);
        return getSucReturnObject().toString();
    }

    @API(title = "应用api-应用关联接口查询", apiversion = R.ID10003901.v1.class)
    public String queryAppApiList() throws YosException {
        long systemappid = content.getLong("systemappid");
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_apiapps").setTableAlias("t1");
        querySQL.addJoinTable(JOINTYPE.left, "sys_api", "t2", "t1.apiid = t2.apiid and t1.apiversion = t2.apiversion");
        querySQL.addQueryFields("t1.sys_apiappsid,t1.systemappid,t1.apiid,t1.apiversion,t1.createflag,t1.lastrequesttime,t2.conditionfields");
        querySQL.setWhere("t1.systemappid", systemappid);
        querySQL.setOrderBy("t1.sequence");
        Rows rows = querySQL.query();
        HashMap<String, String> codermap = getOptionType("coder");
        for (Row row : rows) {
            long apiid = row.getLong("apiid");
            int apiversion = row.getInteger("apiversion");

            row.put("conditionfields", row.getJSONArray("conditionfields"));

            Rows apidocrows = dbConnect.runSqlQuery("select requestjson,requestnotes,responsejson,responsenotes from sys_apidoc where apiid='" + apiid + "' and apiversion='" + apiversion + "'");
            if (apidocrows.isEmpty()) {
                JSONObject requestjsonObject = new JSONObject();
                requestjsonObject.put("accesstoken", Encryption.Encode_MD5(String.valueOf(Calendar.getInstance().getTimeInMillis())));
                requestjsonObject.put("id", apiid);
                requestjsonObject.put("content", new JSONObject());

                row.put("requestjson", requestjsonObject);
                row.put("responsejson", new JSONObject());
                row.put("requestnotes", "");
                row.put("responsenotes", "");
            } else {
                row.put("requestjson", apidocrows.get(0).getJSONObject("requestjson"));
                row.put("responsejson", apidocrows.get(0).getJSONObject("responsejson"));
                row.put("requestnotes", apidocrows.get(0).getString("requestnotes"));
                row.put("responsenotes", apidocrows.get(0).getString("responsenotes"));
            }
            if (apiid > 0) {
                String apiid_str = String.valueOf(apiid);
                row.put("coder", codermap.getOrDefault(apiid_str.substring(apiid_str.length() - 2), ""));
            } else {
                row.put("coder", "");
            }
            try {
                YOSAPI yosapi = YOSAPI.getApi(apiid, apiversion);
                API api = yosapi.getApi();
                String classtitle = "";

                Class clazz = yosapi.getClazz();
                if (clazz.isAnnotationPresent(API.class)) {
                    classtitle = ((API) clazz.getAnnotation(API.class)).title();
                }
                row.put("classname", clazz.getName().replace("restcontroller.", ""));
                row.put("method", yosapi.getMethod().getName());
                row.put("classtitle", classtitle);
                row.put("title", api.title());
                row.put("notes", api.notes());
                row.put("deprecated", api.deprecated() ? 1 : 0);
                row.put("intervaltime", api.intervaltime());
                row.put("intervaltime_active", yosapi.getApiIntervaltime());
                row.put("accesstoken", api.accesstoken());
                row.put("cacheinglife", yosapi.getCacheing() == null ? "" : yosapi.getCacheing().life());

                JSONObject requestmsg = new JSONObject();

                Rows requestRows = SQLiteMemory.runSqlQuery("select count() as requesttimes,sum(t1.iscacheing) as readcachetimes,max(runtime)as maxruntime,round(avg(runtime)) avgruntime,max(t1.createdate) as lastrequesttime,runtime as lastruntime from apirequestlog t1 where t1.classname='" + clazz.getName().replace("restcontroller.", "") + "' and t1.method like'" + yosapi.getMethod().getName() + "' order by t1.createdate desc limit 1");

                requestmsg.put("requesttimes", requestRows.get(0).getLong("requesttimes"));//请求次数
                requestmsg.put("readcachetimes", requestRows.get(0).getLong("readcachetimes"));//缓存读取次数
                requestmsg.put("requesttimelong_last", requestRows.get(0).getLong("lastruntime"));//最新请求时长
                requestmsg.put("requesttimelong_avg", requestRows.get(0).getBigDecimal("avgruntime").longValue());//请求平均时长
                requestmsg.put("lastrequesttime", requestRows.get(0).getString("lastrequesttime"));//最新请求时间
                row.put("requestmsg", requestmsg);
            } catch (YosException e) {
                e.printStackTrace();
                row.put("classtitle", "");
                row.put("classname", "");
                row.put("method", "");
                row.put("title", "");
                row.put("notes", "");
                row.put("intervaltime", "");
                row.put("intervaltime_active", "");
                row.put("accesstoken", "");
                row.put("cacheinglife", "");
                JSONObject requestmsg = new JSONObject();
                requestmsg.put("requesttimes", 0);//请求次数
                requestmsg.put("readcachetimes", 0);//缓存读取次数
                requestmsg.put("requesttimelong_last", 0);//最新请求时长
                requestmsg.put("requesttimelong_avg", 0);//请求平均时长
                requestmsg.put("lastrequesttime", "");//接口最新请求时间
                row.put("requestmsg", requestmsg);
            }
        }
        return getSucReturnObject().setData(rows).toString();
    }


    @API(title = "应用api-应用关联Api添加", apiversion = R.ID10004001.v1.class)
    public String addAppApi() throws YosException {
        long systemappid = content.getLong("systemappid");
        long apiid = content.getLong("apiid");
        int apiversion = content.getIntValue("apiversion") > 0 ? content.getIntValue("apiversion") : 1;

        InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_apiapps");
        insertSQL.setValue("sys_apiappsid", createTableID("sys_apiapps"));
        insertSQL.setValue("systemappid", systemappid).setValue("apiid", apiid).setValue("apiversion", apiversion);
        insertSQL.setWhere("not exists(select *from sys_apiapps where systemappid=" + systemappid + " and apiid=" + apiid + " and apiversion=" + apiversion + ")");
        insertSQL.insert();
        return getSucReturnObject().toString();
    }

    @API(title = "应用api-应用关联Api删除", apiversion = R.ID10004101.v1.class)
    public String deleteAppApi() throws YosException {
        long sys_apiappsid = content.getLong("sys_apiappsid");
        dbConnect.runSqlUpdate("delete from sys_apiapps where sys_apiappsid=" + sys_apiappsid);
        return getSucReturnObject().toString();
    }

    @API(title = "应用api-Api文档更新", apiversion = R.ID10004201.v1.class)
    public String updateApiDoc() throws YosException {
        long apiid = content.getLongValue("apiid");
        int apiversion = content.getIntValue("apiversion");

        JSONObject requestjson = null;
        try {
            requestjson = JSONObject.parseObject(content.getString("requestjson", true), Feature.OrderedField);
        } catch (Exception e) {
            return getErrReturnObject().setErrMsg("请求内容不是有效的JSONObject格式").toString();
        }
        JSONObject responsejson;
        try {
            responsejson = JSONObject.parseObject(content.getString("responsejson"), Feature.OrderedField);
        } catch (Exception e) {
            return getErrReturnObject().setErrMsg("响应内容不是有效的JSONObject格式").toString();
        }

        String requestnotes = content.getString("requestnotes");
        String responsenotes = content.getString("responsenotes");

        if (dbConnect.runSqlQuery("select * from sys_apidoc where apiid='" + apiid + "' and apiversion='" + apiversion + "'").isEmpty()) {
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_apidoc");
            insertSQL.setValue("sys_apidocid", createTableID("sys_apidoc"));
            insertSQL.setValue("apiid", apiid);
            insertSQL.setValue("apiversion", apiversion);
            insertSQL.setValue("requestjson", requestjson.toJSONString());
            insertSQL.setValue("requestnotes", requestnotes);
            insertSQL.setValue("responsejson", responsejson.toJSONString());
            insertSQL.setValue("responsenotes", responsenotes);
            insertSQL.setValue("changeuserid", userid);
            insertSQL.setDateValue("changedate");
            insertSQL.insert();
        } else {
            dbConnect.runSqlUpdate("update sys_apidoc set changedate=now(),changeuserid='" + userid + "', requestjson='" + requestjson.toJSONString() + "',requestnotes='" + requestnotes + "', responsejson='" + responsejson.toJSONString() + "',responsenotes='" + responsenotes + "' where apiid='" + apiid + "' and apiversion='" + apiversion + "'");
        }
        return getSucReturnObject().toString();
    }
}
