package objectregister;

import common.YosException;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_report implements YosObject {
    @Override
    public String table_comment() {
        return "报表管理";
    }

    @Override
    public YosObject.UniqueCol uniquecolumn() {
        return new UniqueCol("sys_reportid", "数据ID");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> arrayList = new ArrayList<>();
        arrayList.add(new VarcharCol("reporttype", "报表类型", 50, "积木报表"));
        arrayList.add(new VarcharCol("name", "报表名称", 50));
        arrayList.add(new VarcharCol("filename", "报表文件名称，birt", 200));
        arrayList.add(new DateTimeCol("createdate", "创建时间"));
        arrayList.add(new DateTimeCol("changedate", "修改时间"));
        arrayList.add(new VarcharCol("type", "报表类型", 20));
        arrayList.add(new BigIntCol("viewcount", "访问次数"));
        return arrayList;
    }

    @Override
    public void DataInit() throws YosException {


    }
}
