package swing.listener;

import swing.controls.YTable;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class YTableListener implements ActionListener, MouseListener, ItemListener {
    protected Container container;
    protected YTable yTable;

    public YTableListener(Container container, YTable yTable) {
        this.container = container;
        this.yTable = yTable;
    }

    /**
     * 下一页
     */
    public void nextPage(ActionEvent e) {
        if (yTable.yTableData != null) {
            try {
                yTable.yTableData.nextPage();
                yTable.setData(yTable.yTableData);
            } catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    /**
     * 上一页
     */
    public void lastPage(ActionEvent e) {
        if (yTable.yTableData != null) {
            try {
                yTable.yTableData.lastPage();
                yTable.setData(yTable.yTableData);
            } catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    /**
     * 每页显示数量选择
     *
     * @param e
     */
    public void pageSizeChange(ActionEvent e) {
        if (yTable.yTableData != null) {
            try {
                yTable.yTableData.setPage(Integer.parseInt(((JComboBox) e.getSource()).getSelectedItem().toString().replace("条/页", "")), 1);
                yTable.setData(yTable.yTableData);
                System.err.println(e);
            } catch (Exception e2) {
                e2.printStackTrace();
            }

        }
    }

    /**
     * 点击鼠标或敲击回车时执行该方法（鼠标悬停在上松开时执行或者敲击回车时执行）
     *
     * @param e
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("nextPage")) {
            nextPage(e);
        } else if (e.getActionCommand().equals("lastPage")) {
            lastPage(e);
        } else if (e.getActionCommand().equals("pageSizeChange")) {
            pageSizeChange(e);
        }
    }

    /**
     * 鼠标点击动作，鼠标悬停在按钮上松开时执行该方法，
     *
     * @param e
     */
    @Override
    public void mouseClicked(MouseEvent e) {
    }

    /**
     * 鼠标点击动作，鼠标按下时执行该方法，
     *
     * @param e
     */
    @Override
    public void mousePressed(MouseEvent e) {
    }

    /**
     * 鼠标点击动作，鼠标松开时执行该方法，不悬停在按钮上也会执行
     */
    @Override
    public void mouseReleased(MouseEvent e) {
    }

    /**
     * 鼠标滑入按钮上空时执行该方法
     */
    @Override
    public void mouseEntered(MouseEvent e) {
    }

    /**
     * 鼠标滑出按钮上空时执行该方法
     *
     * @param e
     */
    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {

    }
}
